/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReaderHelper {
    private static final Logger logger = Logger.getLogger(ReaderHelper.class);
    private BufferedReader reader;
    private int lastReadInt;
    private String nextLine;

    public ReaderHelper(BufferedReader reader) {
        this.reader = reader;
    }

    public String getStringUntilNextSpaceOrTab() throws IOException {
        char nextChar;
        StringBuilder chars = new StringBuilder();
        boolean haveHadNonWhiteChars = false;
        while (!ReaderHelper.isWhiteSpace(nextChar = this.readChar()) || !haveHadNonWhiteChars) {
            chars.append(nextChar);
            haveHadNonWhiteChars = true;
        }
        return chars.toString();
    }

    public String getStringFromNextPositions(int count) throws IOException {
        StringBuilder chars = new StringBuilder();
        for (int n = 0; n < count; ++n) {
            char nextChar = this.readChar();
            if (!ReaderHelper.isPhylipNameChar(nextChar)) continue;
            chars.append(nextChar);
        }
        return chars.toString();
    }

    public String getNonWhiteCharsUntilNextLineOrEOF() throws IOException {
        StringBuilder chars = new StringBuilder();
        try {
            char nextChar;
            while (!ReaderHelper.isNewline(nextChar = this.readChar())) {
                if (ReaderHelper.isWhiteSpaceNotNewline(nextChar)) continue;
                chars.append(nextChar);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return chars.toString();
    }

    public byte[] getNonWhiteBytes(int count) throws IOException {
        byte[] bytes = new byte[count];
        int counter = 0;
        while (counter < count) {
            int nextInt = this.read();
            if (ReaderHelper.isWhiteSpace(nextInt)) continue;
            bytes[counter] = (byte)nextInt;
            ++counter;
        }
        return bytes;
    }

    public String getNonWhiteCharsUntilNextOrEOF(char targetChar, int nextSeqSizeEstimate) throws IOException {
        StringBuilder chars = new StringBuilder(nextSeqSizeEstimate);
        try {
            char nextChar;
            while ((nextChar = this.readChar()) != targetChar) {
                if (ReaderHelper.isWhiteSpace(nextChar)) continue;
                chars.append(nextChar);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return chars.toString();
    }

    public char readChar() throws IOException {
        return (char)this.read();
    }

    public int read() throws IOException {
        this.lastReadInt = this.reader.read();
        if (this.lastReadInt == -1) {
            throw new EOFException();
        }
        return this.lastReadInt;
    }

    public boolean isEOF() {
        return this.lastReadInt == -1;
    }

    public void skipPastNextline() throws IOException {
        while (this.readChar() != '\n') {
        }
    }

    public void skipPastNext(char c) throws IOException {
        while (this.readChar() != c) {
        }
    }

    public void readNextLine() throws IOException {
        this.nextLine = this.reader.readLine();
    }

    public String getNextLine() throws IOException {
        return this.nextLine;
    }

    public boolean isNextLineEOF() throws IOException {
        return this.nextLine == null;
    }

    public boolean isNextLineContainingNonWhitespaceChars() throws IOException {
        if (this.isNextLineEOF()) {
            return false;
        }
        return ReaderHelper.isStringContainingNonWhitespaceChars(this.nextLine);
    }

    public boolean isNextLineEmptyOrOnlyWhitespaceChars() throws IOException {
        if (this.isNextLineEOF()) {
            return false;
        }
        return !ReaderHelper.isStringContainingNonWhitespaceChars(this.nextLine);
    }

    public boolean isNextLineStartingWithNonBlankChar() {
        return this.nextLine != null && this.nextLine.length() > 0 && !ReaderHelper.isWhiteSpace(this.nextLine.charAt(0));
    }

    public void readUntilNextNonBlankLine() throws IOException {
        this.readNextLine();
        while (this.isNextLineEmptyOrOnlyWhitespaceChars()) {
            this.readNextLine();
        }
    }

    public boolean readUntilNextLineContains(String target) throws IOException {
        this.readNextLine();
        while (!this.isNextLineEOF()) {
            if (StringUtils.containsIgnoreCase(this.nextLine, target)) {
                return true;
            }
            this.readNextLine();
        }
        return false;
    }

    private static boolean isPhylipNameChar(char c) {
        return c != '\t' && c != '\r' && c != '\n';
    }

    private static boolean isWhiteSpace(int c) {
        return ReaderHelper.isWhiteSpace((char)c);
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private static boolean isWhiteSpaceNotNewline(char c) {
        return c == ' ' || c == '\t' || c == '\r';
    }

    private static boolean isNewline(char c) {
        return c == '\n';
    }

    public static boolean isStringContainingNonWhitespaceChars(String input) {
        if (input == null) {
            return false;
        }
        for (int n = 0; n < input.length(); ++n) {
            if (ReaderHelper.isWhiteSpace(input.charAt(n))) continue;
            return true;
        }
        return false;
    }

    public static String removeSpace(String text) {
        if (text.indexOf(32) > -1) {
            text = StringUtils.remove(text, ' ');
        }
        return text;
    }

    public static String removeTab(String text) {
        if (text.indexOf(9) > -1) {
            text = StringUtils.remove(text, '\t');
        }
        return text;
    }

    public static String removeSpaceAndTab(String text) {
        text = ReaderHelper.removeSpace(text);
        text = ReaderHelper.removeTab(text);
        return text;
    }

    public static int indexOfFirstNonWhiteCharAfterWhiteChar(String text) {
        boolean whiteFound = false;
        int index = -1;
        for (int n = 0; n < text.length(); ++n) {
            if (ReaderHelper.isWhiteSpace(text.charAt(n))) {
                whiteFound = true;
            }
            if (!whiteFound || ReaderHelper.isWhiteSpace(text.charAt(n))) continue;
            index = n;
            break;
        }
        return index;
    }

    public static int indexOfFirstNonWhiteChar(String text) {
        int index = -1;
        for (int n = 0; n < text.length(); ++n) {
            if (ReaderHelper.isWhiteSpace(text.charAt(n))) continue;
            index = n;
            break;
        }
        return index;
    }
}

