/*
 * Decompiled with CFR 0.152.
 */
package aliview.phenotype2genotype;

import aliview.AminoAcid;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class Image2AscII {
    private static final Logger logger = Logger.getLogger(Image2AscII.class);
    private static Color[] aminoAcidBackgroundColor;
    private static final String LF;

    public static void main(String[] args) {
        try {
            Image2AscII.createAscFile(new File("/home/anders/projekt/image2asc/IMG_1850.jpeg"), new File("/home/anders/projekt/image2asc/IMG_1850.fasta"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createAscFile(File imageFile, File outputFile) throws IOException {
        BufferedImage image = Image2AscII.readImage(imageFile);
        StringBuilder output = new StringBuilder();
        output.append(">protein" + LF + "QQXX" + LF);
        for (int y = 0; y < image.getHeight(); ++y) {
            output.append(">Seq_" + y + LF);
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                char charVal = Image2AscII.getAminoAcidFromColor(rgb);
                output.append(charVal);
            }
            output.append(LF);
        }
        FileUtils.writeStringToFile(outputFile, output.toString());
    }

    private static char getByteFromRGBColor(Color inColor) {
        for (int n = 0; n < aminoAcidBackgroundColor.length; ++n) {
            Color col = aminoAcidBackgroundColor[n];
            if (col == null || !col.equals(inColor)) continue;
            return (char)n;
        }
        return '.';
    }

    public static BufferedImage readImage(File imageFile) throws IOException {
        FileInputStream in = new FileInputStream(imageFile);
        ImageInputStream iin = ImageIO.createImageInputStream(in);
        ImageReader reader = ImageIO.getImageReaders(iin).next();
        reader.setInput(iin, true, true);
        BufferedImage image = reader.read(0);
        return image;
    }

    public static char getAminoAcidFromColor(int rgbColor) {
        int maxVal = Color.green.getRGB();
        int numberOfAA = AminoAcid.GROUP_ALL.length - 1;
        int fraction = maxVal / numberOfAA;
        int aaVal = rgbColor / fraction;
        return AminoAcid.GROUP_ALL[aaVal].getCodeCharVal();
    }

    public static Color getClosestColor(Color target) {
        Color nearestColor = null;
        double nearestDistance = Double.MAX_VALUE;
        for (int n = 0; n < aminoAcidBackgroundColor.length; ++n) {
            double testDistance;
            Color constantColor = aminoAcidBackgroundColor[n];
            if (constantColor == null || !((testDistance = Math.pow(target.getRed() - constantColor.getRed(), 2.0) + Math.pow(target.getGreen() - constantColor.getGreen(), 2.0) + Math.pow(target.getBlue() - constantColor.getBlue(), 2.0)) < nearestDistance)) continue;
            nearestDistance = testDistance;
            nearestColor = constantColor;
        }
        return nearestColor;
    }

    static {
        LF = System.getProperty("line.separator");
        aminoAcidBackgroundColor = new Color[255];
        Image2AscII.aminoAcidBackgroundColor[65] = new Color(2584247);
        Image2AscII.aminoAcidBackgroundColor[67] = new Color(15106176);
        Image2AscII.aminoAcidBackgroundColor[68] = new Color(0xCC4DCC);
        Image2AscII.aminoAcidBackgroundColor[69] = new Color(9978007);
        Image2AscII.aminoAcidBackgroundColor[70] = new Color(1671398);
        Image2AscII.aminoAcidBackgroundColor[71] = new Color(15112525);
        Image2AscII.aminoAcidBackgroundColor[72] = new Color(1684403);
        Image2AscII.aminoAcidBackgroundColor[73] = new Color(5153011);
        Image2AscII.aminoAcidBackgroundColor[75] = new Color(15086361);
        Image2AscII.aminoAcidBackgroundColor[76] = new Color(7907029);
        Image2AscII.aminoAcidBackgroundColor[77] = new Color(1004699);
        Image2AscII.aminoAcidBackgroundColor[78] = new Color(0x19CC19);
        Image2AscII.aminoAcidBackgroundColor[80] = new Color(0xCCCC00);
        Image2AscII.aminoAcidBackgroundColor[81] = new Color(6090076);
        Image2AscII.aminoAcidBackgroundColor[82] = new Color(16139308);
        Image2AscII.aminoAcidBackgroundColor[83] = new Color(169474);
        Image2AscII.aminoAcidBackgroundColor[84] = new Color(4573509);
        Image2AscII.aminoAcidBackgroundColor[86] = new Color(294393);
        Image2AscII.aminoAcidBackgroundColor[87] = new Color(218537);
        Image2AscII.aminoAcidBackgroundColor[89] = new Color(1361608);
        Image2AscII.aminoAcidBackgroundColor[120] = Color.DARK_GRAY;
        Image2AscII.aminoAcidBackgroundColor[45] = new Color(230, 230, 230);
    }
}

