/*
 * Decompiled with CFR 0.152.
 */
package aliview.primer;

import aliview.NucleotideUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dimer {
    private static int minDimerReportLength = 5;
    private static final int NUMBER_OF_ONE_BASE_GAPS_ALLOWED = 1;
    private static final Logger logger = Logger.getLogger(Dimer.class);
    String sequence1;
    String sequence2;

    public static void main(String[] args) {
        String seq1 = "CCCATGGGGTGTGCAAGTTCGTTGTG";
        String seq2 = "ACACWGCAACTTGCACACCATA";
        new Dimer(seq1, seq2).getAllDimers();
    }

    public Dimer(String seq1, String seq2) {
        this.sequence1 = seq1;
        this.sequence2 = seq2;
    }

    public static int getDimerLengthThreashold() {
        return minDimerReportLength;
    }

    public ArrayList<DimerResult> get3EndDimer() {
        ArrayList<DimerResult> end3Dimers = new ArrayList<DimerResult>();
        ArrayList<DimerResult> allDimers = this.getAllDimers(this.sequence1, this.sequence2, Dimer.getDimerLengthThreashold(), 1);
        for (DimerResult dimer : allDimers) {
            if (!dimer.is3EndDimer()) continue;
            end3Dimers.add(dimer);
        }
        return end3Dimers;
    }

    public ArrayList<DimerResult> getAllDimers() {
        ArrayList<DimerResult> allDimers = this.getAllDimers(this.sequence1, this.sequence2, Dimer.getDimerLengthThreashold(), 1);
        return allDimers;
    }

    public int get3EndDimerMaxLength() {
        ArrayList<DimerResult> all3Dimers = this.get3EndDimer();
        int maxLen = 0;
        for (DimerResult dimer : all3Dimers) {
            maxLen = Math.max(dimer.getDimerLength(), maxLen);
        }
        return maxLen;
    }

    public int getDimerMaxLength() {
        ArrayList<DimerResult> allDimers = this.getAllDimers();
        int maxLen = 0;
        for (DimerResult dimer : allDimers) {
            maxLen = Math.max(dimer.getDimerLength(), maxLen);
        }
        return maxLen;
    }

    public ArrayList<String> getAllDimersAsText() {
        ArrayList<DimerResult> allDimers = this.getAllDimers();
        ArrayList<String> allText = new ArrayList<String>();
        for (DimerResult dimer : allDimers) {
            String[] dimerText;
            for (String text : dimerText = dimer.getDimerAsText()) {
                allText.add(text);
            }
            allText.add("");
            allText.add("");
        }
        return allText;
    }

    private ArrayList<DimerResult> getAllDimers(String seq1, String seq2, int minDimerLen, int numberOfOneBaseGapsAllowed) {
        ArrayList<DimerResult> allDimers = new ArrayList<DimerResult>();
        for (int n1 = -seq2.length(); n1 < seq1.length(); ++n1) {
            DimerResult dimerResult = null;
            int numberOfOneBaseGapsFound = 0;
            for (int n2 = 0; n2 < seq2.length(); ++n2) {
                int primer1CharPos = n1 + n2;
                int primer2CharPos = n2;
                if (primer1CharPos >= 0 && primer1CharPos < seq1.length()) {
                    int charDimerVal;
                    char n1Char = '-';
                    char n2Char = '-';
                    if (primer1CharPos >= 0 && primer1CharPos < seq1.length()) {
                        n1Char = seq1.charAt(primer1CharPos);
                    }
                    if (primer2CharPos >= 0 && primer2CharPos < seq2.length()) {
                        n2Char = seq2.charAt(primer2CharPos);
                    }
                    if ((charDimerVal = NucleotideUtilities.getDimerBinding(n1Char, n2Char)) >= 1) {
                        if (dimerResult == null) {
                            dimerResult = new DimerResult(seq1, seq2);
                            dimerResult.setDimerStartPos(primer1CharPos, primer2CharPos);
                        }
                        dimerResult.setPrimer1EndPos(primer1CharPos);
                        dimerResult.setPrimer2EndPos(primer2CharPos);
                        dimerResult.addCharDimerValue(charDimerVal);
                        continue;
                    }
                    if (numberOfOneBaseGapsAllowed > numberOfOneBaseGapsFound) {
                        ++numberOfOneBaseGapsFound;
                        continue;
                    }
                    if (dimerResult != null && dimerResult.getDimerLengthWithoutAnyGaps() >= minDimerLen) {
                        allDimers.add(dimerResult);
                    }
                    dimerResult = null;
                    numberOfOneBaseGapsFound = 0;
                    continue;
                }
                if (dimerResult != null && dimerResult.getDimerLengthWithoutAnyGaps() >= minDimerLen) {
                    allDimers.add(dimerResult);
                }
                dimerResult = null;
                numberOfOneBaseGapsFound = 0;
            }
        }
        Collections.reverse(allDimers);
        return allDimers;
    }

    public static final void setDimerLengthThreashold(int length) {
        minDimerReportLength = length;
    }

    class DimerResult {
        int primer1StartPos;
        int primer1EndPos;
        int primer2StartPos;
        int primer2EndPos;
        String sequence1;
        String sequence2;
        double totalDimerValue;
        String dimerBindString = "";
        ArrayList<Double> dimerValues = new ArrayList();

        public DimerResult(String seq1, String seq2) {
            this.sequence1 = seq1;
            this.sequence2 = seq2;
        }

        public void setDimerStartPos(int primer1StartPos, int primer2StartPos) {
            this.primer1StartPos = primer1StartPos;
            this.primer2StartPos = primer2StartPos;
            this.primer1EndPos = primer1StartPos;
            this.primer2EndPos = primer2StartPos;
        }

        public int getDimerLength() {
            return Math.abs(this.primer1StartPos - this.primer1EndPos) + 1;
        }

        public int getDimerLengthWithoutAnyGaps() {
            String dimerBind = this.getBindString();
            return StringUtils.countMatches(dimerBind, "|");
        }

        public void addCharDimerValue(double charDimerVal) {
            this.totalDimerValue += charDimerVal;
            this.dimerValues.add(new Double(charDimerVal));
        }

        public void setPrimer1EndPos(int primer1EndPos) {
            this.primer1EndPos = primer1EndPos;
        }

        public int getPrimer1EndPos() {
            return this.primer1EndPos;
        }

        public int getPrimer2EndPos() {
            return this.primer2EndPos;
        }

        public void setPrimer2EndPos(int primer2EndPos) {
            this.primer2EndPos = primer2EndPos;
        }

        public int getPrimer1StartPos() {
            return this.primer1StartPos;
        }

        public int getPrimer2StartPos() {
            return this.primer2StartPos;
        }

        public void setPrimer1StartPos(int primer1StartPos) {
            this.primer1StartPos = primer1StartPos;
        }

        public String[] getDimerAsText() {
            int diff = this.getPrimer2StartPos() - this.getPrimer1StartPos();
            String primer1Line = this.createNewBlankString(diff) + "" + this.sequence1 + " 3\"";
            diff = this.getPrimer1StartPos() - this.getPrimer2StartPos();
            String primer2Line = this.createNewBlankString(diff) + "" + this.sequence2 + " 5\"";
            diff = Math.max(this.getPrimer1StartPos(), this.getPrimer2StartPos());
            String bindString = this.createNewBlankString(diff) + this.getBindString();
            String[] dimerBindAsText = new String[]{primer1Line, bindString, primer2Line};
            return dimerBindAsText;
        }

        private String createNewBlankString(int n) {
            if (n <= 0) {
                return "";
            }
            char[] blanks = new char[n];
            Arrays.fill(blanks, ' ');
            return new String(blanks);
        }

        private String getBindString() {
            StringBuilder binding = new StringBuilder();
            for (int n = 0; n < this.getDimerLength(); ++n) {
                int bindVal = NucleotideUtilities.getDimerBinding(this.sequence1.charAt(this.getPrimer1StartPos() + n), this.sequence2.charAt(this.getPrimer2StartPos() + n));
                if (bindVal >= 1) {
                    binding.append('|');
                    continue;
                }
                binding.append(' ');
            }
            return binding.toString();
        }

        public int getPrimer1MinPos() {
            return Math.min(this.getPrimer1StartPos(), this.getPrimer1EndPos());
        }

        public int getPrimer1MaxPos() {
            return Math.max(this.getPrimer1StartPos(), this.getPrimer1EndPos());
        }

        public int getPrimer2MinPos() {
            return Math.min(this.getPrimer2StartPos(), this.getPrimer2EndPos());
        }

        public int getPrimer2MaxPos() {
            return Math.max(this.getPrimer2StartPos(), this.getPrimer2EndPos());
        }

        public boolean is3EndDimer() {
            return this.getPrimer1MaxPos() == this.sequence1.length() - 1 && this.getPrimer2MinPos() == 0;
        }
    }
}

