/*
 * Decompiled with CFR 0.152.
 */
package aliview.primer;

import aliview.NucleotideUtilities;
import aliview.color.ColorScheme;
import aliview.color.DefaultColorScheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import utils.OSNativeUtils;

public class PrimerDisplay
extends JComponent {
    double charWidth = 7.0;
    double charHeight = 9.0;
    ColorScheme colorScheme = new DefaultColorScheme();
    private Font baseFont = new Font(OSNativeUtils.getMonospacedFontName(), 0, (int)this.charWidth);
    private String sequence;

    public PrimerDisplay(String sequence) {
        this.sequence = sequence;
        this.setFont(this.baseFont);
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension(100, 30);
        return prefSize;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int x = 0; x < this.sequence.length(); ++x) {
            char baseChar = this.sequence.charAt(x);
            int baseVal = NucleotideUtilities.baseValFromChar(baseChar);
            char[] nucleotidesInThisXpos = NucleotideUtilities.nucleotideCharsFromBaseVal(baseVal);
            for (int y = 0; y < nucleotidesInThisXpos.length; ++y) {
                int nucleotideBaseVal = NucleotideUtilities.baseValFromChar(nucleotidesInThisXpos[y]);
                Color baseBackgroundColor = this.colorScheme.getBaseBackgroundColor(nucleotideBaseVal);
                Color baseForegroundColor = this.colorScheme.getBaseForegroundColor(nucleotideBaseVal);
                g.setColor(baseBackgroundColor);
                g.fillRect((int)((double)x * this.charWidth), (int)((double)y * this.charHeight), (int)this.charWidth, (int)this.charHeight);
                g.setColor(baseForegroundColor);
                if (!(this.charHeight > 3.0)) continue;
                g.drawChars(nucleotidesInThisXpos, y, 1, (int)((double)x * this.charWidth), (int)((double)y * this.charHeight + this.charHeight));
            }
        }
    }
}

