/*
 * Decompiled with CFR 0.152.
 */
package aliview.primer;

import aliview.AliViewWindow;
import aliview.gui.AppIcons;
import aliview.primer.ComponentCellRenderer;
import aliview.primer.Primer;
import aliview.primer.PrimerDetailFrame;
import aliview.primer.PrimerPanel;
import aliview.primer.PrimerResultTableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimerResultsFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(PrimerResultsFrame.class);
    private static final int MAX_NUMBER_OF_PRIMERS_REPORTED = 1000;
    JPanel mainPanel = new JPanel();
    private final AliViewWindow aliViewWindow;
    JTable mainTable;
    PrimerDetailFrame primerDetailFrame;
    private ArrayList<Primer> primerResult;

    public PrimerResultsFrame(ArrayList<Primer> primRes, AliViewWindow aliViewWin) {
        this.aliViewWindow = aliViewWin;
        this.primerResult = primRes;
        DefaultTableModel tm = new DefaultTableModel(PrimerResultTableRow.getColumnHeaders().toArray(), 0);
        this.mainTable = new JTable(tm);
        this.mainTable.setSelectionMode(0);
        this.mainTable.setRowHeight(44);
        this.mainTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PrimerResultsFrame.this.displaySelectedPrimerDetailWindow();
                }
            }
        });
        this.mainTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    logger.info("copy Primer To clipboard");
                    int colIndex = 0;
                    if (PrimerResultsFrame.this.mainTable.getSelectedColumn() == colIndex) {
                        PrimerPanel selected = (PrimerPanel)PrimerResultsFrame.this.mainTable.getModel().getValueAt(PrimerResultsFrame.this.mainTable.getSelectedRow(), 0);
                        String data = selected.getPrimer().getPrimerDetailsAsText();
                        System.out.println(data);
                    }
                }
                PrimerResultsFrame.this.displaySelectedPrimerDetailWindow();
            }
        });
        Enumeration<TableColumn> enu = this.mainTable.getColumnModel().getColumns();
        while (enu.hasMoreElements()) {
            TableColumn col = enu.nextElement();
            col.setCellRenderer(new ComponentCellRenderer());
            col.setCellEditor(new ComponentCellRenderer());
        }
        for (int n = 0; n < this.mainTable.getColumnModel().getColumnCount(); ++n) {
            this.mainTable.getColumnModel().getColumn(n).setPreferredWidth(PrimerResultTableRow.getColumnSizes().get(n));
        }
        JScrollPane scrollPane = new JScrollPane(this.mainTable, 20, 30);
        this.getContentPane().add((Component)scrollPane, "Center");
        int nCount = 0;
        for (Primer primer : primRes) {
            if (primer.getScore() > 1000L || nCount >= 1000) continue;
            tm.addRow(new PrimerResultTableRow(primer).getRow().toArray());
            ++nCount;
        }
        this.setTitle("Primer finds");
        this.setIconImage(AppIcons.getProgramIconImage());
        this.setPreferredSize(new Dimension(700, 400));
        this.placeFrameupperLeftLocationOfThis(aliViewWin);
        this.pack();
        this.setVisible(true);
    }

    public void placeFrameupperLeftLocationOfThis(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + 100;
            int newY = parent.getY() + 100;
            this.setLocation(newX, newY);
        }
    }

    protected void displaySelectedPrimerDetailWindow() {
        boolean colIndex = false;
        int rowIndex = this.mainTable.getSelectedRow();
        Primer selectedPrimer = this.primerResult.get(rowIndex);
        this.aliViewWindow.performFind(selectedPrimer.getSequence());
        String data = selectedPrimer.getPrimerDetailsAsText();
        if (this.primerDetailFrame == null) {
            this.primerDetailFrame = new PrimerDetailFrame(this.aliViewWindow);
        }
        this.primerDetailFrame.setText(data);
        this.primerDetailFrame.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.primerDetailFrame != null) {
            this.primerDetailFrame.dispose();
        }
    }
}

