/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class FasterTextCellRenderer
extends JLabel
implements ListCellRenderer,
Serializable {
    private static final Logger logger = Logger.getLogger(FasterTextCellRenderer.class);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    private String text;
    private boolean selected;
    private static final int LEFT_OFFSET = 2;

    public FasterTextCellRenderer() {
        this.setBorder(this.getNoFocusBorder());
        this.setName("List.cellRenderer");
    }

    private Border getNoFocusBorder() {
        return DEFAULT_NO_FOCUS_BORDER;
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, 5);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.getHeight() > 8) {
            this.setPlatformDefaultRenderingHints(g2);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.selected) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2.setFont(this.getFont());
        g2.setColor(this.getForeground());
        int bottomCharOffset = (int)(0.2 * (double)this.getHeight());
        g2.drawString(this.text, 2, this.getHeight() - bottomCharOffset);
    }

    private void setPlatformDefaultRenderingHints(Graphics2D g2) {
        try {
            Map pdefaults = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            Object aaHint = pdefaults.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (aaHint != null) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            Object lcdHint = pdefaults.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
            if (lcdHint != null) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, lcdHint);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.selected = isSelected;
        this.setFont(list.getFont());
        this.text = value.toString();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String oldAccessibleName = null;
        if (this.accessibleContext != null) {
            oldAccessibleName = this.accessibleContext.getAccessibleName();
        }
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChange("text", oldValue, text);
        if (this.accessibleContext != null && this.accessibleContext.getAccessibleName() != oldAccessibleName) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, this.accessibleContext.getAccessibleName());
        }
        if (text == null || oldValue == null || !text.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isOpaque() {
        return this.selected;
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public void repaint() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }
}

