/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.alignment.AAHistogram;
import aliview.alignment.AliHistogram;
import aliview.alignment.NucleotideHistogram;
import aliview.importer.FileFormat;
import aliview.messenges.Messenger;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.FileSequenceLoadListener;
import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.Sequence;
import aliview.sequences.SequenceUtils;
import aliview.settings.Settings;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSequenceAlignmentListModel
extends AlignmentListModel {
    private static final Logger logger = Logger.getLogger(FileSequenceAlignmentListModel.class);
    private static final String LF = System.getProperty("line.separator");
    private List<FileSequenceLoadListener> fileSeqLoadListeners = new ArrayList<FileSequenceLoadListener>();

    public FileSequenceAlignmentListModel(File alignmentFile, FileFormat foundFormat) throws IOException {
        super(new CopyOnWriteArrayList<Sequence>(), foundFormat);
        MemoryMappedSequencesFile sequencesFile = new MemoryMappedSequencesFile(alignmentFile, foundFormat);
        sequencesFile.indexFileAndAddSequencesToAlignmentModel(this);
    }

    @Override
    public void writeSelectionAsFasta(Writer out) {
        if (this.getSelectionSize() > 200000000L) {
            Messenger.showOKOnlyMessage(Messenger.TO_BIG_SELECTION_FOR_COPY);
            logger.info("getSelectionSize" + this.getSelectionSize());
        } else {
            int n = 0;
            for (Sequence sequence : this.delegateSequences) {
                if (!sequence.hasSelection()) continue;
                String tempSeq = sequence.getSelectedBasesAsString();
                try {
                    out.append(">");
                    out.append(sequence.getName());
                    out.append(LF);
                    out.append(sequence.getSelectedBasesAsString());
                    out.append(LF);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logger.info("WroteSeq=" + n);
                ++n;
            }
        }
        logger.info("Write done");
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public void addMoreFileSequences(List<Sequence> moreSeqs, boolean setSelected) {
        super.addAll(moreSeqs, setSelected);
    }

    @Override
    public AliHistogram getHistogram() {
        long startTime = System.currentTimeMillis();
        AliHistogram histogram = null;
        histogram = this.sequenceType == SequenceUtils.TYPE_AMINO_ACID ? new AAHistogram(this.getLongestSequenceLength()) : new NucleotideHistogram(this.getLongestSequenceLength());
        int counter = 0;
        for (Sequence seq : this.delegateSequences) {
            if (counter > Settings.getMaxFileHistogramSequences().getIntValue()) break;
            if (this.sequenceType == SequenceUtils.TYPE_AMINO_ACID) {
                histogram.addSequence(seq);
            } else {
                histogram.addSequence(seq);
            }
            ++counter;
        }
        long endTime = System.currentTimeMillis();
        logger.info("Create histogram took " + (endTime - startTime) + " milliseconds");
        return histogram;
    }

    @Override
    public boolean rightPadWithGapUntilEqualLength() {
        return false;
    }

    @Override
    public boolean leftPadWithGapUntilEqualLength() {
        return false;
    }

    @Override
    public boolean rightTrimSequencesRemoveGapsUntilEqualLength() {
        return false;
    }

    @Override
    public void deleteBasesInAllSequencesFromMask(boolean[] deleteMask) {
    }
}

