/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.AliView;
import aliview.importer.AlignmentImportException;
import aliview.importer.ClustalFileIndexer;
import aliview.importer.FastaFileIndexer;
import aliview.importer.FileFormat;
import aliview.importer.MSFFileIndexer;
import aliview.importer.NexusFileIndexer;
import aliview.importer.PhylipFileIndexer;
import aliview.messenges.Messenger;
import aliview.sequencelist.FileSequenceAlignmentListModel;
import aliview.sequences.FileSequence;
import aliview.sequences.Sequence;
import aliview.subprocesses.SubThreadProgressWindow;
import it.unimi.dsi.io.ByteBufferInpStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryMappedSequencesFile {
    private static final Logger logger = Logger.getLogger(MemoryMappedSequencesFile.class);
    private static final String LF = System.getProperty("line.separator");
    private FileFormat fileFormat;
    private File alignmentFile;
    private ByteBufferInpStream mappedBuff;
    private final ReentrantLock mappedBuffLock = new ReentrantLock();
    private long fileSize = -1L;

    public MemoryMappedSequencesFile(File aliFile, FileFormat foundFormat) throws IOException {
        this.alignmentFile = aliFile;
        this.fileFormat = foundFormat;
        logger.info("new FileMMSequnceList");
    }

    public ReentrantLock getMappedBuffLock() {
        return this.mappedBuffLock;
    }

    void indexFileAndAddSequencesToAlignmentModel(FileSequenceAlignmentListModel destinationModel) throws IOException {
        File indexFile = new File(this.alignmentFile.getAbsolutePath() + ".fai");
        if (this.fileFormat == FileFormat.FASTA && indexFile.exists()) {
            List<Sequence> seqs = this.createSequencesFromExistingIndexFile(indexFile);
            if (this.mappedBuff == null) {
                this.createMemoryMappedBuffer();
            }
            this.addSequencesToDestination(seqs, destinationModel);
        } else {
            this.indexFileAndAddSequencesToListInSubthread(destinationModel, this.fileFormat);
        }
    }

    public List<Sequence> createSequencesFromExistingIndexFile(File indexFile) {
        long startTime = System.currentTimeMillis();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        try {
            String line;
            BufferedReader r = new BufferedReader(new FileReader(indexFile));
            int nLine = 0;
            int seqIndex = 0;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() > 0) {
                    String[] splitted = StringUtils.split(line, '\t');
                    String seqName = splitted[0];
                    int seqWithoutWhitespaceLength = Integer.parseInt(splitted[1]);
                    long seqAfterNameStartPointer = Long.parseLong(splitted[2]);
                    int lineCharLength = Integer.parseInt(splitted[3]);
                    int lineAbsoluteLength = Integer.parseInt(splitted[4]);
                    int nSeqFullLines = (int)Math.floor(seqWithoutWhitespaceLength / lineCharLength);
                    int lineDiff = lineAbsoluteLength - lineCharLength;
                    double partialLine = (double)seqWithoutWhitespaceLength / (double)lineCharLength - (double)nSeqFullLines;
                    int extraChars = (int)Math.floor(partialLine * (double)lineDiff);
                    long endPointer = seqAfterNameStartPointer + (long)seqWithoutWhitespaceLength + (long)(nSeqFullLines * lineDiff) + (long)extraChars;
                    FileSequence seq = new FileSequence(this, seqIndex, seqName, seqWithoutWhitespaceLength, seqAfterNameStartPointer, endPointer, lineCharLength, lineAbsoluteLength);
                    sequences.add(seq);
                    ++seqIndex;
                }
                ++nLine;
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading index took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    private void indexFileAndAddSequencesToListInSubthread(final FileSequenceAlignmentListModel destinationModel, final FileFormat fileFormat) {
        final SubThreadProgressWindow progressWin = new SubThreadProgressWindow();
        progressWin.setAlwaysOnTop(true);
        progressWin.setTitle("Background indexing");
        progressWin.setInitialMessage("Indexing file: 0/number of sequences");
        progressWin.show();
        progressWin.centerLocationToThisComponentOrScreen(AliView.getActiveWindow());
        progressWin.setBottomRightRelativeThisComponent(AliView.getActiveWindow());
        try {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        logger.info("Indexing Thread started");
                        int nMaxSeqsToRetrieveBeforeDestinationUpdateFirst = 500;
                        int nMaxSeqsToRetrieveBeforeDestinationUpdateAfterFirst = 5000;
                        int nMaxSeqsToRetrieveBeforeDestinationUpdate = nMaxSeqsToRetrieveBeforeDestinationUpdateFirst;
                        if (fileFormat == FileFormat.PHYLIP || fileFormat == FileFormat.NEXUS || fileFormat == FileFormat.CLUSTAL) {
                            nMaxSeqsToRetrieveBeforeDestinationUpdate = Integer.MAX_VALUE;
                        }
                        boolean hasMoreSequencesToIndex = true;
                        FileSequence lastCachedSeq = null;
                        int indexOffset = 0;
                        while (hasMoreSequencesToIndex) {
                            if (MemoryMappedSequencesFile.this.mappedBuff == null) {
                                progressWin.setTitle("Mapping file");
                                progressWin.setMessage("Mapping file - usually takes about 0-15 sec.");
                                progressWin.setVisible(true);
                                MemoryMappedSequencesFile.this.createMemoryMappedBuffer();
                                progressWin.setTitle("Background indexing");
                                progressWin.setMessage("Indexing file: 0/number of sequences");
                            }
                            long startPointer = 0L;
                            if (lastCachedSeq != null) {
                                startPointer = lastCachedSeq.getEndPointer();
                            }
                            List moreSeqs = MemoryMappedSequencesFile.this.findSequencesInFile(startPointer, indexOffset, nMaxSeqsToRetrieveBeforeDestinationUpdate, progressWin);
                            logger.info("Thread here moreSeqs.size()" + moreSeqs.size());
                            if (moreSeqs.size() > 0) {
                                MemoryMappedSequencesFile.this.addSequencesToDestination(moreSeqs, destinationModel);
                                lastCachedSeq = (FileSequence)moreSeqs.get(moreSeqs.size() - 1);
                                indexOffset += moreSeqs.size();
                            } else {
                                hasMoreSequencesToIndex = false;
                            }
                            if (!Thread.interrupted()) {
                                nMaxSeqsToRetrieveBeforeDestinationUpdate = nMaxSeqsToRetrieveBeforeDestinationUpdateAfterFirst;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        Messenger.showOKOnlyMessage(Messenger.FILE_OPEN_NOT_EXISTS, LF + e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Messenger.showOKOnlyMessage(Messenger.FILE_ERROR, LF + e.getLocalizedMessage());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            boolean wasThreadInterruptedByUser = progressWin.wasSubThreadInterruptedByUser();
                            progressWin.dispose();
                        }
                    });
                }
            });
            progressWin.setActiveThread(thread);
            thread.start();
        }
        catch (Exception e) {
            progressWin.dispose();
            e.printStackTrace();
        }
    }

    protected void createMemoryMappedBuffer() throws IOException {
        try {
            this.mappedBuff = ByteBufferInpStream.map(new FileInputStream(this.alignmentFile).getChannel(), FileChannel.MapMode.READ_ONLY);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            Messenger.showOKOnlyMessage(Messenger.OPEN_LARGE_FILE_ERROR, LF + e.getLocalizedMessage());
            e.getLocalizedMessage();
            throw e;
        }
    }

    private List<Sequence> findSequencesInFile(long filePointerStart, int seqOffset, int nSeqsToRetrieve, SubThreadProgressWindow progressWin) {
        Object fileIndexer;
        long startTime = System.currentTimeMillis();
        boolean nSeqCount = false;
        ArrayList<Sequence> allSeqs = new ArrayList();
        if (this.fileFormat == FileFormat.PHYLIP) {
            try {
                fileIndexer = new PhylipFileIndexer();
                allSeqs = ((PhylipFileIndexer)fileIndexer).findSequencesInFile(this, filePointerStart, seqOffset, nSeqsToRetrieve, progressWin);
            }
            catch (AlignmentImportException e) {
                e.printStackTrace();
            }
        } else if (this.fileFormat == FileFormat.NEXUS) {
            try {
                fileIndexer = new NexusFileIndexer();
                allSeqs = ((NexusFileIndexer)fileIndexer).findSequencesInFile(this, filePointerStart, seqOffset, nSeqsToRetrieve, progressWin);
            }
            catch (AlignmentImportException e) {
                e.printStackTrace();
            }
        } else if (this.fileFormat == FileFormat.CLUSTAL) {
            try {
                fileIndexer = new ClustalFileIndexer();
                allSeqs = ((ClustalFileIndexer)fileIndexer).findSequencesInFile(this, filePointerStart, seqOffset, nSeqsToRetrieve, progressWin);
            }
            catch (AlignmentImportException e) {
                e.printStackTrace();
            }
        } else if (this.fileFormat == FileFormat.MSF) {
            try {
                fileIndexer = new MSFFileIndexer();
                allSeqs = ((MSFFileIndexer)fileIndexer).findSequencesInFile(this, filePointerStart, seqOffset, nSeqsToRetrieve, progressWin);
            }
            catch (AlignmentImportException e) {
                e.printStackTrace();
            }
        } else {
            fileIndexer = new FastaFileIndexer();
            this.mappedBuffLock.lock();
            allSeqs = ((FastaFileIndexer)fileIndexer).findSequencesInFile(this, filePointerStart, seqOffset, nSeqsToRetrieve, progressWin);
            this.mappedBuffLock.unlock();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return allSeqs;
    }

    private void addSequencesToDestination(final List<Sequence> moreSeqs, final FileSequenceAlignmentListModel destinationModel) {
        logger.info("addSequencesToDestination");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                destinationModel.addMoreFileSequences(moreSeqs, false);
            }
        });
    }

    public byte readByteInFile(long pos) {
        return (byte)this.readInFile(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInFile(long pos) {
        if (pos < 0L) {
            return 0;
        }
        this.mappedBuffLock.lock();
        try {
            int val;
            this.mappedBuff.position(pos);
            int n = val = this.mappedBuff.read();
            return n;
        }
        finally {
            this.mappedBuffLock.unlock();
        }
    }

    public ByteBufferInpStream getMappedBuff() {
        return this.mappedBuff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesInFile(long pos, int i, byte[] bytesToDraw) {
        this.mappedBuffLock.lock();
        try {
            int val;
            this.mappedBuff.position(pos);
            int n = val = this.mappedBuff.read(bytesToDraw, 0, i);
            return n;
        }
        finally {
            this.mappedBuffLock.unlock();
        }
    }

    public long getFileSize() {
        this.mappedBuffLock.lock();
        try {
            if (this.fileSize == -1L) {
                this.fileSize = this.mappedBuff.length();
            }
            long l = this.fileSize;
            return l;
        }
        finally {
            this.mappedBuffLock.unlock();
        }
    }
}

