/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.NucleotideUtilities;
import aliview.alignment.AliHistogram;
import aliview.sequences.Sequence;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencePositionComparator
implements Comparator<Sequence> {
    private int sortPosition;
    private AliHistogram histogram;

    public SequencePositionComparator(int position, AliHistogram histogram) {
        this.sortPosition = position;
        this.histogram = histogram;
    }

    @Override
    public int compare(Sequence seq1, Sequence seq2) {
        int byte2Count;
        byte seq1Byte = seq1.getBaseAtPos(this.sortPosition);
        byte seq2Byte = seq2.getBaseAtPos(this.sortPosition);
        int byte1Count = this.histogram.getValueCount(this.sortPosition, NucleotideUtilities.baseValFromBase(seq1Byte));
        if (byte1Count < (byte2Count = this.histogram.getValueCount(this.sortPosition, NucleotideUtilities.baseValFromBase(seq2Byte)))) {
            return -1;
        }
        if (byte1Count > byte2Count) {
            return 1;
        }
        return seq1Byte - seq2Byte;
    }
}

