/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.sequencelist.Interval;
import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.BasicSequence;
import aliview.sequences.FileSequenceBases;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FileSequence
extends BasicSequence {
    private static final Logger logger = Logger.getLogger(FileSequence.class);

    public FileSequence(MemoryMappedSequencesFile sequencesFile, long startPointer) {
        this(new FileSequenceBases(sequencesFile, startPointer));
    }

    public FileSequence(FileSequenceBases fileSequenceBases) {
        super(fileSequenceBases);
    }

    public FileSequence(FileSequence template) {
        super(template);
    }

    public FileSequence(MemoryMappedSequencesFile sequencesFile, int seqIndex, String name, int seqWithoutWhitespaceLength, long seqAfterNameStartPointer, long endPointer, int lineCharLength, int lineAbsoluteLength) {
        this(new FileSequenceBases(sequencesFile, seqAfterNameStartPointer, endPointer, seqAfterNameStartPointer));
        this.name = name;
    }

    public FileSequence getCopy() {
        return new FileSequence(this);
    }

    public long getEndPointer() {
        return this.getFileSequenceBases().getEndPointer();
    }

    public void setEndPointer(long pointer) {
        this.getFileSequenceBases().setEndPointer(pointer);
    }

    public void setSequenceAfterNameStartPointer(long pointer) {
        this.getFileSequenceBases().setSequenceAfterNameStartPointer(pointer);
    }

    public long getSequenceAfterNameStartPointer() {
        return this.getFileSequenceBases().getSequenceAfterNameStartPointer();
    }

    private FileSequenceBases getFileSequenceBases() {
        return (FileSequenceBases)this.bases;
    }

    public byte getBaseAtPos(int n) {
        return this.getBases().get(n);
    }

    public int getBaseAsIntAtPos(int n) {
        return this.getBases().get(n);
    }

    public byte[] getAllBasesAsByteArray() {
        return this.getBases().toByteArray();
    }

    public void writeBases(OutputStream out) throws IOException {
        for (int n = 0; n < this.getLength(); ++n) {
            int base = this.getBaseAsIntAtPos(n);
            if (base == 32 || base == 10 || base == 13) continue;
            out.write(base);
        }
    }

    public void writeBases(Writer out) throws IOException {
        for (int n = 0; n < this.getLength(); ++n) {
            int base = this.getBaseAsIntAtPos(n);
            if (base == 32 || base == 10 || base == 13) continue;
            out.write((char)base);
        }
    }

    public Interval find(Pattern pattern, int startPos) {
        Interval foundInterval = null;
        int buffSize = 5000000;
        for (int buffStart = startPos; buffStart < this.getLength(); buffStart += buffSize) {
            StringBuilder buff = new StringBuilder();
            for (int n = buffStart; n < this.getLength() && n < buffStart + buffSize; ++n) {
                byte next = (byte)this.getBaseAsIntAtPos(n);
                if (next == 0) continue;
                buff.append((char)next);
            }
            Matcher matcher = pattern.matcher(buff);
            boolean wasFound = matcher.find(0);
            if (!wasFound) continue;
            int foundStart = matcher.start();
            int foundEnd = matcher.end() - 1;
            foundInterval = new Interval(foundStart + buffStart, foundEnd + buffStart);
        }
        return foundInterval;
    }

    public void reverseComplement() {
    }

    public void complement() {
    }

    public void replaceBases(int startReplaceIndex, int stopReplaceIndex, byte[] insertBases) {
    }

    public void replaceSelectedBasesWithGap() {
    }

    public void deleteSelectedBases() {
    }

    public void deleteBasesFromMask(boolean[] deleteMask) {
    }

    public void clearBase(int n) {
    }

    public void rightPadSequenceWithGaps(int diffLen) {
    }

    public void leftPadSequenceWithGaps(int diffLen) {
    }

    public void setSelectionOffset(int selectionOffset) {
    }

    public void moveSelectedResiduesRightIfGapIsPresent() {
    }

    public void moveSelectedResiduesLeftIfGapIsPresent() {
    }

    public void moveSelectedResiduesRightIfGapOrEndIsPresent() {
    }

    public boolean isGapOrEndRightOfSelection() {
        return false;
    }

    public boolean isGapRightOfSelection() {
        return false;
    }

    public boolean isGapLeftOfSelection() {
        return false;
    }

    public void deleteGapLeftOfSelection() {
    }

    public void deleteGapRightOfSelection() {
    }

    public void replaceSelectedBasesWithChar(char newChar) {
    }

    public void realignNucleotidesUseThisAASequenceAsTemplate(byte[] allBasesAsByteArray) {
    }

    public void selectAllBasesUntilGap(int x) {
    }

    public int indexOf(char testChar) {
        logger.warn("This might take a long time");
        return super.indexOf(testChar);
    }

    public int countChar(char targetChar, int startpos, int endpos) {
        logger.warn("This might take a long time");
        return super.countChar(targetChar, startpos, endpos);
    }

    public int getUngapedLength() {
        logger.warn("this could take a lot of time and ruin memory");
        return -1;
    }

    public int[] getSequenceAsBaseVals() {
        logger.warn("this could take a lot of time and ruin memory");
        return super.getSequenceAsBaseVals();
    }

    public int getUngapedPos(int position) {
        logger.warn("this could take a lot of time");
        return super.getUngapedPos(position);
    }
}

