/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.Output;
import jebl.evolution.align.Traceback;
import jebl.evolution.align.TracebackPlotter;
import jebl.evolution.align.scores.Scores;

public abstract class Align {
    Scores sub;
    Scores freeGapsSub;
    float d;
    String seq1 = null;
    String seq2 = null;
    int n = 0;
    int m = 0;
    Traceback B0;

    public Align(Scores sub, float d) {
        this.setGapOpen(d);
        this.setScores(sub);
    }

    public abstract void doAlignment(String var1, String var2);

    public abstract void prepareAlignment(String var1, String var2);

    public void setGapOpen(float d) {
        this.d = d;
    }

    public void setScores(Scores sub) {
        this.sub = sub;
        this.freeGapsSub = Scores.duplicate(sub);
        int i = 0;
        while (i < 127) {
            this.freeGapsSub.score[45][i] = 0.0f;
            this.freeGapsSub.score[i][45] = 0.0f;
            ++i;
        }
    }

    public String[] getMatch() {
        char[] sq1 = this.seq1.toCharArray();
        char[] sq2 = this.seq2.toCharArray();
        StringBuilder res1 = new StringBuilder();
        StringBuilder res2 = new StringBuilder();
        Traceback tb = this.B0;
        int i = tb.i;
        int j = tb.j;
        while ((tb = this.next(tb)) != null) {
            if (i == tb.i) {
                res1.append('-');
            } else {
                res1.append(sq1[i - 1]);
            }
            if (j == tb.j) {
                res2.append('-');
            } else {
                res2.append(sq2[j - 1]);
            }
            i = tb.i;
            j = tb.j;
        }
        return new String[]{res1.reverse().toString(), res2.reverse().toString()};
    }

    public String formatScore(float val) {
        return Float.toString(val);
    }

    public void doMatch(Output out, String msg, boolean outputFMatrix) {
        out.println(String.valueOf(msg) + ":");
        out.println("Score = " + this.getScore());
        if (outputFMatrix) {
            out.println("The F matrix:");
            this.printf(out);
        }
        out.println("An optimal alignment:");
        String[] match = this.getMatch();
        out.println(match[0]);
        out.println(match[1]);
        int[] counts = this.matchCounts(match);
        out.println("matchs=" + counts[0] + " mismatchs=" + counts[1] + " gaps=" + counts[2]);
        out.println("percent identity=" + (double)Math.round((double)counts[0] * 1000.0 / (double)match[0].length()) / 10.0 + "%");
    }

    private int[] matchCounts(String[] match) {
        int[] matchCounts = new int[3];
        int i = 0;
        while (i < match[0].length()) {
            char c2;
            char c1 = match[0].charAt(i);
            if (c1 == (c2 = match[1].charAt(i))) {
                matchCounts[0] = matchCounts[0] + 1;
            } else if (c1 != '-' && c2 != '-') {
                matchCounts[1] = matchCounts[1] + 1;
            } else {
                matchCounts[2] = matchCounts[2] + 1;
            }
            ++i;
        }
        return matchCounts;
    }

    public void traceback(TracebackPlotter plotter) {
        plotter.newTraceBack(this.seq1, this.seq2);
        Traceback tb = this.B0;
        while (tb != null) {
            plotter.traceBack(tb);
            tb = this.next(tb);
        }
        plotter.finishedTraceBack();
    }

    public void doMatch(Output out, String msg) {
        this.doMatch(out, msg, false);
    }

    public Traceback next(Traceback tb) {
        return tb;
    }

    public abstract float getScore();

    public abstract void printf(Output var1);

    static float max(float x1, float x2) {
        return x1 > x2 ? x1 : x2;
    }

    static int maxi(int x1, int x2) {
        return x1 > x2 ? x1 : x2;
    }

    static float max(float x1, float x2, float x3) {
        return Align.max(x1, Align.max(x2, x3));
    }

    static float max(float x1, float x2, float x3, float x4) {
        return Align.max(Align.max(x1, x2), Align.max(x3, x4));
    }

    static String padLeft(String s, int width) {
        int filler = width - s.length();
        if (filler > 0) {
            StringBuilder res = new StringBuilder(width);
            int i = 0;
            while (i < filler) {
                res.append(' ');
                ++i;
            }
            return res.append(s).toString();
        }
        return s;
    }

    String strip(String s) {
        return Align.strip(s, this.sub.getAlphabet());
    }

    static String strip(String s, String residues) {
        return Align.stripIllegalCharacters(s, residues, false);
    }

    static String stripIllegalCharacters(String s, String allowedCharacters, boolean allowGaps) {
        boolean[] valid = new boolean[127];
        int i = 0;
        while (i < allowedCharacters.length()) {
            char c = allowedCharacters.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                valid[c + 32] = true;
                valid[c] = true;
            } else if (c >= 'a' && c <= 'z') {
                valid[c] = true;
                valid[c - 32] = true;
            } else {
                valid[c] = true;
            }
            ++i;
        }
        if (allowGaps) {
            valid[45] = true;
        }
        StringBuilder res = new StringBuilder(s.length());
        int i2 = 0;
        while (i2 < s.length()) {
            if (valid[s.charAt(i2)]) {
                res.append(s.charAt(i2));
            }
            ++i2;
        }
        return res.toString();
    }
}

