/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jebl.evolution.align.Align;
import jebl.evolution.align.AlignmentResult;
import jebl.evolution.align.AlignmentTreeBuilderFactory;
import jebl.evolution.align.CompoundAlignmentProgressListener;
import jebl.evolution.align.MultipleAligner;
import jebl.evolution.align.NeedlemanWunschLinearSpaceAffine;
import jebl.evolution.align.Profile;
import jebl.evolution.align.scores.Blosum60;
import jebl.evolution.align.scores.NucleotideScores;
import jebl.evolution.align.scores.Scores;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.BasicAlignment;
import jebl.evolution.distances.CannotBuildDistanceMatrixException;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.graphs.Node;
import jebl.evolution.io.FastaImporter;
import jebl.evolution.io.ImportException;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.TreeBuilderFactory;
import jebl.evolution.trees.Utils;
import jebl.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BartonSternberg
implements MultipleAligner {
    Scores scores;
    NeedlemanWunschLinearSpaceAffine aligner;
    private int refinementIterations;
    private float gapOpen;
    private float gapExtend;
    private boolean freeGapsAtEnds;
    private boolean fastGuide;
    private Scores origScores = null;
    CompoundAlignmentProgressListener compoundProgress;

    private void establishScores(Scores scores) {
        this.scores = scores;
        this.scores = Scores.includeGaps(scores, -this.gapExtend, 0.0f);
        this.aligner = new NeedlemanWunschLinearSpaceAffine(this.scores, this.gapOpen, this.gapExtend, this.freeGapsAtEnds);
    }

    public Scores getEstimatedScores() {
        return this.origScores != null ? this.scores : null;
    }

    public BartonSternberg(Scores scores, float gapOpen, float gapExtend, int refinementIterations, boolean freeGapsAtEnds, boolean fastGuide) {
        this.gapOpen = gapOpen;
        this.gapExtend = gapExtend;
        this.freeGapsAtEnds = freeGapsAtEnds;
        this.fastGuide = fastGuide;
        this.refinementIterations = refinementIterations;
        this.establishScores(scores);
    }

    private Profile align(RootedTree tree, Node node, List<Sequence> seqs, CompoundAlignmentProgressListener compoundProgress) {
        if (tree.isExternal(node)) {
            Taxon tax = tree.getTaxon(node);
            int iSeq = Integer.parseInt(tax.getName());
            Profile profile = new Profile(this.scores.getAlphabet().length());
            profile.addSequence(iSeq, seqs.get(iSeq).getString());
            return profile;
        }
        List<Node> children = tree.getChildren(node);
        assert (children.size() == 2);
        Profile left = this.align(tree, children.get(0), seqs, compoundProgress);
        if (compoundProgress.isCanceled()) {
            return null;
        }
        Profile right = this.align(tree, children.get(1), seqs, compoundProgress);
        if (compoundProgress.isCanceled()) {
            return null;
        }
        compoundProgress.setSectionSize(1);
        AlignmentResult[] results = this.aligner.doAlignment(left, right, compoundProgress.getMinorProgress(), false);
        compoundProgress.incrementSectionsCompleted(1);
        if (compoundProgress.isCanceled()) {
            return null;
        }
        return Profile.combine(left, right, results[0], results[1]);
    }

    public final String[] align(List<Sequence> sourceSequences, ProgressListener progress, boolean refineOnly, boolean estimateMatchMismatchCosts) throws CannotBuildDistanceMatrixException {
        Profile profile;
        int i;
        if (this.origScores != null) {
            this.establishScores(this.origScores);
        }
        int numSequences = sourceSequences.size();
        Profile[] sequenceProfilesWithoutGaps = new Profile[numSequences];
        String[] sequencesWithoutGaps = new String[numSequences];
        int i2 = 0;
        while (i2 < numSequences) {
            sequencesWithoutGaps[i2] = Align.stripIllegalCharacters(sourceSequences.get(i2).getString(), this.scores.getAlphabet(), false);
            sequenceProfilesWithoutGaps[i2] = Profile.createImmutableProfile(i2, sequencesWithoutGaps[i2]);
            ++i2;
        }
        int treeWork = refineOnly ? 0 : (this.fastGuide ? numSequences : numSequences * (numSequences - 1) / 2);
        int alignmentWork = refineOnly ? 0 : numSequences - 1;
        int refinementWork = numSequences * this.refinementIterations;
        this.compoundProgress = new CompoundAlignmentProgressListener(progress, treeWork + refinementWork + alignmentWork);
        if (refineOnly) {
            String[] sequencesWithGaps = new String[numSequences];
            i = 0;
            while (i < numSequences) {
                sequencesWithGaps[i] = Align.stripIllegalCharacters(sourceSequences.get(i).getString(), this.scores.getAlphabet(), true);
                ++i;
            }
            profile = new Profile(Profile.calculateAlphabetSize(sequencesWithGaps));
            i = 0;
            while (i < numSequences) {
                assert (sequencesWithGaps[i].length() == sequencesWithGaps[0].length());
                profile.addSequence(i, sequencesWithGaps[i]);
                ++i;
            }
        } else {
            AlignmentTreeBuilderFactory.Result unrootedGuideTree;
            ArrayList<Sequence> sequencesForGuideTree = new ArrayList<Sequence>(sourceSequences.size());
            i = 0;
            while (i < numSequences) {
                Sequence s = sourceSequences.get(i);
                sequencesForGuideTree.add(new BasicSequence(s.getSequenceType(), Taxon.getTaxon("" + i), sequencesWithoutGaps[i]));
                ++i;
            }
            this.compoundProgress.setSectionSize(treeWork);
            boolean estimateMatchCost = estimateMatchMismatchCosts && this.scores instanceof NucleotideScores;
            AlignmentTreeBuilderFactory.Result result = unrootedGuideTree = this.fastGuide ? AlignmentTreeBuilderFactory.build(sequencesForGuideTree, TreeBuilderFactory.Method.NEIGHBOR_JOINING, this, this.compoundProgress.getMinorProgress(), true) : AlignmentTreeBuilderFactory.build(sequencesForGuideTree, TreeBuilderFactory.Method.NEIGHBOR_JOINING, this.aligner, this.compoundProgress.getMinorProgress());
            if (this.compoundProgress.isCanceled()) {
                return null;
            }
            RootedTree guideTree = Utils.rootTreeAtCenter(unrootedGuideTree.tree);
            this.compoundProgress.incrementSectionsCompleted(treeWork);
            if (estimateMatchCost) {
                DistanceMatrix distanceMat = unrootedGuideTree.distance;
                double[][] distances = distanceMat.getDistances();
                double sum = 0.0;
                int n = distances.length;
                int k = 0;
                while (k < n) {
                    int j = k + 1;
                    while (j < n) {
                        sum += Math.min(5.0, distances[k][j]);
                        ++j;
                    }
                    ++k;
                }
                double avg = sum / (double)(n * (n - 1) / 2);
                double percentmatches = 1.0 - 0.75 * (1.0 - Math.exp(-4.0 * avg / 3.0));
                this.origScores = this.scores;
                NucleotideScores nucleotideScores = new NucleotideScores(this.scores, percentmatches);
                this.establishScores(nucleotideScores);
            }
            progress.setMessage("Building alignment");
            profile = this.align(guideTree, guideTree.getRootNode(), sequencesForGuideTree, this.compoundProgress);
            if (this.compoundProgress.isCanceled()) {
                return null;
            }
        }
        int j = 0;
        while (j < this.refinementIterations) {
            String message = "Refining alignment";
            if (this.refinementIterations > 1) {
                message = String.valueOf(message) + " (iteration " + (j + 1) + " of " + this.refinementIterations + ")";
            }
            progress.setMessage(message);
            int i3 = 0;
            while (i3 < numSequences) {
                boolean display = false;
                String sequence = profile.getSequence(i3);
                if (j >= 0) {
                    // empty if block
                }
                if (display) {
                    System.out.println("remove sequence =" + sequence);
                    profile.print(true);
                }
                Profile sequenceProfile = new Profile(i3, sequence);
                profile.remove(sequenceProfile);
                AlignmentResult[] results = this.aligner.doAlignment(profile, sequenceProfilesWithoutGaps[i3], this.compoundProgress.getMinorProgress(), false);
                if (this.compoundProgress.isCanceled()) {
                    return null;
                }
                this.compoundProgress.incrementSectionsCompleted(1);
                if (display) {
                    profile.print(false);
                    System.out.println("result =" + results[0].size + "," + results[1].size + " from " + profile.length() + "," + sequenceProfile.length());
                }
                profile = Profile.combine(profile, sequenceProfilesWithoutGaps[i3], results[0], results[1]);
                if (display) {
                    profile.print(true);
                }
                ++i3;
            }
            ++j;
        }
        String[] results = new String[numSequences];
        int i4 = 0;
        while (i4 < numSequences) {
            results[i4] = profile.getSequence(i4);
            ++i4;
        }
        return results;
    }

    public static void main(String[] arguments) throws IOException, ImportException {
        String string;
        BasicSequence basic;
        File file = new File(arguments[0]);
        SequenceType sequenceType = SequenceType.AMINO_ACID;
        FastaImporter importer = new FastaImporter(file, sequenceType);
        List<Sequence> xsequences = importer.importSequences();
        ArrayList<String> sequenceStrings = new ArrayList<String>();
        int count = 0;
        int maximum = 10;
        for (Sequence sequence : xsequences) {
            basic = (BasicSequence)sequence;
            string = basic.getCleanString();
            sequenceStrings.add(string);
            System.out.println(string);
            if (count++ >= maximum) break;
        }
        System.out.println();
        count = 0;
        for (Sequence sequence : xsequences) {
            basic = (BasicSequence)sequence;
            string = basic.getString();
            System.out.println(string);
            if (count++ >= maximum) break;
        }
        long start = System.currentTimeMillis();
        BartonSternberg alignment = new BartonSternberg(new Blosum60(), 20.0f, 1.0f, 2, true, false);
        String[] sequences = sequenceStrings.toArray(new String[0]);
        System.out.println("aligning " + sequences.length);
        try {
            String[] results;
            String[] stringArray = results = alignment.align(xsequences, null, false, false);
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String result = stringArray[n2];
                System.out.println(result);
                ++n2;
            }
            System.out.println("took " + (System.currentTimeMillis() - start) + " milliseconds");
        }
        catch (CannotBuildDistanceMatrixException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Alignment doAlign(List<Sequence> seqs, RootedTree guideTree, ProgressListener progress) {
        int count = seqs.size();
        CompoundAlignmentProgressListener p = new CompoundAlignmentProgressListener(progress, count - 1);
        Profile profile = this.align(guideTree, guideTree.getRootNode(), seqs, p);
        if (p.isCanceled()) {
            return null;
        }
        ArrayList<BasicSequence> aSeqs = new ArrayList<BasicSequence>(count);
        int i = 0;
        while (i < count) {
            String seq = profile.getSequence(i);
            Sequence s = seqs.get(i);
            aSeqs.add(new BasicSequence(s.getSequenceType(), s.getTaxon(), seq));
            ++i;
        }
        return new BasicAlignment(aSeqs);
    }

    @Override
    public Alignment doAlign(Alignment a1, Alignment a2, ProgressListener progress) {
        List<Sequence> seqs1 = a1.getSequenceList();
        List<Sequence> seqs2 = a2.getSequenceList();
        int size1 = seqs1.size();
        int size2 = seqs2.size();
        Profile profile1 = new Profile(a1, this.scores.getAlphabet().length());
        Profile profile2 = new Profile(a2, this.scores.getAlphabet().length(), size1);
        AlignmentResult[] results = this.aligner.doAlignment(profile1, profile2, progress, false);
        if (progress.isCanceled()) {
            return null;
        }
        Profile profile = Profile.combine(profile1, profile2, results[0], results[1]);
        int count = size1 + size2;
        ArrayList<BasicSequence> aSeqs = new ArrayList<BasicSequence>(count);
        int i = 0;
        while (i < count) {
            String seq = profile.getSequence(i);
            Sequence s = i < size1 ? seqs1.get(i) : seqs2.get(i - size1);
            aSeqs.add(new BasicSequence(s.getSequenceType(), s.getTaxon(), seq));
            ++i;
        }
        return new BasicAlignment(aSeqs);
    }

    @Override
    public Alignment doAlign(Alignment alignment, Sequence sequence, ProgressListener progress) {
        for (Sequence seq : alignment.getSequenceList()) {
            if (!seq.getTaxon().getName().equals(sequence.getTaxon().getName())) continue;
            throw new IllegalArgumentException("Sequence taxon " + sequence.getTaxon().getName() + " appears in alignment and sequence.");
        }
        Profile aprofile = new Profile(alignment, this.scores.getAlphabet().length(), 1);
        Profile sprofile = new Profile(this.scores.getAlphabet().length());
        sprofile.addSequence(0, sequence.getString());
        AlignmentResult[] results = this.aligner.doAlignment(aprofile, sprofile, progress, false);
        Profile profile = Profile.combine(aprofile, sprofile, results[0], results[1]);
        List<Sequence> seqs1 = alignment.getSequenceList();
        ArrayList<Sequence> seqs2 = new ArrayList<Sequence>();
        seqs2.add(sequence);
        int size1 = seqs1.size();
        int size2 = seqs2.size();
        int count = size1 + size2;
        ArrayList<BasicSequence> aSeqs = new ArrayList<BasicSequence>(count);
        int i = 0;
        while (i < count) {
            String seq = profile.getSequence(i);
            Sequence s = i < count - 1 ? seqs1.get(i) : (Sequence)seqs2.get(0);
            aSeqs.add(new BasicSequence(s.getSequenceType(), s.getTaxon(), seq));
            ++i;
        }
        return new BasicAlignment(aSeqs);
    }

    public double getScore() {
        return this.aligner.getScore();
    }
}

