/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.graphs.Node;
import jebl.evolution.io.AlignmentExporter;
import jebl.evolution.io.NexusImporter;
import jebl.evolution.io.SequenceExporter;
import jebl.evolution.io.TreeExporter;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;
import jebl.util.Attributable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusExporter
implements AlignmentExporter,
SequenceExporter,
TreeExporter {
    private final String nameRegex = "^(\\w|-)+$";
    public static final String treeNameAttributeKey = "name";
    public static final String[] exportExcludeKeys = new String[]{"name", "R", "U"};
    private Set<Taxon> taxa = null;
    protected final PrintWriter writer;
    private boolean writeMetaComments;
    private boolean interleave;
    public static final int MAX_ROW_LENGTH = 60;

    public NexusExporter(Writer writer) {
        this(writer, true);
    }

    public NexusExporter(Writer writer, boolean writeMetaComments) {
        this(writer, writeMetaComments, false);
    }

    public NexusExporter(Writer writer, boolean writeMetaComments, boolean interleave) {
        this.writeMetaComments = writeMetaComments;
        this.interleave = interleave;
        this.writer = new PrintWriter(writer);
        this.writer.println("#NEXUS");
    }

    @Override
    public void exportAlignment(Alignment alignment) throws IOException {
        this.exportSequences(alignment.getSequences());
    }

    @Override
    public void exportSequences(Collection<? extends Sequence> sequences) throws IOException, IllegalArgumentException {
        this.establishSequenceTaxa(sequences);
        SequenceType seqType = null;
        int maxLength = 0;
        for (Sequence sequence : sequences) {
            if (sequence.getLength() > maxLength) {
                maxLength = sequence.getLength();
            }
            if (seqType == null) {
                seqType = sequence.getSequenceType();
                continue;
            }
            if (seqType == sequence.getSequenceType()) continue;
            throw new IllegalArgumentException("All seqeuences must have the same type");
        }
        this.writer.println("begin characters;");
        this.writer.println("\tdimensions nchar=" + maxLength + ";");
        if (seqType != null) {
            this.writer.println("\tformat datatype=" + seqType.getNexusDataType() + " missing=" + seqType.getUnknownState().getName() + " gap=" + seqType.getGapState().getCode() + (this.interleave ? " interleave=yes" : "") + ";");
            this.writer.println("\tmatrix");
            int n = this.interleave ? 60 : maxLength;
            int n2 = 0;
            while ((double)n2 < Math.ceil((double)maxLength / (double)n)) {
                for (Sequence sequence : sequences) {
                    if (sequence.getSequenceType() != seqType) {
                        throw new IllegalArgumentException("SequenceTypes of sequences in collection do not match");
                    }
                    StringBuilder builder = new StringBuilder("\t");
                    this.appendTaxonName(sequence.getTaxon(), builder);
                    String sequenceString = sequence.getString();
                    builder.append("\t").append(sequenceString.subSequence(n2 * n, Math.min((n2 + 1) * n, sequenceString.length())));
                    int shortBy = Math.min(Math.min(n2 * n, maxLength) - sequence.getLength(), n);
                    if (shortBy > 0) {
                        int i = 0;
                        while (i < shortBy) {
                            builder.append(seqType.getGapState().getCode());
                            ++i;
                        }
                    }
                    this.writer.println(builder);
                }
                this.writer.println();
                ++n2;
            }
            this.writer.println(";\nend;");
        }
    }

    @Override
    public void exportTree(Tree tree) throws IOException {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        trees.add(tree);
        this.exportTrees(trees);
    }

    private void writeTrees(Collection<? extends Tree> trees, boolean checkTaxa) throws IOException {
        int nt = 0;
        for (Tree tree : trees) {
            if (checkTaxa && this.establishTreeTaxa(tree)) {
                throw new IllegalArgumentException();
            }
            boolean isRooted = tree instanceof RootedTree;
            RootedTree rtree = isRooted ? (RootedTree)tree : Utils.rootTheTree(tree);
            Object name = tree.getAttribute(treeNameAttributeKey);
            String treeName = name != null ? NexusImporter.makeIntoAllowableIdentifier(name.toString()) : "tree_" + ++nt;
            StringBuilder builder = new StringBuilder("\ttree ");
            builder.append(treeName);
            builder.append(" = ");
            builder.append(isRooted && !rtree.conceptuallyUnrooted() ? "[&R] " : "[&U] ");
            this.appendAttributes(rtree, exportExcludeKeys, builder);
            this.appendTree(rtree, rtree.getRootNode(), builder);
            builder.append(";");
            this.writer.println(builder);
        }
    }

    @Override
    public void exportTrees(Collection<? extends Tree> trees) throws IOException {
        this.establishTreeTaxa(trees.iterator().next());
        this.writer.println("begin trees;");
        this.writeTrees(trees, true);
        this.writer.println("end;");
    }

    public void exportTreesWithTranslation(Collection<? extends Tree> trees, Map<String, String> t) throws IOException {
        this.writer.println("begin trees;");
        this.writer.println("\ttranslate");
        boolean first = true;
        for (Map.Entry<String, String> e : t.entrySet()) {
            this.writer.print(String.valueOf(first ? "" : ",\n") + "\t\t" + this.safeName(e.getKey()) + " " + this.safeName(e.getValue()));
            first = false;
        }
        this.writer.println("\n\t;");
        this.writeTrees(trees, false);
        this.writer.println("end;");
    }

    public void exportMatrix(DistanceMatrix distanceMatrix) {
        List<Taxon> taxa = distanceMatrix.getTaxa();
        this.establishTaxa(taxa);
        this.writer.println("begin distances;");
        double[][] distances = distanceMatrix.getDistances();
        this.writer.println(" format triangle = upper nodiagonal;");
        this.writer.println(" matrix ");
        int i = 0;
        while (i < taxa.size()) {
            StringBuilder builder = new StringBuilder("\t");
            this.appendTaxonName(taxa.get(i), builder);
            int j = i + 1;
            while (j < taxa.size()) {
                builder.append(" ");
                builder.append(distances[i][j]);
                ++j;
            }
            this.writer.println(builder);
            ++i;
        }
        this.writer.println(";");
        this.writer.println("end;");
    }

    private void setTaxa(Taxon[] taxons) {
        this.taxa = new HashSet<Taxon>();
        this.writer.println("begin taxa;");
        this.writer.println("\tdimensions ntax=" + taxons.length + ";");
        this.writer.println("\ttaxlabels");
        Taxon[] taxonArray = taxons;
        int n = taxons.length;
        int n2 = 0;
        while (n2 < n) {
            Taxon taxon = taxonArray[n2];
            this.taxa.add(taxon);
            StringBuilder builder = new StringBuilder("\t");
            this.appendTaxonName(taxon, builder);
            this.appendAttributes(taxon, null, builder);
            this.writer.println(builder);
            ++n2;
        }
        this.writer.println(";\nend;\n");
    }

    private String safeName(String name) {
        if (!name.matches("^(\\w|-)+$")) {
            name = name.replace("'", "''");
            return "'" + name + "'";
        }
        return name;
    }

    private StringBuilder appendTaxonName(Taxon taxon, StringBuilder builder) {
        String name = taxon.getName();
        if (!name.matches("^(\\w|-)+$")) {
            name = name.replace("'", "''");
            builder.append("'").append(name).append("'");
            return builder;
        }
        return builder.append(name);
    }

    private void establishSequenceTaxa(Collection<? extends Sequence> sequences) {
        if (this.taxa != null && this.taxa.size() == sequences.size()) {
            boolean hasAll = true;
            for (Sequence sequence : sequences) {
                if (!this.taxa.contains(sequence.getTaxon())) continue;
                hasAll = false;
                break;
            }
            if (hasAll) {
                return;
            }
        }
        ArrayList<Taxon> t = new ArrayList<Taxon>(sequences.size());
        for (Sequence sequence : sequences) {
            t.add(sequence.getTaxon());
        }
        this.setTaxa(t.toArray(new Taxon[0]));
    }

    private boolean establishTreeTaxa(Tree tree) {
        return this.establishTaxa(tree.getTaxa());
    }

    private boolean establishTaxa(Collection<? extends Taxon> ntaxa) {
        if (this.taxa != null && this.taxa.size() == ntaxa.size() && this.taxa.containsAll(ntaxa)) {
            return false;
        }
        this.setTaxa(ntaxa.toArray(new Taxon[0]));
        return true;
    }

    private void appendTree(RootedTree tree, Node node, StringBuilder builder) {
        if (tree.isExternal(node)) {
            this.appendTaxonName(tree.getTaxon(node), builder);
            this.appendAttributes(node, null, builder);
            if (tree.hasLengths()) {
                builder.append(':');
                builder.append(NexusExporter.roundDouble(tree.getLength(node), 6));
            }
        } else {
            builder.append('(');
            List<Node> children = tree.getChildren(node);
            int last = children.size() - 1;
            int i = 0;
            while (i < children.size()) {
                this.appendTree(tree, children.get(i), builder);
                builder.append(i == last ? (char)')' : ',');
                ++i;
            }
            this.appendAttributes(node, null, builder);
            Node parent = tree.getParent(node);
            if (parent != null && tree.hasLengths()) {
                builder.append(":").append(NexusExporter.roundDouble(tree.getLength(node), 6));
            }
        }
    }

    public static double roundDouble(double value, int decimalPlace) {
        double power_of_ten = 1.0;
        while (decimalPlace-- > 0) {
            power_of_ten *= 10.0;
        }
        return (double)Math.round(value * power_of_ten) / power_of_ten;
    }

    private StringBuilder appendAttributes(Attributable item, String[] excludeKeys, StringBuilder builder) {
        if (!this.writeMetaComments) {
            return builder;
        }
        boolean first = true;
        for (String key : item.getAttributeNames()) {
            boolean exclude = false;
            if (excludeKeys != null) {
                String[] stringArray = excludeKeys;
                int n = excludeKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    String eKey = stringArray[n2];
                    if (eKey.equals(key)) {
                        exclude = true;
                    }
                    ++n2;
                }
            }
            if (exclude || key.startsWith("&")) continue;
            if (first) {
                builder.append("[&");
                first = false;
            } else {
                builder.append(",");
            }
            if (key.indexOf(32) < 0) {
                builder.append(key);
            } else {
                builder.append("\"").append(key).append("\"");
            }
            builder.append('=');
            Object value = item.getAttribute(key);
            this.appendAttributeValue(value, builder);
        }
        if (!first) {
            builder.append("]");
        }
        return builder;
    }

    private StringBuilder appendAttributeValue(Object value, StringBuilder builder) {
        if (value instanceof Object[]) {
            builder.append("{");
            Object[] elements = (Object[])value;
            if (elements.length > 0) {
                this.appendAttributeValue(elements[0], builder);
                int i = 1;
                while (i < elements.length) {
                    builder.append(",");
                    this.appendAttributeValue(elements[i], builder);
                    ++i;
                }
            }
            return builder.append("}");
        }
        if (value instanceof Color) {
            return builder.append("#").append(((Color)value).getRGB());
        }
        if (value instanceof String) {
            return builder.append("\"").append(value).append("\"");
        }
        return builder.append(value);
    }

    public static boolean isGeneratedTreeName(String name) {
        return name != null && name.matches("tree_[0-9]+");
    }
}

