/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.awt.Color;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.BasicAlignment;
import jebl.evolution.distances.BasicDistanceMatrix;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.graphs.Node;
import jebl.evolution.io.AlignmentImporter;
import jebl.evolution.io.DistanceMatrixImporter;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.ImportHelper;
import jebl.evolution.io.NexusExporter;
import jebl.evolution.io.SequenceImporter;
import jebl.evolution.io.TreeImporter;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.CompactRootedTree;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.SimpleRootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusImporter
implements AlignmentImporter,
SequenceImporter,
TreeImporter,
DistanceMatrixImporter {
    private boolean compactTrees = false;
    private boolean isReadingTreesBlock = false;
    private List<Taxon> treeTaxonList = null;
    private Map<String, Taxon> translationMap = Collections.emptyMap();
    private Tree nextTree = null;
    private String[] lastToken = new String[1];
    private NexusBlock nextBlock = null;
    private String nextBlockName = null;
    private int taxonCount = 0;
    private int siteCount = 0;
    private SequenceType sequenceType = null;
    private String gapCharacters = "-";
    private String matchCharacters = ".";
    private String missingCharacters = "?";
    private boolean isInterleaved = false;
    protected final ImportHelper helper;

    public NexusImporter(Reader reader, long expectedLength) {
        this.helper = new ImportHelper(reader);
        this.helper.setExpectedInputLength(expectedLength);
        this.initHelper();
    }

    public NexusImporter(Reader reader) {
        this(reader, 0L);
    }

    public NexusImporter(Reader reader, boolean compactTrees, long expectedInputLength) {
        this(reader, expectedInputLength);
        this.compactTrees = compactTrees;
    }

    @Deprecated
    public NexusImporter(Reader reader, boolean compactTrees) {
        this(reader, compactTrees, 4096L);
    }

    private void initHelper() {
        this.helper.setCommentDelimiters('[', ']', '\u0000', '!', '&');
    }

    public NexusBlock findNextBlock() throws IOException {
        this.findToken("BEGIN", true);
        this.nextBlockName = this.helper.readToken(";").toUpperCase();
        return this.findBlockName(this.nextBlockName);
    }

    private NexusBlock findBlockName(String blockName) {
        try {
            this.nextBlock = NexusBlock.valueOf(blockName);
        }
        catch (IllegalArgumentException e) {
            this.nextBlock = null;
        }
        if (this.nextBlock == null) {
            this.nextBlock = NexusBlock.UNKNOWN;
        }
        return this.nextBlock;
    }

    public String getNextBlockName() {
        return this.nextBlockName;
    }

    @Override
    public Iterator<Tree> iterator() {
        return new Iterator<Tree>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                try {
                    hasNext = NexusImporter.this.hasTree();
                }
                catch (IOException iOException) {
                }
                catch (ImportException importException) {
                    // empty catch block
                }
                return hasNext;
            }

            @Override
            public Tree next() {
                Tree tree = null;
                try {
                    tree = NexusImporter.this.importNextTree();
                }
                catch (IOException iOException) {
                }
                catch (ImportException importException) {
                    // empty catch block
                }
                if (tree == null) {
                    throw new NoSuchElementException("No more trees in this file");
                }
                return tree;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("operation is not supported by this Iterator");
            }
        };
    }

    public List<Taxon> parseTaxaBlock() throws ImportException, IOException {
        return this.readTaxaBlock();
    }

    public List<Sequence> parseCharactersBlock(List<Taxon> taxonList) throws ImportException, IOException {
        return this.readCharactersBlock(taxonList);
    }

    public List<Sequence> parseDataBlock(List<Taxon> taxonList) throws ImportException, IOException {
        return this.readDataBlock(taxonList);
    }

    public List<Tree> parseTreesBlock(List<Taxon> taxonList) throws ImportException, IOException {
        return this.readTreesBlock(taxonList);
    }

    public DistanceMatrix parseDistancesBlock(List<Taxon> taxonList) throws ImportException, IOException {
        return this.readDistancesBlock(taxonList);
    }

    @Override
    public List<Alignment> importAlignments() throws IOException, ImportException {
        boolean done = false;
        List<Taxon> taxonList = null;
        ArrayList<Alignment> alignments = new ArrayList<Alignment>();
        while (!done) {
            try {
                List<Sequence> sequences;
                NexusBlock block = this.findNextBlock();
                if (block == NexusBlock.TAXA) {
                    taxonList = this.readTaxaBlock();
                    continue;
                }
                if (block == NexusBlock.CHARACTERS) {
                    if (taxonList == null) {
                        throw new MissingBlockException("TAXA block is missing");
                    }
                    sequences = this.readCharactersBlock(taxonList);
                    alignments.add(new BasicAlignment(sequences));
                    continue;
                }
                if (block != NexusBlock.DATA) continue;
                sequences = this.readDataBlock(taxonList);
                alignments.add(new BasicAlignment(sequences));
            }
            catch (EOFException ex) {
                done = true;
            }
        }
        if (alignments.size() == 0) {
            throw new MissingBlockException("DATA or CHARACTERS block is missing");
        }
        return alignments;
    }

    @Override
    public List<Sequence> importSequences() throws IOException, ImportException {
        boolean done = false;
        List<Taxon> taxonList = null;
        List<Sequence> sequences = null;
        while (!done) {
            try {
                NexusBlock block = this.findNextBlock();
                if (block == NexusBlock.TAXA) {
                    taxonList = this.readTaxaBlock();
                    continue;
                }
                if (block == NexusBlock.CHARACTERS) {
                    if (taxonList == null) {
                        throw new MissingBlockException("TAXA block is missing");
                    }
                    sequences = this.readCharactersBlock(taxonList);
                    done = true;
                    continue;
                }
                if (block != NexusBlock.DATA) continue;
                sequences = this.readDataBlock(taxonList);
                done = true;
            }
            catch (EOFException ex) {
                done = true;
            }
        }
        if (sequences == null) {
            throw new MissingBlockException("DATA or CHARACTERS block is missing");
        }
        return sequences;
    }

    @Override
    public boolean hasTree() throws IOException, ImportException {
        if (!this.isReadingTreesBlock) {
            this.isReadingTreesBlock = this.startReadingTrees();
            this.translationMap = this.readTranslationMap(this.treeTaxonList, this.lastToken);
        }
        if (!this.isReadingTreesBlock) {
            return false;
        }
        if (this.nextTree == null) {
            this.nextTree = this.readNextTree(this.lastToken);
        }
        return this.nextTree != null;
    }

    @Override
    public Tree importNextTree() throws IOException, ImportException {
        if (!this.hasTree()) {
            this.isReadingTreesBlock = false;
            return null;
        }
        Tree tree = this.nextTree;
        this.nextTree = null;
        return tree;
    }

    @Override
    public List<Tree> importTrees() throws IOException, ImportException {
        ArrayList<Tree> result = new ArrayList<Tree>();
        while (this.hasTree()) {
            result.add(this.importNextTree());
        }
        if (result.isEmpty()) {
            throw new MissingBlockException("TREES block is missing");
        }
        return Collections.unmodifiableList(result);
    }

    public boolean startReadingTrees() throws IOException, ImportException {
        this.treeTaxonList = null;
        while (true) {
            try {
                block7: while (true) {
                    NexusBlock block = this.findNextBlock();
                    switch (block) {
                        case TAXA: {
                            this.treeTaxonList = this.readTaxaBlock();
                            continue block7;
                        }
                        case TREES: {
                            return true;
                        }
                    }
                    break;
                }
            }
            catch (EOFException eOFException) {
                return false;
            }
        }
    }

    @Override
    public List<DistanceMatrix> importDistanceMatrices() throws IOException, ImportException {
        boolean done = false;
        List<Taxon> taxonList = null;
        ArrayList<DistanceMatrix> distanceMatrices = new ArrayList<DistanceMatrix>();
        while (!done) {
            try {
                NexusBlock block = this.findNextBlock();
                if (block == NexusBlock.TAXA) {
                    taxonList = this.readTaxaBlock();
                    continue;
                }
                if (block != NexusBlock.DISTANCES) continue;
                if (taxonList == null) {
                    throw new MissingBlockException("TAXA block is missing");
                }
                DistanceMatrix distanceMatrix = this.readDistancesBlock(taxonList);
                distanceMatrices.add(distanceMatrix);
            }
            catch (EOFException ex) {
                done = true;
            }
        }
        return distanceMatrices;
    }

    private void findToken(String query, boolean ignoreCase) throws IOException {
        boolean found = false;
        do {
            String token = this.helper.readToken();
            if ((!ignoreCase || !token.equalsIgnoreCase(query)) && !token.equals(query)) continue;
            found = true;
        } while (!found);
    }

    public void findEndBlock() throws IOException {
        try {
            String token;
            while (!(token = this.helper.readToken(";")).equalsIgnoreCase("END") && !token.equalsIgnoreCase("ENDBLOCK")) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.nextBlock = NexusBlock.UNKNOWN;
    }

    private void readDataBlockHeader(String tokenToLookFor, NexusBlock block) throws ImportException, IOException {
        String token;
        boolean foundDimensions = false;
        boolean foundTitle = false;
        boolean foundFormat = false;
        do {
            if ((token = this.helper.readToken()).equalsIgnoreCase("TITLE")) {
                if (foundTitle) {
                    throw new ImportException.DuplicateFieldException("TITLE");
                }
                foundTitle = true;
                continue;
            }
            if (token.equalsIgnoreCase("DIMENSIONS")) {
                if (foundDimensions) {
                    throw new ImportException.DuplicateFieldException("DIMENSIONS");
                }
                boolean nchar = block == NexusBlock.TAXA;
                boolean ntax = block == NexusBlock.CHARACTERS;
                do {
                    String token2 = this.helper.readToken("=;");
                    if (this.helper.getLastDelimiter() != 61) {
                        throw new ImportException.BadFormatException("Unknown subcommand, '" + token2 + "', or missing '=' in DIMENSIONS command");
                    }
                    if (token2.equalsIgnoreCase("NTAX")) {
                        if (block == NexusBlock.CHARACTERS) {
                            throw new ImportException.BadFormatException("NTAX subcommand in CHARACTERS block");
                        }
                        this.taxonCount = this.helper.readInteger(";");
                        ntax = true;
                        continue;
                    }
                    if (token2.equalsIgnoreCase("NCHAR")) {
                        if (block == NexusBlock.TAXA) {
                            throw new ImportException.BadFormatException("NCHAR subcommand in TAXA block");
                        }
                        this.siteCount = this.helper.readInteger(";");
                        nchar = true;
                        continue;
                    }
                    throw new ImportException.BadFormatException("Unknown subcommand, '" + token2 + "', in DIMENSIONS command");
                } while (this.helper.getLastDelimiter() != 59);
                if (!ntax) {
                    throw new ImportException.BadFormatException("NTAX subcommand missing from DIMENSIONS command");
                }
                if (!nchar) {
                    throw new ImportException.BadFormatException("NCHAR subcommand missing from DIMENSIONS command");
                }
                foundDimensions = true;
                continue;
            }
            if (!token.equalsIgnoreCase("FORMAT")) continue;
            if (foundFormat) {
                throw new ImportException.DuplicateFieldException("FORMAT");
            }
            this.sequenceType = null;
            do {
                String token2;
                if ((token2 = this.helper.readToken("=;")).equalsIgnoreCase("GAP")) {
                    if (this.helper.getLastDelimiter() != 61) {
                        throw new ImportException.BadFormatException("Expecting '=' after GAP subcommand in FORMAT command");
                    }
                    this.gapCharacters = this.helper.readToken(";");
                    continue;
                }
                if (token2.equalsIgnoreCase("MISSING")) {
                    if (this.helper.getLastDelimiter() != 61) {
                        throw new ImportException.BadFormatException("Expecting '=' after MISSING subcommand in FORMAT command");
                    }
                    this.missingCharacters = this.helper.readToken(";");
                    continue;
                }
                if (token2.equalsIgnoreCase("MATCHCHAR")) {
                    if (this.helper.getLastDelimiter() != 61) {
                        throw new ImportException.BadFormatException("Expecting '=' after MATCHCHAR subcommand in FORMAT command");
                    }
                    this.matchCharacters = this.helper.readToken(";");
                    continue;
                }
                if (token2.equalsIgnoreCase("DATATYPE")) {
                    if (this.helper.getLastDelimiter() != 61) {
                        throw new ImportException.BadFormatException("Expecting '=' after DATATYPE subcommand in FORMAT command");
                    }
                    String token3 = this.helper.readToken(";");
                    if (token3.equalsIgnoreCase("NUCLEOTIDE") || token3.equalsIgnoreCase("DNA") || token3.equalsIgnoreCase("RNA")) {
                        this.sequenceType = SequenceType.NUCLEOTIDE;
                        continue;
                    }
                    if (token3.equalsIgnoreCase("PROTEIN")) {
                        this.sequenceType = SequenceType.AMINO_ACID;
                        continue;
                    }
                    if (!token3.equalsIgnoreCase("CONTINUOUS")) continue;
                    throw new ImportException.UnparsableDataException("Continuous data cannot be parsed at present");
                }
                if (!token2.equalsIgnoreCase("INTERLEAVE")) continue;
                this.isInterleaved = true;
            } while (this.helper.getLastDelimiter() != 59);
            foundFormat = true;
        } while (!token.equalsIgnoreCase(tokenToLookFor));
        if (!foundDimensions) {
            throw new ImportException.MissingFieldException("DIMENSIONS");
        }
        if (block != NexusBlock.TAXA && this.sequenceType == null) {
            throw new ImportException.MissingFieldException("DATATYPE. Only Nucleotide or Protein sequences are supported.");
        }
    }

    private List<Sequence> readSequenceData(List<Taxon> taxonList) throws ImportException, IOException {
        boolean sequencherStyle = false;
        String firstSequence = null;
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        if (this.isInterleaved) {
            ArrayList<StringBuilder> sequencesData = new ArrayList<StringBuilder>(this.taxonCount);
            ArrayList<Taxon> taxons = new ArrayList<Taxon>();
            List<Taxon> taxList = taxonList != null ? taxonList : taxons;
            int[] charsRead = new int[this.taxonCount];
            int i = 0;
            while (i < this.taxonCount) {
                sequencesData.add(new StringBuilder());
                charsRead[i] = 0;
                ++i;
            }
            boolean firstLoop = true;
            int readCount = 0;
            while (readCount < this.siteCount * this.taxonCount) {
                int i2 = 0;
                while (i2 < this.taxonCount) {
                    block27: {
                        String seqString;
                        int sequenceIndex;
                        block26: {
                            String token = this.helper.readToken();
                            Taxon taxon = Taxon.getTaxon(token);
                            if (firstLoop) {
                                if (taxonList != null) {
                                    sequenceIndex = taxonList.indexOf(taxon);
                                } else {
                                    sequenceIndex = taxons.size();
                                    taxons.add(taxon);
                                }
                            } else {
                                sequenceIndex = taxList.indexOf(taxon);
                            }
                            if (sequenceIndex < 0) {
                                throw new ImportException.UnknownTaxonException("Unexpected taxon:" + token + " (expecting " + taxList.get(i2).getName() + ")");
                            }
                            StringBuffer buffer = new StringBuffer();
                            this.helper.readSequenceLine(buffer, this.sequenceType, ";", this.gapCharacters, this.missingCharacters, this.matchCharacters, firstSequence);
                            seqString = buffer.toString();
                            try {
                                if (!firstLoop || Integer.parseInt(taxon.toString()) != this.taxonCount || Integer.parseInt(seqString) != this.siteCount) break block26;
                                --i2;
                                taxons.remove(taxon);
                                sequencherStyle = true;
                                break block27;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        readCount += seqString.length();
                        int n = sequenceIndex;
                        charsRead[n] = charsRead[n] + seqString.length();
                        ((StringBuilder)sequencesData.get(sequenceIndex)).append(seqString);
                        if (i2 == 0) {
                            firstSequence = seqString;
                        }
                        if (this.helper.getLastDelimiter() == 59) {
                            if (i2 < this.taxonCount - 1) {
                                throw new ImportException.TooFewTaxaException();
                            }
                            int k = 0;
                            while (k < this.taxonCount) {
                                if (charsRead[k] != this.siteCount) {
                                    throw new ImportException.ShortSequenceException(String.valueOf(taxList.get(k).getName()) + " has length " + charsRead[k] + ", expecting " + this.siteCount);
                                }
                                ++k;
                            }
                        }
                    }
                    ++i2;
                }
                firstLoop = false;
            }
            if (!sequencherStyle && this.helper.getLastDelimiter() != 59) {
                throw new ImportException.BadFormatException("Expecting ';' after sequences data");
            }
            int k = 0;
            while (k < this.taxonCount) {
                BasicSequence sequence = new BasicSequence(this.sequenceType, taxList.get(k), (CharSequence)sequencesData.get(k));
                sequences.add(sequence);
                ++k;
            }
        } else {
            int i = 0;
            while (i < this.taxonCount) {
                String token = this.helper.readToken();
                Taxon taxon = Taxon.getTaxon(token);
                if (taxonList != null && !taxonList.contains(taxon)) {
                    StringBuilder message = new StringBuilder("Expected: ").append(token).append("\nActual taxa:\n");
                    for (Taxon taxon1 : taxonList) {
                        message.append(taxon1).append("\n");
                    }
                    throw new ImportException.UnknownTaxonException(message.toString());
                }
                StringBuilder buffer = new StringBuilder();
                this.helper.readSequence(buffer, this.sequenceType, ";", this.siteCount, this.gapCharacters, this.missingCharacters, this.matchCharacters, firstSequence, true);
                String seqString = buffer.toString();
                if (seqString.length() != this.siteCount) {
                    throw new ImportException.ShortSequenceException(String.valueOf(taxon.getName()) + " has length " + seqString.length() + ", expecting " + this.siteCount);
                }
                if (i == 0) {
                    firstSequence = seqString;
                }
                if (this.helper.getLastDelimiter() == 59 && i < this.taxonCount - 1) {
                    throw new ImportException.TooFewTaxaException();
                }
                BasicSequence sequence = new BasicSequence(this.sequenceType, taxon, seqString);
                sequences.add(sequence);
                ++i;
            }
            if (this.helper.getLastDelimiter() != 59) {
                throw new ImportException.BadFormatException("Expecting ';' after sequences data");
            }
        }
        return sequences;
    }

    private List<Taxon> readTaxaBlock() throws ImportException, IOException {
        this.taxonCount = 0;
        this.readDataBlockHeader("TAXLABELS", NexusBlock.TAXA);
        if (this.taxonCount == 0) {
            throw new ImportException.MissingFieldException("NTAXA");
        }
        ArrayList<Taxon> taxa = new ArrayList<Taxon>();
        do {
            String name;
            if ((name = this.helper.readToken(";")).equals("")) {
                throw new ImportException.UnknownTaxonException("Expected nonempty taxon name, got empty string");
            }
            Taxon taxon = Taxon.getTaxon(name);
            taxa.add(taxon);
            NexusImporter.parseAndClearMetaComments(taxon, this.helper);
        } while (this.helper.getLastDelimiter() != 59);
        if (taxa.size() != this.taxonCount) {
            throw new ImportException.BadFormatException("Number of taxa doesn't match NTAXA field");
        }
        this.findEndBlock();
        return taxa;
    }

    static void parseAndClearMetaComments(Attributable item, ImportHelper importHelper) throws ImportException.BadFormatException {
        for (String meta : importHelper.getMetaComments()) {
            NexusImporter.parseMetaCommentPairs(meta, item);
        }
        importHelper.clearLastMetaComment();
    }

    private List<Sequence> readCharactersBlock(List<Taxon> taxonList) throws ImportException, IOException {
        this.siteCount = 0;
        this.sequenceType = null;
        this.readDataBlockHeader("MATRIX", NexusBlock.CHARACTERS);
        List<Sequence> sequences = this.readSequenceData(taxonList);
        this.findEndBlock();
        return sequences;
    }

    private List<Sequence> readDataBlock(List<Taxon> taxonList) throws ImportException, IOException {
        this.taxonCount = 0;
        this.siteCount = 0;
        this.sequenceType = null;
        this.readDataBlockHeader("MATRIX", NexusBlock.DATA);
        List<Sequence> sequences = this.readSequenceData(taxonList);
        this.findEndBlock();
        return sequences;
    }

    private DistanceMatrix readDistancesBlock(List<Taxon> taxonList) throws ImportException, IOException {
        if (taxonList == null) {
            throw new ImportException.BadFormatException("Missing Taxa for reading distances");
        }
        DistanceMatrixImporter.Triangle triangle = DistanceMatrixImporter.Triangle.LOWER;
        boolean diagonal = true;
        boolean labels = false;
        boolean ttl = false;
        boolean fmt = false;
        String token = this.helper.readToken();
        while (!token.equalsIgnoreCase("MATRIX")) {
            if (token.equalsIgnoreCase("TITLE")) {
                if (ttl) {
                    throw new ImportException.DuplicateFieldException("TITLE");
                }
                ttl = true;
            } else if (token.equalsIgnoreCase("FORMAT")) {
                if (fmt) {
                    throw new ImportException.DuplicateFieldException("FORMAT");
                }
                this.sequenceType = null;
                do {
                    String token2;
                    if ((token2 = this.helper.readToken("=;")).equalsIgnoreCase("TRIANGLE")) {
                        if (this.helper.getLastDelimiter() != 61) {
                            throw new ImportException.BadFormatException("Expecting '=' after TRIANGLE subcommand in FORMAT command");
                        }
                        String token3 = this.helper.readToken(";");
                        if (token3.equalsIgnoreCase("LOWER")) {
                            triangle = DistanceMatrixImporter.Triangle.LOWER;
                            continue;
                        }
                        if (token3.equalsIgnoreCase("UPPER")) {
                            triangle = DistanceMatrixImporter.Triangle.UPPER;
                            continue;
                        }
                        if (!token3.equalsIgnoreCase("BOTH")) continue;
                        triangle = DistanceMatrixImporter.Triangle.BOTH;
                        continue;
                    }
                    if (token2.equalsIgnoreCase("NODIAGONAL")) {
                        diagonal = false;
                        continue;
                    }
                    if (!token2.equalsIgnoreCase("LABELS")) continue;
                    labels = true;
                } while (this.helper.getLastDelimiter() != 59);
                fmt = true;
            }
            token = this.helper.readToken();
        }
        double[][] distances = new double[taxonList.size()][taxonList.size()];
        int i = 0;
        while (i < taxonList.size()) {
            int j;
            token = this.helper.readToken();
            Taxon taxon = Taxon.getTaxon(token);
            int index = taxonList.indexOf(taxon);
            if (index < 0) {
                StringBuilder message = new StringBuilder("Expected: ").append(token).append("\nActual taxa:\n");
                for (Taxon taxon1 : taxonList) {
                    message.append(taxon1).append("\n");
                }
                throw new ImportException.UnknownTaxonException(message.toString());
            }
            if (index != i) {
                throw new ImportException.BadFormatException("The taxon labels are in a different order to those in the TAXA block");
            }
            if (triangle == DistanceMatrixImporter.Triangle.LOWER) {
                j = 0;
                while (j < i + 1) {
                    if (i != j) {
                        distances[i][j] = this.helper.readDouble();
                        distances[j][i] = distances[i][j];
                    } else if (diagonal) {
                        distances[i][j] = this.helper.readDouble();
                    }
                    ++j;
                }
            } else if (triangle == DistanceMatrixImporter.Triangle.UPPER) {
                j = i;
                while (j < taxonList.size()) {
                    if (i != j) {
                        distances[i][j] = this.helper.readDouble();
                        distances[j][i] = distances[i][j];
                    } else if (diagonal) {
                        distances[i][j] = this.helper.readDouble();
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < taxonList.size()) {
                    distances[i][j] = i != j || diagonal ? this.helper.readDouble() : 0.0;
                    ++j;
                }
            }
            if (this.helper.getLastDelimiter() == 59 && i < taxonList.size() - 1) {
                throw new ImportException.TooFewTaxaException();
            }
            ++i;
        }
        if (this.helper.nextCharacter() != ';') {
            throw new ImportException.BadFormatException("Expecting ';' after sequences data");
        }
        this.findEndBlock();
        return new BasicDistanceMatrix(taxonList, distances);
    }

    public static String makeIntoAllowableIdentifier(String identifier) {
        identifier = identifier.replaceAll("[^\\w\\.]", "_");
        if (!Pattern.compile("[_a-zA-Z]").matcher(identifier.substring(0, 1)).matches()) {
            identifier = "_" + identifier;
        }
        return identifier;
    }

    private List<Tree> readTreesBlock(List<Taxon> taxonList) throws ImportException, IOException {
        RootedTree tree;
        ArrayList<Tree> trees = new ArrayList<Tree>();
        String[] lastToken = new String[1];
        this.translationMap = this.readTranslationMap(taxonList, lastToken);
        while ((tree = this.readNextTree(lastToken)) != null) {
            trees.add(tree);
        }
        if (trees.size() == 0) {
            throw new ImportException.BadFormatException("No trees defined in TREES block");
        }
        this.nextBlock = NexusBlock.UNKNOWN;
        return trees;
    }

    private Map<String, Taxon> readTranslationMap(List<Taxon> taxonList, String[] lastToken) throws ImportException, IOException {
        HashMap<String, Taxon> translationList = new HashMap<String, Taxon>();
        String token = this.helper.readToken(";");
        if (token.equalsIgnoreCase("TRANSLATE")) {
            do {
                String token2 = this.helper.readToken(",;");
                if (this.helper.getLastDelimiter() == 44 || this.helper.getLastDelimiter() == 59) {
                    if (token2.length() == 0 && (char)this.helper.getLastDelimiter() == ';') break;
                    throw new ImportException.BadFormatException("Missing taxon label in TRANSLATE command of TREES block");
                }
                String token3 = this.helper.readToken(",;");
                if (this.helper.getLastDelimiter() != 44 && this.helper.getLastDelimiter() != 59) {
                    throw new ImportException.BadFormatException("Expecting ',' or ';' after taxon label in TRANSLATE command of TREES block");
                }
                Taxon taxon = Taxon.getTaxon(token3);
                if (taxonList != null && !taxonList.contains(taxon)) {
                    StringBuilder message = new StringBuilder("Expected: ").append(token).append("\nActual taxa:\n");
                    for (Taxon taxon1 : taxonList) {
                        message.append(taxon1).append("\n");
                    }
                    throw new ImportException.UnknownTaxonException(message.toString());
                }
                translationList.put(token2, taxon);
            } while (this.helper.getLastDelimiter() != 59);
            token = this.helper.readToken(";");
        } else if (taxonList != null) {
            for (Taxon taxon : taxonList) {
                translationList.put(taxon.getName(), taxon);
            }
        }
        lastToken[0] = token;
        return translationList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RootedTree readNextTree(String[] lastToken) throws ImportException, IOException {
        try {
            RootedTree rootedTree;
            String treeName;
            SimpleRootedTree tree = null;
            String token = lastToken[0];
            boolean isUnrooted = token.equalsIgnoreCase("UTREE");
            if (!isUnrooted && !token.equalsIgnoreCase("TREE")) {
                if (token.equalsIgnoreCase("ENDBLOCK")) return null;
                if (!token.equalsIgnoreCase("END")) throw new ImportException.BadFormatException("Unknown command '" + token + "' in TREES block");
                return null;
            }
            if (this.helper.nextCharacter() == '*') {
                this.helper.readCharacter();
            }
            Iterator<String> iterator = this.helper.getMetaComments().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.helper.clearLastMetaComment();
                    treeName = this.helper.readToken("=;");
                    if (treeName.length() != 0) break;
                    throw new ImportException("At least one tree has no name");
                }
                String meta = iterator.next();
                if (!meta.equalsIgnoreCase("U")) continue;
                isUnrooted = true;
            }
            treeName = NexusImporter.makeIntoAllowableIdentifier(treeName);
            if (this.helper.getLastDelimiter() != 61) {
                throw new ImportException.BadFormatException("Missing label for tree '" + treeName + "' or missing '=' in TREE command of TREES block");
            }
            try {
                int last;
                if (this.helper.nextCharacter() != '(') {
                    throw new ImportException.BadFormatException("Missing tree definition in TREE command of TREES block");
                }
                List<String> comments = this.helper.getMetaComments();
                this.helper.clearLastMetaComment();
                tree = new SimpleRootedTree();
                this.readInternalNode(tree);
                if (!NexusExporter.isGeneratedTreeName(treeName)) {
                    tree.setAttribute("name", treeName);
                }
                if ((last = this.helper.getLastDelimiter()) == 58) {
                    this.helper.readDouble(";");
                    last = this.helper.getLastDelimiter();
                }
                if (last != 59) {
                    throw new ImportException.BadFormatException("Expecting ';' after tree, '" + treeName + "', TREE command of TREES block");
                }
                Iterator<String> iterator2 = comments.iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        tree.setConceptuallyUnrooted(isUnrooted);
                        break;
                    }
                    String comment = iterator2.next();
                    String commentName = comment;
                    if (commentName.contains("=")) {
                        commentName = commentName.substring(0, commentName.indexOf("="));
                    }
                    if (commentName.toUpperCase().equals("U")) {
                        isUnrooted = true;
                        continue;
                    }
                    if (comment.matches("^W\\s+[\\+\\-]?[\\d\\.]+")) {
                        tree.setAttribute("weight", Float.valueOf(comment.substring(2)));
                        continue;
                    }
                    if (commentName.toUpperCase().equals("R")) continue;
                    try {
                        NexusImporter.parseMetaCommentPairs(comment, tree);
                    }
                    catch (ImportException.BadFormatException e) {
                        tree.setAttribute("comment", comment);
                    }
                }
            }
            catch (EOFException e) {
                return tree;
            }
            token = this.helper.readToken(";");
            lastToken[0] = token;
            if (!this.compactTrees) {
                rootedTree = tree;
                return rootedTree;
            }
            rootedTree = new CompactRootedTree(tree);
            return rootedTree;
        }
        catch (EOFException e) {
            return null;
        }
    }

    private Node readBranch(SimpleRootedTree tree) throws IOException, ImportException {
        this.helper.clearLastMetaComment();
        Node branch = this.helper.nextCharacter() == '(' ? this.readInternalNode(tree) : this.readExternalNode(tree);
        if (this.helper.getLastDelimiter() == 58) {
            double length = this.helper.readDouble(",():;");
            tree.setLength(branch, length);
        }
        NexusImporter.parseAndClearMetaComments(tree.getParentEdge(branch), this.helper);
        return branch;
    }

    private Node readInternalNode(SimpleRootedTree tree) throws IOException, ImportException {
        ArrayList<Node> children = new ArrayList<Node>();
        this.helper.readCharacter();
        children.add(this.readBranch(tree));
        this.helper.getLastDelimiter();
        while (this.helper.getLastDelimiter() == 44) {
            children.add(this.readBranch(tree));
        }
        if (this.helper.getLastDelimiter() != 41) {
            throw new ImportException.BadFormatException("Missing closing ')' in tree");
        }
        SimpleRootedTree.SimpleRootedNode node = tree.createInternalNode(children);
        String token = this.helper.readToken(":(),;").trim();
        if (token.length() > 0) {
            node.setAttribute("label", NexusImporter.parseValue(token));
        }
        NexusImporter.parseAndClearMetaComments(node, this.helper);
        return node;
    }

    private Node readExternalNode(SimpleRootedTree tree) throws ImportException, IOException {
        Taxon taxon;
        String label = this.helper.readToken(":(),;");
        if ("".equals(label)) {
            throw new ImportException.UnknownTaxonException("Emtpy node names are not allowed.");
        }
        try {
            taxon = Taxon.getTaxon(label);
        }
        catch (IllegalArgumentException e) {
            throw new ImportException.UnknownTaxonException(e.getMessage());
        }
        if (this.translationMap.size() > 0 && (taxon = this.translationMap.get(label)) == null) {
            throw new ImportException.UnknownTaxonException("Taxon in tree, '" + label + "' is unknown");
        }
        try {
            Node node = tree.createExternalNode(taxon);
            NexusImporter.parseAndClearMetaComments(node, this.helper);
            return node;
        }
        catch (IllegalArgumentException e) {
            throw new ImportException.DuplicateTaxaException(e.getMessage());
        }
    }

    static void parseMetaCommentPairs(String meta, Attributable item) throws ImportException.BadFormatException {
        Pattern pattern = Pattern.compile("(\"[^\"]*\"+|[^,=\\s]+)\\s*(=\\s*(\\{[^=}]*\\}|\"[^\"]*\"+|[^,]+))?");
        Matcher matcher = pattern.matcher(meta);
        while (matcher.find()) {
            String label = matcher.group(1);
            if (label.charAt(0) == '\"') {
                label = label.substring(1, label.length() - 1);
            }
            if (label == null || label.trim().length() == 0) {
                throw new ImportException.BadFormatException("Badly formatted attribute: '" + matcher.group() + "'");
            }
            String value = matcher.group(2);
            if (value != null && value.trim().length() > 0) {
                item.setAttribute(label, NexusImporter.parseValue(value.substring(1)));
                continue;
            }
            item.setAttribute(label, Boolean.TRUE);
        }
    }

    static Object parseValue(String value) {
        if ((value = value.trim()).startsWith("{")) {
            String[] elements = value.substring(1, value.length() - 1).split(",");
            Object[] values = new Object[elements.length];
            int i = 0;
            while (i < elements.length) {
                values[i] = NexusImporter.parseValue(elements[i]);
                ++i;
            }
            return values;
        }
        if (value.startsWith("#")) {
            try {
                return Color.decode(value.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.subSequence(1, value.length() - 1);
        }
        if (value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("FALSE")) {
            return Boolean.valueOf(value);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException2) {
                return value;
            }
        }
    }

    public static class MissingBlockException
    extends ImportException {
        public MissingBlockException() {
        }

        public MissingBlockException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NexusBlock {
        UNKNOWN,
        TAXA,
        CHARACTERS,
        DATA,
        UNALIGNED,
        DISTANCES,
        TREES;

    }
}

