/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;
import jebl.util.AttributableHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalSequence
implements Sequence {
    private AttributableHelper helper = null;
    private final Taxon taxon;
    private final SequenceType sequenceType;
    private final byte[] sequence;

    public CanonicalSequence(SequenceType sequenceType, Taxon taxon, CharSequence sequenceString) {
        if (sequenceType == null) {
            throw new IllegalArgumentException("sequenceType is not allowed to be null");
        }
        if (taxon == null) {
            throw new IllegalArgumentException("taxon is not allowed to be null");
        }
        this.sequenceType = sequenceType;
        this.taxon = taxon;
        int len = sequenceString.length();
        this.sequence = new byte[len];
        int i = 0;
        while (i < len) {
            State state = sequenceType.getState(sequenceString.charAt(i));
            if (state == null) {
                state = sequenceType.getUnknownState();
            }
            this.sequence[i] = (byte)state.getIndex();
            ++i;
        }
    }

    public CanonicalSequence(SequenceType sequenceType, Taxon taxon, State[] states) {
        this.sequenceType = sequenceType;
        this.taxon = taxon;
        this.sequence = new byte[states.length];
        int i = 0;
        while (i < this.sequence.length) {
            this.sequence[i] = (byte)states[i].getIndex();
            ++i;
        }
    }

    @Override
    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    @Override
    public String getString() {
        StringBuilder buffer = new StringBuilder(this.sequence.length);
        byte[] byArray = this.sequence;
        int n = this.sequence.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            buffer.append(this.sequenceType.getState(i).getCode());
            ++n2;
        }
        return buffer.toString();
    }

    public String getCleanString() {
        StringBuilder buffer = new StringBuilder(this.sequence.length);
        byte[] byArray = this.sequence;
        int n = this.sequence.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            State state = this.sequenceType.getState(i);
            if (!state.isAmbiguous() && !state.isGap()) {
                buffer.append(this.sequenceType.getState(i).getCode());
            }
            ++n2;
        }
        return buffer.toString();
    }

    @Override
    public State[] getStates() {
        return this.sequenceType.toStateArray(this.sequence);
    }

    @Override
    public byte[] getStateIndices() {
        return this.sequence;
    }

    @Override
    public State getState(int site) {
        return this.sequenceType.getState(this.sequence[site]);
    }

    @Override
    public int getLength() {
        return this.sequence.length;
    }

    @Override
    public Taxon getTaxon() {
        return this.taxon;
    }

    public int compareTo(Object o) {
        return this.taxon.compareTo(((Sequence)o).getTaxon());
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }
}

