/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Map;
import java.util.Set;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredSequence
implements Sequence {
    private final Sequence source;
    private State[] sequence = null;

    public FilteredSequence(Sequence source) {
        this.source = source;
    }

    @Override
    public SequenceType getSequenceType() {
        return this.source.getSequenceType();
    }

    @Override
    public String getString() {
        if (this.sequence == null) {
            this.sequence = this.filterSequence(this.source);
        }
        StringBuilder buffer = new StringBuilder();
        State[] stateArray = this.sequence;
        int n = this.sequence.length;
        int n2 = 0;
        while (n2 < n) {
            State aSequence = stateArray[n2];
            buffer.append(aSequence.getCode());
            ++n2;
        }
        return buffer.toString();
    }

    @Override
    public State[] getStates() {
        if (this.sequence == null) {
            this.sequence = this.filterSequence(this.source);
        }
        return this.sequence;
    }

    @Override
    public byte[] getStateIndices() {
        if (this.sequence == null) {
            this.sequence = this.filterSequence(this.source);
        }
        byte[] stateIndices = new byte[this.sequence.length];
        int i = 0;
        State[] stateArray = this.sequence;
        int n = this.sequence.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            stateIndices[i] = (byte)state.getIndex();
            ++i;
            ++n2;
        }
        return stateIndices;
    }

    @Override
    public State getState(int site) {
        if (this.sequence == null) {
            this.sequence = this.filterSequence(this.source);
        }
        return this.sequence[site];
    }

    @Override
    public int getLength() {
        if (this.sequence == null) {
            this.sequence = this.filterSequence(this.source);
        }
        return this.sequence.length;
    }

    protected abstract State[] filterSequence(Sequence var1);

    @Override
    public Taxon getTaxon() {
        return this.source.getTaxon();
    }

    public int compareTo(Object o) {
        return this.source.compareTo(o);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.source.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.source.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.source.removeAttribute(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.source.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.source.getAttributeMap();
    }
}

