/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.io.BufferedReader;
import java.io.FileReader;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.taxa.Taxon;

public class SequenceTester {
    public static String readSequence(String name) {
        try {
            BufferedReader br1 = new BufferedReader(new FileReader(name));
            String sq1 = "";
            String line = br1.readLine();
            if (!line.substring(0, 1).equals(">")) {
                sq1 = String.valueOf(sq1) + line;
            }
            line = br1.readLine();
            while (line != null) {
                if (line.substring(0, 1).equals(">")) break;
                sq1 = sq1.concat(line.trim());
                line = br1.readLine();
            }
            return sq1;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Sequence getTestSequence1() {
        return new BasicSequence(SequenceType.AMINO_ACID, Taxon.getTaxon("sequence1"), "PLQMKKTAFTLLLFIALTLTTSPLVNGSEKSEEINEKDLRKKSELQGTALGNLKQIYYYNEKAKTENKESHDQFLQHTILFKGFFTDHSWYNDLLVDFDSKDIVDKYKGKKVDLYGAYYGYQCAGGTPNKTACMYGGVTLHDNNRLTEEKKVPINLWLDGKQNTVPLETVKTNKKNVTVQELDLQARRYLQEKYNLYNSDVFDGKVQRGLIVFHTSTEPSVNYDLFGAQGQYSNTLLRIYRDNKTISSENMHIDIYLYTSY");
    }

    public static Sequence getTestSequence2() {
        return new BasicSequence(SequenceType.AMINO_ACID, Taxon.getTaxon("sequence2"), "MYKRLFISHVILIFALILVISTPNVLAESQPDPKPDELHKSSKFTGLMENMKVLYDDNHVSAINVKSIDQFLYFDLIYSIKDTKLGNYDNVRVEFKNKDLADKYKDKYVDVFGANYYYQCYFSKKTNDINSHQTDKRKTCMYGGVTEHNGNQLDKYRSITVRVFEDGKNLLSFDVQTNKKKVTAQELDYLTRHYLVKNKKLYEFNNSPYETGYIKFIENENSFWYDMMPAPGDKFDQSKYLMMYNDNKMVDSKDVKIEVYLTTKKK");
    }

    public static String getTestSequence1(String[] arguments) {
        if (arguments.length > 0) {
            return SequenceTester.readSequence(arguments[0]);
        }
        return SequenceTester.getTestSequence1().getString();
    }

    public static String getTestSequence2(String[] arguments) {
        if (arguments.length > 1) {
            return SequenceTester.readSequence(arguments[1]);
        }
        return SequenceTester.getTestSequence2().getString();
    }
}

