/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import jebl.evolution.sequences.AminoAcidState;
import jebl.evolution.sequences.AminoAcids;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.CodonState;
import jebl.evolution.sequences.GaplessSequence;
import jebl.evolution.sequences.GeneticCode;
import jebl.evolution.sequences.NucleotideState;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;

public class Utils {
    private Utils() {
    }

    public static Sequence translate(Sequence sequence, GeneticCode geneticCode) {
        return new BasicSequence(SequenceType.AMINO_ACID, sequence.getTaxon(), Utils.translate(sequence.getStates(), geneticCode));
    }

    public static AminoAcidState[] translate(State[] states, GeneticCode geneticCode) {
        if (states == null) {
            throw new NullPointerException("States array is null");
        }
        if (states.length == 0) {
            return new AminoAcidState[0];
        }
        if (states[0] instanceof NucleotideState) {
            AminoAcidState[] translation = new AminoAcidState[states.length / 3];
            int i = 0;
            while (i < translation.length) {
                translation[i] = geneticCode.getTranslation((NucleotideState)states[i * 3], (NucleotideState)states[i * 3 + 1], (NucleotideState)states[i * 3 + 2]);
                ++i;
            }
            return translation;
        }
        if (states[0] instanceof CodonState) {
            AminoAcidState[] translation = new AminoAcidState[states.length];
            int i = 0;
            while (i < translation.length) {
                translation[i] = geneticCode.getTranslation((CodonState)states[i]);
                ++i;
            }
            return translation;
        }
        throw new IllegalArgumentException("Given states are not nucleotides or codons so cannot be translated");
    }

    public static boolean isPredominantlyRNA(CharSequence sequenceString, int maximumNonGapsToLookAt) {
        int length = sequenceString.length();
        int tCount = 0;
        int uCount = 0;
        if (maximumNonGapsToLookAt == -1) {
            maximumNonGapsToLookAt = Integer.MAX_VALUE;
        }
        int i = 0;
        while (i < length && maximumNonGapsToLookAt > 0) {
            char c = sequenceString.charAt(i);
            if (c != '-') {
                --maximumNonGapsToLookAt;
            }
            if (c == 'T' || c == 't') {
                ++tCount;
            }
            if (c == 'U' || c == 'u') {
                ++uCount;
            }
            ++i;
        }
        return uCount > tCount;
    }

    private static String reverseComplement(String nucleotideSequence, boolean removeGaps) {
        boolean predominantlyRNA = Utils.isPredominantlyRNA(nucleotideSequence, -1);
        Sequence seq = new BasicSequence(SequenceType.NUCLEOTIDE, Taxon.getTaxon("x"), nucleotideSequence);
        if (removeGaps) {
            seq = new GaplessSequence(seq);
        }
        int length = seq.getLength();
        StringBuilder results = new StringBuilder();
        int i = length - 1;
        while (i >= 0) {
            State state = seq.getState(i);
            NucleotideState complementaryState = Nucleotides.COMPLEMENTARY_STATES[state.getIndex()];
            if (predominantlyRNA && complementaryState.equals(Nucleotides.T_STATE)) {
                results.append('U');
            } else {
                results.append(complementaryState.getCode());
            }
            --i;
        }
        return results.toString();
    }

    public static String reverseComplement(String nucleotideSequence) {
        return Utils.reverseComplement(nucleotideSequence, true);
    }

    public static String reverseComplementWithGaps(String nucleotideSequence) {
        return Utils.reverseComplement(nucleotideSequence, false);
    }

    public static String translateCharSequence(CharSequence nucleotideSequence, GeneticCode geneticCode) {
        Sequence seq = new BasicSequence(SequenceType.NUCLEOTIDE, Taxon.getTaxon("x"), nucleotideSequence);
        seq = new GaplessSequence(seq);
        State[] states = seq.getStates();
        states = Utils.translate(states, geneticCode);
        seq = new BasicSequence(SequenceType.AMINO_ACID, Taxon.getTaxon("x"), states);
        return seq.getString();
    }

    public static String translate(String nucleotideSequence, GeneticCode geneticCode) {
        return Utils.translateCharSequence(nucleotideSequence, geneticCode);
    }

    public static State[] stripGaps(State[] sequence) {
        int count = 0;
        State[] stateArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            if (!state.isGap()) {
                ++count;
            }
            ++n2;
        }
        State[] stripped = new State[count];
        int index = 0;
        State[] stateArray2 = sequence;
        int n3 = sequence.length;
        int n4 = 0;
        while (n4 < n3) {
            State state = stateArray2[n4];
            if (!state.isGap()) {
                stripped[index] = state;
                ++index;
            }
            ++n4;
        }
        return stripped;
    }

    public static State[] reverse(State[] sequence) {
        State[] reversed = new State[sequence.length];
        int i = 0;
        while (i < sequence.length) {
            reversed[i] = sequence[sequence.length - i - 1];
            ++i;
        }
        return reversed;
    }

    public static NucleotideState[] complement(NucleotideState[] sequence) {
        NucleotideState[] complemented = new NucleotideState[sequence.length];
        int i = 0;
        while (i < sequence.length) {
            complemented[i] = Nucleotides.COMPLEMENTARY_STATES[sequence[i].getIndex()];
            ++i;
        }
        return complemented;
    }

    public static NucleotideState[] reverseComplement(NucleotideState[] sequence) {
        NucleotideState[] reverseComplemented = new NucleotideState[sequence.length];
        int i = 0;
        while (i < sequence.length) {
            reverseComplemented[i] = Nucleotides.COMPLEMENTARY_STATES[sequence[sequence.length - i - 1].getIndex()];
            ++i;
        }
        return reverseComplemented;
    }

    public static byte[] getStateIndices(State[] sequence) {
        byte[] indices = new byte[sequence.length];
        int i = 0;
        State[] stateArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            indices[i] = (byte)state.getIndex();
            ++i;
            ++n2;
        }
        return indices;
    }

    public static int getGaplessLocation(Sequence sequence, int gappedLocation) {
        int gapless = 0;
        int gapped = 0;
        State[] stateArray = sequence.getStates();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            if (gapped == gappedLocation) {
                return gapless;
            }
            if (!state.isGap()) {
                ++gapless;
            }
            ++gapped;
            ++n2;
        }
        return gapless;
    }

    public static int getGappedLocation(Sequence sequence, int gaplessLocation) {
        int gapless = 0;
        int gapped = 0;
        State[] stateArray = sequence.getStates();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            if (gapless == gaplessLocation) {
                return gapped;
            }
            if (!state.isGap()) {
                ++gapless;
            }
            ++gapped;
            ++n2;
        }
        return gapped;
    }

    public static SequenceType guessSequenceType(CharSequence seq) {
        SequenceType result;
        int sequenceLength;
        int canonicalNucStates = 0;
        int undeterminedStates = 0;
        int seqLen = sequenceLength = seq.length();
        int canonicalStateCount = Nucleotides.getCanonicalStateCount();
        boolean onlyValidNucleotides = true;
        boolean onlyValidAminoAcids = true;
        int k = 0;
        while (k < seqLen && (onlyValidNucleotides || onlyValidAminoAcids)) {
            char c = seq.charAt(k);
            NucleotideState nucState = Nucleotides.getState(c);
            boolean isNucState = nucState != null;
            boolean isAminoState = AminoAcids.getState(c) != null;
            onlyValidAminoAcids &= isAminoState;
            if (onlyValidNucleotides &= isNucState) {
                assert (isNucState);
                if (nucState.getIndex() < canonicalStateCount) {
                    ++canonicalNucStates;
                } else if (nucState == Nucleotides.GAP_STATE) {
                    --sequenceLength;
                } else if (nucState == Nucleotides.N_STATE) {
                    ++undeterminedStates;
                }
            }
            ++k;
        }
        if (onlyValidNucleotides) {
            if (sequenceLength >= 100) {
                result = SequenceType.NUCLEOTIDE;
            } else {
                double threshold = 0.7;
                int nucStates = canonicalNucStates + undeterminedStates;
                result = (double)nucStates >= (double)sequenceLength * 0.7 ? SequenceType.NUCLEOTIDE : SequenceType.AMINO_ACID;
            }
        } else {
            result = onlyValidAminoAcids ? SequenceType.AMINO_ACID : null;
        }
        return result;
    }

    public static State[] cleanSequence(CharSequence seq, SequenceType type) {
        int count = 0;
        int i = 0;
        while (i < seq.length()) {
            char c = seq.charAt(i);
            if (type.getState(c) != null) {
                ++count;
            }
            ++i;
        }
        State[] cleaned = new State[count];
        int index = 0;
        int i2 = 0;
        while (i2 < seq.length()) {
            char c = seq.charAt(i2);
            State state = type.getState(c);
            if (state != null) {
                cleaned[index] = state;
                ++index;
            }
            ++i2;
        }
        return cleaned;
    }

    public static String toString(State[] states) {
        StringBuilder builder = new StringBuilder();
        State[] stateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            builder.append(state.getCode());
            ++n2;
        }
        return builder.toString();
    }
}

