/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.substmodel;

import jebl.evolution.sequences.SequenceType;
import jebl.evolution.substmodel.MatrixExponential;
import jebl.evolution.substmodel.RateMatrix;

public abstract class AbstractRateMatrix
implements RateMatrix {
    private int dimension;
    private double[] frequency;
    private double[][] rate;
    private SequenceType sequenceType;
    private transient MatrixExponential matrixExp_;
    private transient boolean rebuildModel_ = false;
    private double[] parameterStore_ = null;

    protected AbstractRateMatrix(int dim) {
        this.dimension = dim;
        this.frequency = new double[dim];
        this.rate = new double[dim][dim];
        this.scheduleRebuild();
    }

    private void scheduleRebuild() {
        this.rebuildModel_ = true;
    }

    public int getDimension() {
        return this.dimension;
    }

    public double[] getEquilibriumFrequencies() {
        return this.frequency;
    }

    public double getEquilibriumFrequency(int i) {
        return this.frequency[i];
    }

    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    protected final void setSequenceType(SequenceType dt) {
        this.sequenceType = dt;
    }

    public double[][] getRelativeRates() {
        return this.rate;
    }

    public double getTransitionProbability(int fromState, int toState) {
        return this.matrixExp_.getTransitionProbability(fromState, toState);
    }

    private void handleRebuild() {
        if (this.matrixExp_ == null) {
            this.matrixExp_ = new MatrixExponential(this);
        }
        if (this.rebuildModel_) {
            this.rebuildRateMatrix(this.rate, this.parameterStore_);
            this.fromQToR();
        }
    }

    public final void rebuild() {
    }

    public final void setDistance(double distance) {
        this.handleRebuild();
        this.matrixExp_.setDistance(distance);
    }

    public final void setDistanceTranspose(double distance) {
        this.handleRebuild();
        this.matrixExp_.setDistanceTranspose(distance);
    }

    public final void getTransitionProbabilities(double[][] probabilityStore) {
        this.matrixExp_.getTransitionProbabilities(probabilityStore);
    }

    public void scale(double scale) {
        this.normalize(scale);
        this.updateMatrixExp();
    }

    protected void setFrequencies(double[] f) {
        System.arraycopy(f, 0, this.frequency, 0, this.dimension);
        this.checkFrequencies();
        this.scheduleRebuild();
    }

    public double setParametersNoScale(double[] parameters) {
        this.rebuildRateMatrix(this.rate, parameters);
        double result = this.incompleteFromQToR();
        this.rebuildModel_ = false;
        return result;
    }

    private void fromQToR() {
        int i = 0;
        while (i < this.dimension) {
            int j = i + 1;
            while (j < this.dimension) {
                double q = this.rate[i][j];
                this.rate[i][j] = q * this.frequency[j];
                this.rate[j][i] = q * this.frequency[i];
                ++j;
            }
            ++i;
        }
        this.makeValid();
        this.normalize();
        this.updateMatrixExp();
    }

    private double incompleteFromQToR() {
        int i = 0;
        while (i < this.dimension) {
            int j = i + 1;
            while (j < this.dimension) {
                double q = this.rate[i][j];
                this.rate[i][j] = q * this.frequency[j];
                this.rate[j][i] = q * this.frequency[i];
                ++j;
            }
            ++i;
        }
        return this.makeValid();
    }

    protected abstract void rebuildRateMatrix(double[][] var1, double[] var2);

    protected void updateMatrixExp() {
        if (this.matrixExp_ == null) {
            this.matrixExp_ = new MatrixExponential(this);
        } else {
            this.matrixExp_.setMatrix(this);
        }
    }

    private double makeValid() {
        double total = 0.0;
        int i = 0;
        while (i < this.dimension) {
            double sum = 0.0;
            int j = 0;
            while (j < this.dimension) {
                if (i != j) {
                    sum += this.rate[i][j];
                }
                ++j;
            }
            this.rate[i][i] = -sum;
            total += this.frequency[i] * sum;
            ++i;
        }
        return total;
    }

    private void normalize() {
        double subst = 0.0;
        int i = 0;
        while (i < this.dimension) {
            subst += -this.rate[i][i] * this.frequency[i];
            ++i;
        }
        i = 0;
        while (i < this.dimension) {
            int j = 0;
            while (j < this.dimension) {
                this.rate[i][j] = this.rate[i][j] / subst;
                ++j;
            }
            ++i;
        }
    }

    private void normalize(double substitutionScale) {
        int i = 0;
        while (i < this.dimension) {
            int j = 0;
            while (j < this.dimension) {
                this.rate[i][j] = this.rate[i][j] / substitutionScale;
                ++j;
            }
            ++i;
        }
    }

    private void checkFrequencies() {
        double MINFDIFF = 1.0E-10;
        double MINFREQ = 1.0E-10;
        int maxi = 0;
        double sum = 0.0;
        double maxfreq = 0.0;
        int i = 0;
        while (i < this.dimension) {
            double freq = this.frequency[i];
            if (freq < MINFREQ) {
                this.frequency[i] = MINFREQ;
            }
            if (freq > maxfreq) {
                maxfreq = freq;
                maxi = i;
            }
            sum += this.frequency[i];
            ++i;
        }
        int n = maxi;
        this.frequency[n] = this.frequency[n] + (1.0 - sum);
        i = 0;
        while (i < this.dimension - 1) {
            int j = i + 1;
            while (j < this.dimension) {
                if (this.frequency[i] == this.frequency[j]) {
                    int n2 = i;
                    this.frequency[n2] = this.frequency[n2] + MINFDIFF;
                    int n3 = j;
                    this.frequency[n3] = this.frequency[n3] - MINFDIFF;
                }
                ++j;
            }
            ++i;
        }
    }

    protected final double[] getFrequencies() {
        return this.frequency;
    }
}

