/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.treemetrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.treemetrics.RootedTreeMetric;
import jebl.evolution.trees.RootedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobinsonsFouldMetric
implements RootedTreeMetric {
    private final Map<Taxon, Integer> taxonMap;

    public RobinsonsFouldMetric() {
        this.taxonMap = null;
    }

    public RobinsonsFouldMetric(List<Taxon> taxa) {
        this.taxonMap = new HashMap<Taxon, Integer>();
        int i = 0;
        while (i < taxa.size()) {
            this.taxonMap.put(taxa.get(i), i);
            ++i;
        }
    }

    @Override
    public double getMetric(RootedTree tree1, RootedTree tree2) {
        Map<Taxon, Integer> tm = this.taxonMap;
        if (tm == null) {
            ArrayList<Taxon> taxa = new ArrayList<Taxon>(tree1.getTaxa());
            tm = new HashMap<Taxon, Integer>();
            int i = 0;
            while (i < taxa.size()) {
                tm.put((Taxon)taxa.get(i), i);
                ++i;
            }
        }
        Set<String> clades1 = this.getClades(tm, tree1);
        Set<String> clades2 = this.getClades(tm, tree2);
        clades1.removeAll(clades2);
        return clades1.size();
    }

    private Set<String> getClades(Map<Taxon, Integer> taxa, RootedTree tree) {
        HashSet<String> clades = new HashSet<String>();
        this.getTips(taxa, tree, tree.getRootNode(), clades);
        return clades;
    }

    private Set<Integer> getTips(Map<Taxon, Integer> taxa, RootedTree tree, Node node, Set<String> clades) {
        TreeSet<Integer> tips = new TreeSet<Integer>();
        if (tree.isExternal(node)) {
            tips.add(taxa.get(tree.getTaxon(node)));
        } else {
            Node child1 = tree.getChildren(node).get(0);
            Set<Integer> tips1 = this.getTips(taxa, tree, child1, clades);
            Node child2 = tree.getChildren(node).get(1);
            Set<Integer> tips2 = this.getTips(taxa, tree, child2, clades);
            tips.addAll(tips1);
            tips.addAll(tips2);
            clades.add(RobinsonsFouldMetric.getCladeString(tips));
        }
        return tips;
    }

    private static String getCladeString(Set<Integer> tips) {
        Iterator<Integer> iter = tips.iterator();
        StringBuffer buffer = new StringBuffer();
        buffer.append(iter.next());
        while (iter.hasNext()) {
            buffer.append(",");
            buffer.append(iter.next());
        }
        return buffer.toString();
    }
}

