/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.CladeSystem;
import jebl.evolution.trees.RootedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedCladeSystem
extends CladeSystem {
    private final List<AttributedClade> clades = new ArrayList<AttributedClade>();
    private String attributeName;

    public AttributedCladeSystem(String name) {
        this.attributeName = name;
    }

    public AttributedCladeSystem(String name, RootedTree tree) {
        super(tree);
        this.attributeName = name;
    }

    private void addClades(RootedTree tree, Node node, Set<Taxon> cladeTaxa) {
        if (tree.isExternal(node)) {
            cladeTaxa.add(tree.getTaxon(node));
        } else {
            LinkedHashSet<Taxon> childCladeTaxa = new LinkedHashSet<Taxon>();
            for (Node child : tree.getChildren(node)) {
                this.addClades(tree, child, childCladeTaxa);
            }
            this.clades.add(new AttributedClade("tmp", childCladeTaxa));
            cladeTaxa.addAll(childCladeTaxa);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributedClade {
        private String attributeName;
        private final List<Double> values = new ArrayList<Double>();
        private double frequency;
        private final Set<Taxon> taxa;

        public AttributedClade(String name, Set<Taxon> taxa) {
            this.attributeName = name;
            this.taxa = taxa;
            this.frequency = 1.0;
        }

        public double getFrequency() {
            return this.frequency;
        }

        public void setFrequency(double frequency) {
            this.frequency = frequency;
        }

        public Set<Taxon> getTaxa() {
            return this.taxa;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributedClade clade = (AttributedClade)o;
            return this.taxa.equals(clade.taxa);
        }

        public int hashCode() {
            return this.taxa.hashCode();
        }
    }
}

