/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.CompactRootedTree;
import jebl.evolution.trees.RootedFromUnrooted;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.HashPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private Utils() {
    }

    public static String toNewick(RootedTree tree) {
        StringBuilder buffer = new StringBuilder();
        Utils.toNewick(tree, tree.getRootNode(), buffer);
        buffer.append(";");
        return buffer.toString();
    }

    public static String toUniqueNewick(RootedTree tree) {
        return Utils.toUniqueNewick(tree, tree.getRootNode());
    }

    public static String toUniqueNewickByAttribute(RootedTree tree, String attribute) {
        return Utils.toUniqueNewickByAttribute(tree, tree.getRootNode(), attribute);
    }

    private static void toNewick(RootedTree tree, Node node, StringBuilder buffer) {
        if (tree.isExternal(node)) {
            String name = tree.getTaxon(node).getName();
            if (!name.matches("^(\\w|-)+$")) {
                name = "'" + name + "'";
            }
            buffer.append(name);
            if (tree.hasLengths()) {
                buffer.append(':');
                buffer.append(tree.getLength(node));
            }
        } else {
            buffer.append('(');
            List<Node> children = tree.getChildren(node);
            int last = children.size() - 1;
            int i = 0;
            while (i < children.size()) {
                Utils.toNewick(tree, children.get(i), buffer);
                buffer.append(i == last ? (char)')' : ',');
                ++i;
            }
            Node parent = tree.getParent(node);
            if (parent != null && tree.hasLengths()) {
                buffer.append(":").append(tree.getLength(node));
            }
        }
    }

    private static void branchesMinMax(RootedTree tree, Node node, double[] bounds) {
        if (tree.isExternal(node)) {
            return;
        }
        if (!tree.hasLengths()) {
            bounds[1] = 1.0;
            bounds[0] = 1.0;
            return;
        }
        List<Node> children = tree.getChildren(node);
        for (Node n : children) {
            double len = tree.getLength(n);
            bounds[0] = Math.min(bounds[0], len);
            bounds[1] = Math.max(bounds[1], len);
            Utils.branchesMinMax(tree, n, bounds);
        }
    }

    private static String[] asText(RootedTree tree, Node node, double factor) {
        String[] s;
        if (tree.isExternal(node)) {
            String name = tree.getTaxon(node).getName();
            return new String[]{String.valueOf(' ') + name};
        }
        List<Node> children = tree.getChildren(node);
        ArrayList<String[]> a = new ArrayList<String[]>(children.size());
        int[] branches = new int[children.size()];
        int tot = 0;
        int maxHeight = -1;
        int k = 0;
        for (Node n : children) {
            int branchLen;
            s = Utils.asText(tree, n, factor);
            tot += s.length;
            double len = tree.hasLengths() ? tree.getLength(n) : 1.0;
            branches[k] = branchLen = Math.max((int)Math.round(len * factor), 1);
            ++k;
            maxHeight = Math.max(maxHeight, s[0].length() + branchLen);
            a.add(s);
        }
        ArrayList<String> x = new ArrayList<String>(tot += children.size() - 1);
        int i = 0;
        while (i < a.size()) {
            s = (String[])a.get(i);
            int branchIndex = s.length / 2;
            boolean isLast = i == a.size() - 1;
            int j = 0;
            while (j < s.length) {
                char c;
                char c2 = c = j == branchIndex ? (char)'=' : ' ';
                char l = i == 0 && j < branchIndex || isLast && j > branchIndex ? (char)' ' : (j == branchIndex ? (char)'+' : '|');
                String l1 = String.valueOf(l) + Utils.rep(c, branches[i] - 1) + s[j];
                x.add(String.valueOf(l1) + Utils.rep(' ', maxHeight - l1.length()));
                ++j;
            }
            if (!isLast) {
                x.add(String.valueOf('|') + Utils.rep(' ', maxHeight - 1));
            }
            ++i;
        }
        for (String ss : x) {
            assert (ss.length() == ((String)x.get(0)).length());
        }
        return x.toArray(new String[0]);
    }

    private static String rep(char c, int count) {
        StringBuilder b = new StringBuilder();
        while (count > 0) {
            b.append(c);
            --count;
        }
        return b.toString();
    }

    private static int nodeDistance(RootedTree tree, Node node) {
        if (tree.isExternal(node)) {
            return 0;
        }
        int d = 0;
        for (Node n : tree.getChildren(node)) {
            d = Math.max(d, Utils.nodeDistance(tree, n));
        }
        return d + 1;
    }

    public static double safeNodeHeight(RootedTree tree, Node node) {
        if (tree.hasHeights()) {
            return tree.getHeight(node);
        }
        return Utils.nodeDistance(tree, node);
    }

    private static double safeTreeHeight(RootedTree tree) {
        return Utils.safeNodeHeight(tree, tree.getRootNode());
    }

    public static int maxLevels(RootedTree tree) {
        return Utils.nodeDistance(tree, tree.getRootNode());
    }

    public static String asText(Tree tree) {
        String[] lines = Utils.asText(tree, 100);
        StringBuilder builder = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            builder.append(line).append("\n");
            ++n2;
        }
        return builder.toString();
    }

    public static String[] asText(Tree tree, int widthGuide) {
        RootedTree rtree = Utils.rootTheTree(tree);
        Node root = rtree.getRootNode();
        double[] bounds = new double[]{Double.MAX_VALUE, -1.0};
        Utils.branchesMinMax(rtree, root, bounds);
        double lowBound = 2.0 / bounds[0];
        double treeHeight = Utils.safeTreeHeight(rtree);
        double treeHieghtWithLowBound = treeHeight * lowBound;
        double scale = treeHieghtWithLowBound > (double)widthGuide ? (double)widthGuide / treeHeight : (treeHeight * (lowBound = 5.0 / bounds[0]) <= (double)widthGuide ? lowBound : (double)widthGuide / treeHeight);
        return Utils.asText(rtree, root, scale);
    }

    private static double dist(Tree tree, Node root, Node node, Map<HashPair<Node>, Double> dists) throws Graph.NoEdgeException {
        HashPair<Node> p = new HashPair<Node>(root, node);
        if (dists.containsKey(p)) {
            return dists.get(p);
        }
        double maxDist = 0.0;
        for (Node n : tree.getAdjacencies(node)) {
            if (n == root) continue;
            double d = Utils.dist(tree, node, n, dists);
            maxDist = Math.max(maxDist, d);
        }
        double dist = tree.getEdgeLength(node, root) + maxDist;
        dists.put(p, dist);
        return dist;
    }

    public static RootedTree rootTheTree(Tree tree) {
        if (tree instanceof RootedTree) {
            return (RootedTree)tree;
        }
        Set<Node> d2 = tree.getNodes(2);
        if (d2.size() == 1) {
            return new RootedFromUnrooted(tree, d2.iterator().next(), true);
        }
        RootedTree rtree = Utils.rootTreeAtCenter(tree);
        assert (Graph.Utils.getDegree(rtree, rtree.getRootNode()) == 2);
        Node root = null;
        double minLength = 100.0;
        for (Node n : rtree.getChildren(rtree.getRootNode())) {
            if (rtree.isExternal(n)) continue;
            double length = rtree.getLength(n);
            if (root != null && !(length < minLength)) continue;
            minLength = length;
            root = n;
        }
        return new RootedFromUnrooted(tree, root, true);
    }

    public static RootedTree rootTreeAtCenter(Tree tree) {
        LinkedHashMap<HashPair<Node>, Double> dists = new LinkedHashMap<HashPair<Node>, Double>();
        try {
            double maxDistance = -1.7976931348623157E308;
            Node current = null;
            Node direction = null;
            for (Node e : tree.getExternalNodes()) {
                for (Node n : tree.getAdjacencies(e)) {
                    double d = Utils.dist(tree, e, n, dists);
                    if (!(d > maxDistance)) continue;
                    maxDistance = d;
                    current = e;
                    direction = n;
                }
            }
            double distanceLeft = maxDistance / 2.0;
            while (true) {
                double len;
                if (distanceLeft <= (len = tree.getEdgeLength(current, direction))) {
                    return new RootedFromUnrooted(tree, current, direction, distanceLeft);
                }
                distanceLeft -= len;
                maxDistance = -1.7976931348623157E308;
                Node next = null;
                for (Node n : tree.getAdjacencies(direction)) {
                    double d;
                    if (n == current || !((d = Utils.dist(tree, direction, n, dists)) > maxDistance)) continue;
                    maxDistance = d;
                    next = n;
                }
                current = direction;
                direction = next;
            }
        }
        catch (Graph.NoEdgeException e1) {
            return null;
        }
    }

    public static double getPathLength(Tree tree, Node node1, Node node2) {
        try {
            LinkedHashMap<HashPair<Node>, Double> dists = new LinkedHashMap<HashPair<Node>, Double>();
            return Utils.dist(tree, node1, node2, dists);
        }
        catch (Graph.NoEdgeException e1) {
            return -1.0;
        }
    }

    public static boolean isBinary(RootedTree rootedTree) {
        return rootedTree.getNodes(3).size() == rootedTree.getInternalNodes().size() - 1 && Graph.Utils.getDegree(rootedTree, rootedTree.getRootNode()) == 2;
    }

    public static boolean isUltrametric(RootedTree rootedTree) {
        Set<Node> externalNodes = rootedTree.getExternalNodes();
        for (Node externalNode : externalNodes) {
            Node node = externalNode;
            if (rootedTree.getHeight(node) == 0.0) continue;
            return false;
        }
        return true;
    }

    public static int getExternalNodeCount(RootedTree tree, Node node) {
        List<Node> children = tree.getChildren(node);
        if (children.size() == 0) {
            return 1;
        }
        int externalNodeCount = 0;
        for (Node child : children) {
            externalNodeCount += Utils.getExternalNodeCount(tree, child);
        }
        return externalNodeCount;
    }

    public static List<Node> getNodes(RootedTree tree, Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(node);
        for (Node child : tree.getChildren(node)) {
            nodes.addAll(Utils.getNodes(tree, child));
        }
        return nodes;
    }

    public static Node rightNb(RootedTree tree, Node tipNode) {
        List<Node> children;
        int loc;
        if (!tree.isExternal(tipNode)) {
            return null;
        }
        Node parent = tipNode;
        do {
            if ((parent = tree.getParent(tipNode = parent)) != null) continue;
            return null;
        } while ((loc = (children = tree.getChildren(parent)).indexOf(tipNode)) == children.size() - 1);
        assert (loc < children.size() - 1);
        Node n = children.get(loc + 1);
        while (!tree.isExternal(n)) {
            n = tree.getChildren(n).get(0);
        }
        return n;
    }

    public static Node leftNb(RootedTree tree, Node node) {
        List<Node> children;
        int loc;
        if (!tree.isExternal(node)) {
            return null;
        }
        Node parent = node;
        do {
            if ((parent = tree.getParent(node = parent)) != null) continue;
            return null;
        } while ((loc = (children = tree.getChildren(parent)).indexOf(node)) == 0);
        assert (loc > 0);
        Node n = children.get(loc - 1);
        while (!tree.isExternal(n)) {
            List<Node> ch = tree.getChildren(n);
            n = ch.get(ch.size() - 1);
        }
        return n;
    }

    public static double getMinNodeHeight(RootedTree tree, Node node) {
        List<Node> children = tree.getChildren(node);
        if (children.size() == 0) {
            return tree.getHeight(node);
        }
        double minNodeHeight = Double.MAX_VALUE;
        for (Node child : children) {
            double height = Utils.getMinNodeHeight(tree, child);
            if (!(height < minNodeHeight)) continue;
            minNodeHeight = height;
        }
        return minNodeHeight;
    }

    public static Comparator<Node> createNodeDensityComparator(final RootedTree tree) {
        return new Comparator<Node>(){

            @Override
            public int compare(Node node1, Node node2) {
                return Utils.getExternalNodeCount(tree, node2) - Utils.getExternalNodeCount(tree, node1);
            }

            public boolean equals(Node node1, Node node2) {
                return this.compare(node1, node2) == 0;
            }
        };
    }

    public static Comparator<Node> createNodeDensityMinNodeHeightComparator(final RootedTree tree) {
        return new Comparator<Node>(){

            @Override
            public int compare(Node node1, Node node2) {
                int larger = Utils.getExternalNodeCount(tree, node1) - Utils.getExternalNodeCount(tree, node2);
                if (larger != 0) {
                    return larger;
                }
                double tipRecent = Utils.getMinNodeHeight(tree, node2) - Utils.getMinNodeHeight(tree, node1);
                if (tipRecent > 0.0) {
                    return 1;
                }
                if (tipRecent < 0.0) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Node node1, Node node2) {
                return this.compare(node1, node2) == 0;
            }
        };
    }

    private static <T> Set<T> setMinus(Set<T> a, Collection<T> b) {
        LinkedHashSet<T> diff = new LinkedHashSet<T>(a);
        diff.removeAll(b);
        return Collections.unmodifiableSet(diff);
    }

    private static <T extends Comparable> List<T> sort(Collection<T> c) {
        ArrayList<T> result = new ArrayList<T>(c);
        Collections.sort(result);
        return result;
    }

    public static void assertAllTreesHaveTheSameTaxa(List<? extends Tree> trees) throws IllegalArgumentException {
        if (trees.size() <= 1) {
            return;
        }
        Tree firstTree = trees.get(0);
        int firstNumExternalNodes = firstTree.getExternalNodes().size();
        Set<Taxon> firstTaxa = firstTree.getTaxa();
        int currentTreeNumber = 0;
        for (Tree tree : trees) {
            ++currentTreeNumber;
            int numExternalNodes = tree.getExternalNodes().size();
            if (numExternalNodes == firstNumExternalNodes && tree.getTaxa().containsAll(firstTaxa)) continue;
            Set<Taxon> firstMinusCurrent = Utils.setMinus(firstTree.getTaxa(), tree.getTaxa());
            String prefix = "These " + trees.size() + " trees don't all have the same taxa: The following taxa occur in tree ";
            String suffix = ". Tree 1 has " + firstNumExternalNodes + " taxa. Tree " + currentTreeNumber + " has " + numExternalNodes + " taxa. Tree 1 has taxa: " + Utils.sort(firstTaxa) + " Tree " + currentTreeNumber + " has taxa: " + Utils.sort(tree.getTaxa());
            if (!firstMinusCurrent.isEmpty()) {
                throw new IllegalArgumentException(String.valueOf(prefix) + "1 but not in tree " + currentTreeNumber + ": " + Utils.sort(firstMinusCurrent) + suffix);
            }
            Set<Taxon> currentMinusFirst = Utils.setMinus(tree.getTaxa(), firstTree.getTaxa());
            assert (!currentMinusFirst.isEmpty());
            throw new IllegalArgumentException(String.valueOf(prefix) + currentTreeNumber + " but not in tree 1: " + Utils.sort(currentMinusFirst) + suffix);
        }
    }

    private static String toUniqueNewick(RootedTree tree, Node node) {
        return Utils.toUniqueNewickByAttribute(tree, node, null);
    }

    private static String toUniqueNewickByAttribute(RootedTree tree, Node node, String attribute) {
        StringBuilder buffer = new StringBuilder();
        if (tree.isExternal(node)) {
            Taxon taxon = tree.getTaxon(node);
            String name = attribute != null ? (String)taxon.getAttribute(attribute) : taxon.getName();
            buffer.append(name);
            if (tree.hasLengths()) {
                buffer.append(':');
                buffer.append(tree.getLength(node));
            }
        } else {
            buffer.append('(');
            List<Node> children = tree.getChildren(node);
            int last = children.size() - 1;
            ArrayList<String> childStrings = new ArrayList<String>();
            for (Node aChildren : children) {
                childStrings.add(Utils.toUniqueNewickByAttribute(tree, aChildren, attribute));
            }
            Collections.sort(childStrings, new Comparator<String>(){

                @Override
                public int compare(String arg0, String arg1) {
                    return arg1.compareTo(arg0);
                }
            });
            int i = 0;
            while (i <= last) {
                buffer.append((String)childStrings.get(i));
                buffer.append(i == last ? (char)')' : ',');
                ++i;
            }
            Node parent = tree.getParent(node);
            if (parent != null && tree.hasLengths()) {
                buffer.append(":").append(tree.getLength(node));
            }
        }
        return buffer.toString();
    }

    public static String DEBUGsubTreeRep(RootedTree tree, Node node) {
        if (tree.isExternal(node)) {
            return tree.getTaxon(node).getName();
        }
        StringBuilder b = new StringBuilder();
        for (Node x : tree.getChildren(node)) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(Utils.DEBUGsubTreeRep(tree, x));
        }
        return String.valueOf('(') + b.toString() + ')';
    }

    public static RootedTree copyTree(RootedTree treeToCopy) {
        return new CompactRootedTree(treeToCopy);
    }
}

