/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.treesimulation;

import jebl.evolution.coalescent.DemographicFunction;
import jebl.evolution.treesimulation.IntervalGenerator;

public class CoalescentIntervalGenerator
implements IntervalGenerator {
    protected DemographicFunction demographicFunction;
    private static final double LARGE_POSITIVE_NUMBER = 1.0E50;
    private static final double LARGE_NEGATIVE_NUMBER = -1.0E50;
    private static final double INTEGRATION_PRECISION = 1.0E-5;
    private static final double INTEGRATION_MAX_ITERATIONS = 50.0;

    public CoalescentIntervalGenerator(DemographicFunction demographicFunction) {
        this.demographicFunction = demographicFunction;
    }

    public double getInterval(double criticalValue, int lineageCount, double currentHeight) {
        assert (lineageCount >= 2);
        assert (criticalValue > 0.0 && criticalValue < 1.0);
        double c = -Math.log(criticalValue) / (0.5 * (double)lineageCount * (double)(lineageCount - 1));
        return this.solveForIntervalSize(c, currentHeight);
    }

    private double solveForIntervalSize(double inC, double inT) {
        assert (inT >= 0.0);
        assert (inC >= 0.0);
        double constant = inC;
        double lowBracket = 0.0;
        double highBracket = 0.0;
        double factor = 1.6;
        double gEst = 1.0;
        while (gEst < 1.0E50) {
            if (this.getIntegral(inT, inT + gEst) > constant) {
                highBracket = gEst;
                if (gEst == 1.0) {
                    lowBracket = 0.0;
                    return this.findSolution(constant, lowBracket, highBracket, inT);
                }
                lowBracket = gEst / factor;
                return this.findSolution(constant, lowBracket, highBracket, inT);
            }
            gEst *= factor;
        }
        throw new RuntimeException("Unable to bracket solution in solveForIntervalSize: inC = " + inC + ", inT = " + inT);
    }

    private double findSolution(double inConst, double lowB, double highB, double t) {
        assert (t >= 0.0);
        double solutionAccuracy = 1.0E-8;
        do {
            double halfway;
            if (this.getIntegral(t, t + (halfway = (highB - lowB) / 2.0 + lowB)) > inConst) {
                highB = halfway;
            } else {
                lowB = halfway;
            }
            assert (highB >= lowB);
        } while (highB - lowB > solutionAccuracy);
        return lowB;
    }

    private double getIntegral(double t0, double t1) {
        if (t0 == t1) {
            return 0.0;
        }
        if (this.demographicFunction.hasIntegral()) {
            return this.demographicFunction.getIntegral(t0, t1);
        }
        return this.getNumericalIntegral(t0, t1);
    }

    private double getNumericalIntegral(double inLowBound, double inHighBound) {
        double lastST = -1.0E50;
        double lastS = -1.0E50;
        assert (inHighBound > inLowBound);
        int j = 1;
        while ((double)j <= 50.0) {
            double st = this.doTrapezoid(j, inLowBound, inHighBound, lastST);
            double s = (4.0 * st - lastST) / 3.0;
            if (Math.abs(s - lastS) < 1.0E-5 * Math.abs(lastS)) {
                return s;
            }
            lastS = s;
            lastST = st;
            ++j;
        }
        throw new RuntimeException("Too many iterations in getNumericalIntegral");
    }

    private double doTrapezoid(int n, double low, double high, double lastS) {
        double s;
        if (n == 1) {
            double demoLow = this.demographicFunction.getDemographic(low);
            assert (demoLow > 0.0);
            double demoHigh = this.demographicFunction.getDemographic(high);
            assert (demoHigh > 0.0);
            s = 0.5 * (high - low) * (1.0 / demoLow + 1.0 / demoHigh);
        } else {
            int it = 1;
            int j = 1;
            while (j < n - 1) {
                it *= 2;
                ++j;
            }
            double tnm = it;
            double del = (high - low) / tnm;
            double x = low + 0.5 * del;
            double sum = 0.0;
            int j2 = 1;
            while (j2 <= it) {
                double demoX = this.demographicFunction.getDemographic(x);
                assert (demoX > 0.0);
                sum += 1.0 / demoX;
                x += del;
                ++j2;
            }
            s = 0.5 * (lastS + (high - low) * sum / tnm);
        }
        return s;
    }
}

