/*
 * Decompiled with CFR 0.152.
 */
package jebl.math;

import jebl.math.MatrixCalcException;

public final class MatrixCalc {
    public static double[][] choleskyFactor(double[][] inMatrix) throws MatrixCalcException.NotSquareMatrixException, MatrixCalcException.PositiveDefiniteException {
        if (inMatrix.length != inMatrix[0].length) {
            throw new MatrixCalcException.NotSquareMatrixException("error in CholeskyFactor, not a square matrix");
        }
        double[][] inMatrix_ent = inMatrix;
        int k = 0;
        while (k < inMatrix.length) {
            double sum = inMatrix_ent[k][k];
            double[] inMatrix_piv = inMatrix_ent[k];
            int j = 0;
            while (j < k) {
                double tmp = inMatrix_ent[k][j];
                sum -= tmp * tmp;
                ++j;
            }
            if (sum <= 0.0) {
                throw new MatrixCalcException.PositiveDefiniteException("error in CholeskyFactor, sum");
            }
            inMatrix_ent[k][k] = Math.sqrt(sum);
            int i = k + 1;
            while (i < inMatrix.length) {
                sum = inMatrix_ent[i][k];
                inMatrix_piv = inMatrix_ent[k];
                double[] inMatrix_row = inMatrix_ent[i];
                j = 0;
                while (j < k) {
                    sum -= inMatrix_ent[i][j] * inMatrix_ent[k][j];
                    sum -= inMatrix_row[j] * inMatrix_piv[j];
                    ++j;
                }
                double d = sum / inMatrix_ent[k][k];
                inMatrix_ent[i][j] = d;
                inMatrix_ent[j][i] = d;
                ++i;
            }
            ++k;
        }
        return inMatrix;
    }

    public static double[] choleskySolve(double[][] matrix, double[] vector) throws MatrixCalcException.NotSquareMatrixException {
        if (matrix.length != matrix[0].length || matrix[0].length != vector.length) {
            throw new MatrixCalcException.NotSquareMatrixException("error in CholeskySolve, not a square matrix");
        }
        double[] retVector = new double[vector.length];
        retVector = MatrixCalc.lowerSolve(matrix, vector, 0.0);
        retVector = MatrixCalc.upperSolve(matrix, retVector, 0.0);
        return retVector;
    }

    public static double[] lowerSolve(double[][] matrix, double[] vector, double diag) {
        double[] out = new double[vector.length];
        int dimension = matrix.length < matrix[0].length ? matrix.length : matrix[0].length;
        if (vector.length < dimension) {
            System.out.println("error in LSolve, problem with vector length");
            System.exit(0);
        }
        if (out.length < dimension) {
            out = new double[matrix.length];
        }
        double[][] mat_ent = matrix;
        double[] vector_ent = vector;
        double[] out_ent = out;
        int i = 0;
        while (i < dimension) {
            if (vector_ent[i] != 0.0) break;
            out_ent[i] = 0.0;
            ++i;
        }
        int i_lim = i;
        while (i < dimension) {
            double sum = vector_ent[i];
            int j = i_lim;
            while (j < i) {
                sum -= mat_ent[i][j] * out_ent[j];
                ++j;
            }
            if (diag == 0.0) {
                if (mat_ent[i][i] == 0.0) {
                    System.out.println("error in LSolve, error in matrix");
                    System.exit(0);
                } else {
                    out_ent[i] = sum / mat_ent[i][i];
                }
            } else {
                out_ent[i] = sum / diag;
            }
            ++i;
        }
        return out;
    }

    public static double[] upperSolve(double[][] matrix, double[] vector, double diag) {
        int ilim = 0;
        double[] out = new double[matrix.length];
        int dimension = matrix.length < matrix[0].length ? matrix.length : matrix[0].length;
        if (vector.length < dimension) {
            System.out.println("error in upperSolve");
            System.exit(1);
        }
        if (out == null || out.length < dimension) {
            out = new double[matrix.length];
        }
        if (out.length < dimension) {
            out = new double[matrix.length];
        }
        double[][] matrix_ent = matrix;
        double[] vector_ent = vector;
        double[] out_ent = out;
        int i = dimension - 1;
        while (i >= 0) {
            if (vector_ent[i] != 0.0) break;
            out_ent[i] = 0.0;
            --i;
        }
        ilim = i;
        while (i >= 0) {
            double sum = vector_ent[i];
            int j = i + 1;
            while (j <= ilim) {
                sum -= matrix_ent[i][j] * out_ent[j];
                ++j;
            }
            if (diag == 0.0) {
                if (matrix_ent[i][i] == 0.0) {
                    System.out.println("error in USolve");
                    System.exit(1);
                } else {
                    out_ent[i] = sum / matrix_ent[i][i];
                }
            } else {
                out_ent[i] = sum / diag;
            }
            --i;
        }
        return out;
    }

    public static double innerProduct(double[] vector1, double[] vector2, int x) throws IndexOutOfBoundsException {
        double sum = 0.0;
        int length = vector1.length < vector2.length ? vector1.length : vector2.length;
        if (x > length) {
            throw new IndexOutOfBoundsException("innerProduct int x out of vector bounds");
        }
        int i = x;
        while (i < length) {
            sum += vector1[i] * vector2[i];
            ++i;
        }
        return sum;
    }

    public static double[] getColumn(double[][] matrix, int column) {
        double[] x = new double[matrix.length];
        int i = 0;
        while (i < x.length) {
            x[i] = matrix[i][column];
            ++i;
        }
        return x;
    }

    public static double[][] deleteMatrixRow(double[][] matrix, int row) {
        double[][] x = new double[matrix.length - 1][matrix[0].length];
        int j = 0;
        int i = 0;
        while (i < matrix.length) {
            if (i != row) {
                System.arraycopy(matrix[i], 0, x[j], 0, matrix[i].length);
                ++j;
            }
            ++i;
        }
        return x;
    }

    public static double[][] deleteMatrixColumn(double[][] matrix, int column) {
        double[][] x = new double[matrix.length][matrix[0].length - 1];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            int k = 0;
            while (k < matrix[i].length) {
                if (k != column) {
                    x[i][j] = matrix[i][k];
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        return x;
    }

    public static double[] reverseVector(double[] vector) {
        double[] x = new double[vector.length];
        int j = 0;
        int i = vector.length - 1;
        while (i >= 0) {
            x[i] = vector[j];
            ++j;
            --i;
        }
        return x;
    }

    public static double[][] reverseMatrix(double[][] matrix) {
        double[][] x = new double[matrix.length][matrix[0].length];
        int j = 0;
        int i = matrix.length - 1;
        while (i >= 0) {
            int k = 0;
            int h = matrix[0].length - 1;
            while (h >= 0) {
                x[j][k] = matrix[i][h];
                ++k;
                --h;
            }
            ++j;
            --i;
        }
        return x;
    }

    public static double sumVector(double[] vector) {
        double sum = 0.0;
        double[] dArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            double aVector = dArray[n2];
            sum += aVector;
            ++n2;
        }
        return sum;
    }

    public static double[][] copyMatrix(double[][] matrix) {
        double[][] x = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < x.length) {
            int j = 0;
            while (j < x[i].length) {
                x[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return x;
    }
}

