/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;

public class FileUtilities {
    private static final Logger logger = Logger.getLogger(FileUtilities.class);
    private static int preferedWidth = 650;
    private static int preferedHeight = 450;

    public static File selectOpenFileViaChooser(File suggestedFile, Component parentComponent) {
        File selectedFile = null;
        if (OSNativeUtils.isRunningDefectJFilechooserJVM()) {
            Component root = SwingUtilities.getRoot(parentComponent);
            Frame parentFrame = null;
            if (root instanceof Frame) {
                parentFrame = (Frame)root;
            }
            FileDialog dialog = new FileDialog(parentFrame, "Open", 0);
            dialog.setDirectory(suggestedFile.getParent());
            dialog.setVisible(true);
            String fileDirectory = dialog.getDirectory();
            String fileName = dialog.getFile();
            if (fileName != null) {
                selectedFile = new File(fileDirectory, fileName);
            }
        } else {
            Boolean old = UIManager.getBoolean("FileChooser.readOnly");
            UIManager.put("FileChooser.readOnly", Boolean.TRUE);
            JFileChooser fc = new JFileChooser(suggestedFile);
            fc.setPreferredSize(new Dimension(preferedWidth, preferedHeight));
            int returnVal = fc.showOpenDialog(parentComponent);
            UIManager.put("FileChooser.readOnly", old);
            selectedFile = returnVal == 0 ? fc.getSelectedFile() : null;
            preferedWidth = fc.getSize().width;
            preferedHeight = fc.getSize().height;
        }
        System.out.println("selectedfile" + selectedFile);
        return selectedFile;
    }

    public static File selectSaveFileViaChooser(File suggestedFile, Component parentComponent) {
        File selectedFile = null;
        if (OSNativeUtils.isRunningDefectJFilechooserJVM()) {
            Component root = SwingUtilities.getRoot(parentComponent);
            Frame parentFrame = null;
            if (root instanceof Frame) {
                parentFrame = (Frame)root;
            }
            FileDialog dialog = new FileDialog(parentFrame, "Save", 1);
            dialog.setDirectory(suggestedFile.getParent());
            dialog.setFile(suggestedFile.getName());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            String directory = dialog.getDirectory();
            if (fileName != null && directory != null) {
                selectedFile = new File(directory, fileName);
            }
        } else {
            JFileChooser fc = new JFileChooser();
            fc.setSelectedFile(suggestedFile);
            fc.setPreferredSize(new Dimension(preferedWidth, preferedHeight));
            int returnVal = fc.showSaveDialog(parentComponent);
            selectedFile = returnVal == 0 ? fc.getSelectedFile() : null;
            preferedWidth = fc.getSize().width;
            preferedHeight = fc.getSize().height;
        }
        return selectedFile;
    }
}

