/*
 * Decompiled with CFR 0.152.
 */
package utils;

import aliview.AliView;
import java.awt.Desktop;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSXHandlerJava9
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(OSXHandlerJava9.class.getName());

    public OSXHandlerJava9() {
        try {
            Class<?> quitHandler = Class.forName("java.awt.desktop.QuitHandler");
            Class<?> aboutHandler = Class.forName("java.awt.desktop.AboutHandler");
            Class<?> openFilesHandler = Class.forName("java.awt.desktop.OpenFilesHandler");
            Class<?> preferencesHandler = Class.forName("java.awt.desktop.PreferencesHandler");
            Object proxy = Proxy.newProxyInstance(OSXHandlerJava9.class.getClassLoader(), new Class[]{quitHandler, aboutHandler, openFilesHandler, preferencesHandler}, (InvocationHandler)this);
            this.setHandlers(Desktop.class, quitHandler, aboutHandler, openFilesHandler, preferencesHandler, proxy, Desktop.getDesktop());
        }
        catch (Exception ex) {
            logger.error("Failed to register with OSX: " + ex);
        }
    }

    protected void setHandlers(Class<?> appClass, Class<?> quitHandler, Class<?> aboutHandler, Class<?> openFilesHandler, Class<?> preferencesHandler, Object proxy, Object appInstance) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        appClass.getDeclaredMethod("setQuitHandler", quitHandler).invoke(appInstance, proxy);
        appClass.getDeclaredMethod("setAboutHandler", aboutHandler).invoke(appInstance, proxy);
        appClass.getDeclaredMethod("setOpenFileHandler", openFilesHandler).invoke(appInstance, proxy);
        appClass.getDeclaredMethod("setPreferencesHandler", preferencesHandler).invoke(appInstance, proxy);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        logger.debug("OSX handler: {0} - {1}" + method.getName() + " arr to string " + Arrays.toString(args));
        String methodName = method.getName();
        if ("openFiles".equalsIgnoreCase(methodName)) {
            logger.info("Handle openFiles");
            if (args[0] != null) {
                try {
                    Object oFiles = args[0].getClass().getMethod("getFiles", new Class[0]).invoke(args[0], new Object[0]);
                    if (oFiles instanceof List) {
                        AliView.doMacOpenFiles((List)oFiles);
                    }
                }
                catch (Exception ex) {
                    logger.warn("Failed to access open files event: " + ex);
                }
            }
        } else if ("handleQuitRequestWith".equalsIgnoreCase(methodName)) {
            logger.info("Handle handleQuitRequestWith");
            boolean isNotInterruptedByUser = AliView.doMacQuit();
            if (args[1] != null) {
                try {
                    args[1].getClass().getDeclaredMethod(isNotInterruptedByUser ? "performQuit" : "cancelQuit", new Class[0]).invoke(args[1], new Object[0]);
                }
                catch (IllegalAccessException e) {
                    logger.debug(e);
                    Class.forName("java.awt.desktop.QuitResponse").getMethod(isNotInterruptedByUser ? "performQuit" : "cancelQuit", new Class[0]).invoke(args[1], new Object[0]);
                }
            }
        } else if ("handleAbout".equalsIgnoreCase(methodName)) {
            logger.info("Handle handleAbout");
            AliView.doMacAbout();
        } else if ("handlePreferences".equalsIgnoreCase(methodName)) {
            logger.info("Handle handlePreferences");
            AliView.doMacPreferences();
        } else {
            logger.warn("OSX unsupported method: " + method.getName());
        }
        return null;
    }
}

