/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import utils.nexus.CharSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharSets
implements Iterable<CharSet> {
    ArrayList<CharSet> backend = new ArrayList();

    public CharSets() {
    }

    public CharSets(CharSets template) {
        this();
        for (CharSet aCharset : template) {
            this.backend.add(aCharset.getCopy());
        }
    }

    @Override
    public Iterator<CharSet> iterator() {
        return this.backend.iterator();
    }

    public int size() {
        return this.backend.size();
    }

    public CharSets getCopy() {
        return new CharSets(this);
    }

    public void add(CharSet charSet) {
        this.backend.add(charSet);
        Collections.sort(this.backend);
    }

    public int getMaxOverlapCount() {
        int maxOverlapCount = 0;
        for (CharSet aSet : this.backend) {
            int overlapCount = 0;
            for (CharSet innerSet : this.backend) {
                if (innerSet == aSet || !innerSet.intersects(aSet)) continue;
                ++overlapCount;
            }
            maxOverlapCount = Math.max(maxOverlapCount, overlapCount);
        }
        return maxOverlapCount;
    }

    public void deletePosition(int n) {
        for (CharSet charset : this.backend) {
            charset.deletePosition(n);
        }
        Collections.sort(this.backend);
    }

    public void insertPosition(int n) {
        for (CharSet charset : this.backend) {
            charset.insertPosition(n);
        }
        Collections.sort(this.backend);
    }

    public ArrayList<CharSet> getIntersected(Rectangle selection) {
        ArrayList<CharSet> intersects = new ArrayList<CharSet>();
        if (selection == null) {
            return intersects;
        }
        for (CharSet aSet : this.backend) {
            if (!aSet.intersects((int)selection.getMinX(), (int)selection.getMaxX())) continue;
            intersects.add(aSet);
        }
        return intersects;
    }

    public void debug() {
        for (CharSet aSet : this.backend) {
            aSet.debug();
        }
    }
}

