/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import java.awt.Rectangle;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.math.IntRange;
import org.apache.log4j.Logger;
import utils.RangeUtils;
import utils.nexus.CodonPos;
import utils.nexus.CodonRange;
import utils.nexus.CodonRanges;
import utils.nexus.Ranges;
import utils.nexus.TranslatedAminoAcidPositions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodonPositions {
    private static final Logger logger = Logger.getLogger(CodonPositions.class);
    private CodonRanges codonRanges;
    private int readingFrame;
    private TranslatedAminoAcidPositions translatedAminoAcidPos;

    public CodonPositions() {
        this(new CodonRanges(), 1);
    }

    public int size() {
        return this.codonRanges.size();
    }

    private CodonPositions(CodonRanges positionsArray, int readingFrame) {
        this.setCodonRandes(positionsArray);
        this.readingFrame = readingFrame;
    }

    public boolean isNonCoding(int pos) {
        return this.codonRanges.getPosVal(pos) == 0;
    }

    public boolean isCoding(int pos) {
        return this.codonRanges.getPosVal(pos) != 0;
    }

    private TranslatedAminoAcidPositions getTranslatedAminoAcidPositions() {
        if (this.translatedAminoAcidPos == null) {
            this.translatedAminoAcidPos = new TranslatedAminoAcidPositions(this.codonRanges, this.readingFrame);
        }
        return this.translatedAminoAcidPos;
    }

    public int getAminoAcidPosFromNucleotidePos(int pos) {
        TranslatedAminoAcidPositions aaPositions = this.getTranslatedAminoAcidPositions();
        return this.getTranslatedAminoAcidPositions().getAAPosAtNucleotidePos(pos);
    }

    public CodonPos getCodonAtNucleotidePos(int pos) {
        return this.getTranslatedAminoAcidPositions().getCodonAtNucleotidePos(pos);
    }

    public CodonPos getCodonInTranslatedPos(int pos) {
        return this.getTranslatedAminoAcidPositions().getCodonAtTranslatedPos(pos);
    }

    public boolean isFullCodonStartingAt(int x) {
        boolean isFullCodon = false;
        if (this.getReadingFrame() == 1 && this.getCodonRanges().getPosVal(x) == 1 && this.getCodonRanges().getPosVal(x + 1) == 2 && this.getCodonRanges().getPosVal(x + 2) == 3) {
            isFullCodon = true;
        }
        if (this.getReadingFrame() == 2 && this.getCodonRanges().getPosVal(x) == 2 && this.getCodonRanges().getPosVal(x + 1) == 3 && this.getCodonRanges().getPosVal(x + 2) == 1) {
            isFullCodon = true;
        }
        if (this.getReadingFrame() == 3 && this.getCodonRanges().getPosVal(x) == 3 && this.getCodonRanges().getPosVal(x + 1) == 1 && this.getCodonRanges().getPosVal(x + 2) == 2) {
            isFullCodon = true;
        }
        return isFullCodon;
    }

    public boolean isPartOfFullCodon(int x) {
        if (this.isFullCodonStartingAt(x)) {
            return true;
        }
        if (this.isFullCodonStartingAt(x - 1)) {
            return true;
        }
        return this.isFullCodonStartingAt(x - 2);
    }

    public ArrayList<IntRange> getAllNonCodingPositionsAsRanges(int wanted, int startPos, int endPos) {
        ArrayList<IntRange> allRanges = new ArrayList<IntRange>();
        int lastPos = -1;
        int firstPos = -1;
        logger.info("endpos" + endPos);
        for (int n = startPos; n < endPos; ++n) {
            if (this.getCodonRanges().getPosVal(n) == wanted) {
                if (firstPos == -1) {
                    firstPos = n;
                }
                lastPos = n;
                continue;
            }
            if (firstPos != -1) {
                IntRange range = new IntRange(firstPos, lastPos);
                allRanges.add(range);
            }
            firstPos = -1;
            lastPos = -1;
        }
        RangeUtils.sortIntRangeList(allRanges);
        return allRanges;
    }

    public ArrayList<IntRange> getAllCodingPositionsAsIntRanges(int wanted, int startPos, int endPos) {
        ArrayList<IntRange> allRanges = new ArrayList<IntRange>();
        int lastPos = -1;
        int firstPos = -1;
        for (int offset = 0; offset <= 2; ++offset) {
            for (int n = startPos + offset; n < endPos; n += 3) {
                if (this.getCodonRanges().getPosVal(n) == wanted) {
                    if (firstPos == -1) {
                        firstPos = n;
                    }
                    lastPos = n;
                    continue;
                }
                if (firstPos != -1) {
                    IntRange range = new IntRange(firstPos, lastPos);
                    allRanges.add(range);
                }
                firstPos = -1;
                lastPos = -1;
            }
            if (firstPos != -1) {
                IntRange range = new IntRange(firstPos, lastPos);
                allRanges.add(range);
            }
            firstPos = -1;
            lastPos = -1;
        }
        RangeUtils.sortIntRangeList(allRanges);
        return allRanges;
    }

    public void setReadingFrame(int readingFrame) {
        this.readingFrame = readingFrame;
        this.positionsUpdated();
    }

    public int getReadingFrame() {
        return this.readingFrame;
    }

    public ArrayList<Integer> getAllPositions(int wantedCodonPosInteger, int startPos, int endPosInclusive) {
        ArrayList<Integer> allPos = new ArrayList<Integer>();
        for (int n = startPos; n <= endPosInclusive; ++n) {
            if (this.getCodonRanges().getPosVal(n) != wantedCodonPosInteger) continue;
            allPos.add(new Integer(n));
        }
        return allPos;
    }

    public void addRange(CodonRange range) {
        this.codonRanges.addRange(range);
    }

    public void addRange(int start, int end, int firstVal) {
        this.codonRanges.addRange(new CodonRange(start, end, firstVal));
    }

    public void positionsUpdated() {
        this.translatedAminoAcidPos = null;
    }

    public void reverse(int length) {
        this.codonRanges.reverse(length);
        this.positionsUpdated();
    }

    public CodonPositions getCopy() {
        return new CodonPositions(this.codonRanges.getCopy(), this.readingFrame);
    }

    public CodonRanges getCodonRanges() {
        return this.codonRanges;
    }

    public void setCodonRandes(CodonRanges codonRanges) {
        this.codonRanges = codonRanges;
        this.positionsUpdated();
    }

    public int getPosAt(int x) {
        return this.codonRanges.getPosVal(x);
    }

    public void deletePosition(int n) {
        this.codonRanges.removePosition(n);
        this.positionsUpdated();
    }

    public void insertPosition(int n) {
        this.codonRanges.insert(n);
        this.positionsUpdated();
    }

    public boolean isAnythingButDefault() {
        return this.codonRanges.isAnythingButDefault();
    }

    public int[] translatePositions(int[] selection) {
        if (selection == null) {
            return null;
        }
        int[] translated = new int[selection.length];
        for (int n = 0; n < selection.length; ++n) {
            translated[n] = this.getAminoAcidPosFromNucleotidePos(selection[n]);
        }
        return translated;
    }

    public int[] reTranslatePositions(int[] selection) {
        if (selection == null) {
            return null;
        }
        ArrayList<Integer> reTranslated = new ArrayList<Integer>(selection.length * 3);
        for (int n = 0; n < selection.length; ++n) {
            CodonPos codon = this.getCodonInTranslatedPos(selection[n]);
            for (int i = codon.startPos; i <= codon.endPos; ++i) {
                reTranslated.add(new Integer(i));
            }
        }
        return ArrayUtils.toPrimitive(reTranslated.toArray(new Integer[0]));
    }

    public Rectangle reTranslatePositions(Rectangle bounds) {
        CodonPos codonX1 = this.getCodonInTranslatedPos(bounds.x);
        CodonPos codonX2 = this.getCodonInTranslatedPos((int)bounds.getMaxX());
        CodonPos codonY1 = this.getCodonInTranslatedPos(bounds.y);
        CodonPos codonY2 = this.getCodonInTranslatedPos((int)bounds.getMaxY());
        int width = codonX2.endPos - codonX1.startPos;
        int height = codonY2.endPos - codonY2.startPos;
        Rectangle trans = new Rectangle(codonX1.startPos, codonY1.startPos, width, height);
        return trans;
    }

    public void addRanges(Ranges allRanges) {
        this.codonRanges.setBackend(allRanges);
        this.positionsUpdated();
    }
}

