/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import org.apache.log4j.Logger;
import utils.nexus.CodonRange;
import utils.nexus.Range;
import utils.nexus.Ranges;

public class CodonRanges {
    private static final Logger logger = Logger.getLogger(CodonRanges.class);
    private Ranges backend = new Ranges();

    public CodonRanges() {
        logger.info("new");
        this.backend.addRange(CodonRange.newDefaultRange());
    }

    private CodonRanges(Ranges ranges) {
        this.backend = ranges;
    }

    public int getPosVal(int pos) {
        CodonRange range = (CodonRange)this.backend.getRange(pos);
        if (range != null) {
            return range.getPosVal(pos);
        }
        return 0;
    }

    public CodonRanges getCopy() {
        Ranges copy = new Ranges();
        for (Range range : this.backend) {
            CodonRange codonRange = (CodonRange)range;
            copy.addRange(codonRange.getCopy());
        }
        return new CodonRanges(copy);
    }

    public void addRange(CodonRange range) {
        logger.info("addRange");
        this.backend.addRange(range);
    }

    private boolean isBackendAnythingBut123() {
        return this.backend.size() != 1;
    }

    public boolean isAnythingButDefault() {
        return this.backend.size() != 1;
    }

    public void reverse(int length) {
        this.backend.reverse(length);
    }

    public void removePosition(int n) {
        this.backend.deletePosition(n);
    }

    public void insert(int n) {
        this.backend.insertPosition(n);
    }

    public void setBackend(Ranges allRanges) {
        this.backend = allRanges;
    }

    public int nucPosFromAAPos(int codonPos, int readingFrame) {
        int codonOffset = 0;
        int nucPos = -1;
        for (Range range : this.backend) {
            CodonRange codonRange = (CodonRange)range;
            if (codonRange.containsCodonPos(codonPos, codonOffset, readingFrame)) {
                nucPos = codonRange.getPosAtCodonPos(codonPos - codonOffset, readingFrame);
                break;
            }
            codonOffset += codonRange.countAllCodons(readingFrame);
        }
        return nucPos;
    }

    public int aaPosFromNucPos(int pos, int readingFrame) {
        int aaPosCount = 0;
        for (Range range : this.backend) {
            CodonRange codonRange = (CodonRange)range;
            if (range.contains(pos)) {
                aaPosCount += codonRange.countCodonsUntil(pos, readingFrame);
                break;
            }
            aaPosCount += codonRange.countAllCodons(readingFrame);
        }
        return aaPosCount - 1;
    }

    public int size() {
        return this.backend.size();
    }
}

