/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import java.util.ArrayList;
import org.apache.commons.lang.math.IntRange;
import org.apache.log4j.Logger;
import utils.nexus.NexusRange;

public class NexusParser {
    private static final Logger logger = Logger.getLogger(NexusParser.class);
    private String input;
    private ArrayList<String> tokens;
    private int currentPos = 0;

    public NexusParser(String input) {
        this.input = input;
    }

    public void split(String regex, boolean discardEmptyTokens) {
        String[] splitted = this.input.split(regex);
        this.tokens = new ArrayList();
        for (String s : splitted) {
            if (s.equals("") && discardEmptyTokens) continue;
            this.tokens.add(s);
        }
    }

    public int countTokens() {
        if (this.tokens != null) {
            return this.tokens.size();
        }
        return 0;
    }

    public boolean hasMoreTokens() {
        return this.currentPos + 1 < this.countTokens();
    }

    public void next() {
        ++this.currentPos;
    }

    public boolean isNextTokensRange() {
        return this.isTokenInteger(this.currentPos) && this.matchesToken(this.currentPos + 1, "\\-") && this.isTokenInteger(this.currentPos + 2);
    }

    private boolean matchesToken(int pos, String matchString) {
        String token = this.getTokenAt(pos);
        if (token == null) {
            return false;
        }
        return token.matches(matchString);
    }

    private boolean isTokenInteger(int pos) {
        return this.matchesToken(pos, "-?\\d+(\\.\\d+)?(\\\\\\d+)?");
    }

    public boolean isNextTokenNumeric() {
        return this.isTokenInteger(this.currentPos);
    }

    private String getTokenAt(int pos) {
        if (pos < this.countTokens()) {
            return this.tokens.get(pos);
        }
        return null;
    }

    public boolean isNextTokensIntRange() {
        return this.isNextTokensRange();
    }

    public NexusRange getNexusRange(int positionVal) {
        String firstVal = this.getTokenAt(this.currentPos);
        String secondVal = this.getTokenAt(this.currentPos + 2);
        String[] splitted = secondVal.split("\\\\");
        secondVal = splitted[0];
        String steps = "1";
        if (splitted.length > 1) {
            steps = splitted[1];
        }
        NexusRange range = new NexusRange(Integer.parseInt(firstVal), Integer.parseInt(secondVal), Integer.parseInt(steps), positionVal);
        this.currentPos += 3;
        return range;
    }

    public IntRange getIntegerAsRange() {
        String firstVal = this.getTokenAt(this.currentPos);
        IntRange range = new IntRange(Integer.parseInt(firstVal), Integer.parseInt(firstVal));
        ++this.currentPos;
        return range;
    }

    public String getToken() {
        return this.getTokenAt(this.currentPos);
    }

    public void debug() {
        for (String string : this.tokens) {
        }
    }

    public String getLine() {
        return null;
    }
}

