/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.IntRange;
import org.apache.log4j.Logger;
import utils.RangeUtils;
import utils.nexus.CharSet;
import utils.nexus.CharSets;
import utils.nexus.CodonPositions;
import utils.nexus.Excludes;
import utils.nexus.NexusAlignmentImportException;
import utils.nexus.NexusParser;
import utils.nexus.NexusRange;
import utils.nexus.NexusRangesTranslator;
import utils.nexus.Range;
import utils.nexus.Ranges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusUtilities {
    private static final Logger logger = Logger.getLogger(NexusUtilities.class);
    private static final String LF = System.getProperty("line.separator");

    public static void main(String[] args) {
        try {
            new NexusUtilities();
            NexusUtilities.createCharsetsFromNexusFile(new File("/home/anders/projekt/ormbunkar/analys/seqconcat_test/seqconcat_test.nexus"), 10000);
        }
        catch (NexusAlignmentImportException e) {
            e.printStackTrace();
        }
    }

    public static final boolean updateExcludesFromFile(File alignmentFile, Excludes excludes) throws NexusAlignmentImportException {
        logger.info("look for nexus EXSET block in file " + alignmentFile.toString());
        try {
            String assumptionsBlock = NexusUtilities.extractBlockFromFile(alignmentFile, "BEGIN ASSUMPTIONS;", "END");
            if (assumptionsBlock == null || assumptionsBlock.length() == 0) {
                return false;
            }
            logger.info("exsetBlock" + assumptionsBlock);
            String exsetBlock = StringUtils.substringBetween(assumptionsBlock, "EXSET", ";");
            if (exsetBlock == null) {
                return false;
            }
            logger.info("Found block");
            String excludeString = StringUtils.substringAfter(exsetBlock, "=");
            logger.info("ecludestring" + excludeString);
            if (excludeString == null || excludeString.length() == 0) {
                return true;
            }
            ArrayList<NexusRange> allRanges = NexusUtilities.parseNexusRanges(excludeString, 0);
            for (NexusRange range : allRanges) {
                excludes.addNexusRange(range);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NexusAlignmentImportException("Could not parse NEXUS EXSET Block");
        }
        return true;
    }

    public static final boolean updateCodonPositionsFromNexusFile(File alignmentFile, CodonPositions codonPositions) throws NexusAlignmentImportException {
        logger.info("look for nexus BEGIN CODONS; block in file " + alignmentFile.toString());
        try {
            Iterable<Range> allRanges;
            String pos3;
            String pos2;
            String pos1;
            String questionmarkPos;
            String codonsBlock = NexusUtilities.extractBlockFromFile(alignmentFile, "BEGIN CODONS;", "END;");
            if (codonsBlock == null || codonsBlock.length() == 0) {
                return false;
            }
            String codonPositionsBlock = StringUtils.substringBetween(codonsBlock, "CODONPOSSET", ";");
            if (codonPositionsBlock == null || codonPositionsBlock.length() == 0) {
                return false;
            }
            codonPositionsBlock = codonPositionsBlock + ",";
            logger.info("Found block");
            Scanner lineTokenizer = new Scanner(codonPositionsBlock).useDelimiter(",");
            logger.info("search" + lineTokenizer.findWithinHorizon("\\?:", codonPositionsBlock.length()));
            NexusRangesTranslator nexusRangesTranslator = new NexusRangesTranslator();
            String nPos = StringUtils.substringBetween(codonPositionsBlock, "N:", ",");
            if (nPos != null) {
                ArrayList<NexusRange> allRanges2 = NexusUtilities.parseNexusRanges(nPos, 0);
                nexusRangesTranslator.addNexusRanges(allRanges2);
            }
            if ((questionmarkPos = StringUtils.substringBetween(codonPositionsBlock, "?:", ",")) != null) {
                ArrayList<NexusRange> allRanges3 = NexusUtilities.parseNexusRanges(questionmarkPos, 0);
                nexusRangesTranslator.addNexusRanges(allRanges3);
            }
            if ((pos1 = StringUtils.substringBetween(codonPositionsBlock, "1:", ",")) != null) {
                ArrayList<NexusRange> allRanges4 = NexusUtilities.parseNexusRanges(pos1, 1);
                nexusRangesTranslator.addNexusRanges(allRanges4);
            }
            if ((pos2 = StringUtils.substringBetween(codonPositionsBlock, "2:", ",")) != null) {
                ArrayList<NexusRange> allRanges5 = NexusUtilities.parseNexusRanges(pos2, 2);
                nexusRangesTranslator.addNexusRanges(allRanges5);
            }
            if ((pos3 = StringUtils.substringBetween(codonPositionsBlock, "3:", ",")) != null) {
                allRanges = NexusUtilities.parseNexusRanges(pos3, 3);
                nexusRangesTranslator.addNexusRanges((ArrayList<NexusRange>)allRanges);
            }
            allRanges = nexusRangesTranslator.convertToCodonRanges();
            codonPositions.addRanges((Ranges)allRanges);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NexusAlignmentImportException("Could not parse NEXUS CODONS Block");
        }
        return true;
    }

    private static String getNexusRangesAsBlock(List<NexusRange> ranges) {
        String rangeBlock = "";
        for (NexusRange range : ranges) {
            if (range.getMinimumInt() == range.getMaximumInt()) {
                rangeBlock = rangeBlock + " " + range.getMinimumInt();
                continue;
            }
            rangeBlock = rangeBlock + " " + range.getMinimumInt() + "-" + range.getMaximumInt();
            if (range.getSteps() == 1) continue;
            rangeBlock = rangeBlock + "\\" + range.getSteps();
        }
        return rangeBlock;
    }

    public static String getCharsetsBlockWithoutNexus(CharSets charsets) {
        if (charsets == null) {
            return "";
        }
        StringBuffer charsetBlock = new StringBuffer();
        for (CharSet aSet : charsets) {
            charsetBlock.append("charset " + aSet.getName() + "=" + NexusUtilities.getNexusRangesAsBlock(aSet.getAsContinousNexusRanges()) + ";" + LF);
        }
        return charsetBlock.toString();
    }

    public static String getCharsetsBlockAsNexus(CharSets charsets) {
        if (charsets == null) {
            return "";
        }
        StringBuffer charsetBlock = new StringBuffer("BEGIN SETS;" + LF);
        charsetBlock.append(NexusUtilities.getCharsetsBlockWithoutNexus(charsets));
        charsetBlock.append("END;");
        return charsetBlock.toString();
    }

    public static final CharSets createCharsetsFromNexusFile(File alignmentFile, int alignmentWidth) throws NexusAlignmentImportException {
        logger.info("look for nexus BEGIN SETS; block in file " + alignmentFile.toString());
        CharSets allSets = new CharSets();
        try {
            String setsBlock = NexusUtilities.extractBlockFromFile(alignmentFile, "BEGIN SETS;", "END;");
            if (setsBlock != null && setsBlock.length() > 0) {
                allSets = NexusUtilities.createCharsetsFromNexusCharsetBlock(setsBlock);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NexusAlignmentImportException("Could not parse NEXUS CHARSET Block");
        }
        return allSets;
    }

    public static CharSets createCharsetsFromNexusCharsetBlock(String setsBlock) throws Exception {
        String[] tokens;
        CharSets allSets = new CharSets();
        setsBlock = setsBlock.toUpperCase();
        for (String token : tokens = setsBlock.split(";")) {
            try {
                ArrayList<NexusRange> allRanges;
                token = token.trim();
                if (token.length() <= 0) continue;
                String[] parts = token.split("=");
                String name = parts[0].replace("CHARSET", "");
                name = name.trim();
                String ranges = parts[1].trim();
                logger.info("ranges" + ranges);
                CharSet charSet = new CharSet(name);
                try {
                    allRanges = NexusUtilities.parseNexusRanges(ranges, 0);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage() + LF + "in line:" + LF + token);
                }
                boolean areAllContinous = true;
                for (NexusRange range : allRanges) {
                    if (range.steps == 1) continue;
                    areAllContinous = false;
                }
                charSet.addNexusRanges(allRanges);
                allSets.add(charSet);
            }
            catch (Exception e) {
                throw new Exception(token);
            }
        }
        return allSets;
    }

    public static ArrayList<NexusRange> parseNexusRanges(String input, int rangePositionVal) throws Exception {
        ArrayList<NexusRange> allRanges = new ArrayList<NexusRange>();
        input = input.replaceAll("-", " - ");
        NexusParser parser = new NexusParser(input);
        parser.split(" ", true);
        logger.info("input:" + input);
        logger.info(parser.countTokens());
        parser.debug();
        while (parser.hasMoreTokens()) {
            if (parser.isNextTokensIntRange()) {
                logger.info("TOKENiSiNTRANGE");
                allRanges.add(parser.getNexusRange(rangePositionVal));
                continue;
            }
            if (parser.isNextTokenNumeric()) {
                logger.info("tokenIsNumeric");
                parser.getIntegerAsRange();
                continue;
            }
            parser.next();
            throw new Exception("Could not parse text: " + parser.getToken());
        }
        for (NexusRange nexusRange : allRanges) {
        }
        return allRanges;
    }

    public static final String getExcludesAsNexusBlock(Excludes excludes) {
        ArrayList<NexusRange> allRanges = excludes.getAsContinousNexusRanges();
        String exsetBlock = "BEGIN ASSUMPTIONS;" + LF;
        exsetBlock = exsetBlock + "EXSET * UNTITLED  = ";
        exsetBlock = exsetBlock + NexusUtilities.getNexusRangesAsBlock(allRanges);
        exsetBlock = exsetBlock + ";";
        exsetBlock = exsetBlock + LF;
        exsetBlock = exsetBlock + "END;";
        return exsetBlock;
    }

    public static final String getPartialCodonPosAsNexusBlock(CodonPositions codonPositions, int startPos, int endPos) {
        String nexusBlock = "BEGIN CODONS;" + LF;
        nexusBlock = nexusBlock + "CODONPOSSET * CodonPositions =" + LF;
        String posN = " N:";
        String pos1 = " 1:";
        String pos2 = " 2:";
        String pos3 = " 3:";
        ArrayList<IntRange> allPos = codonPositions.getAllNonCodingPositionsAsRanges(0, startPos, endPos);
        RangeUtils.sortIntRangeList(allPos);
        for (IntRange range : allPos) {
            posN = posN + " " + (range.getMinimumInteger() + 1) + "-" + (range.getMaximumInteger() + 1) + "";
        }
        allPos = codonPositions.getAllCodingPositionsAsIntRanges(1, startPos, endPos);
        RangeUtils.sortIntRangeList(allPos);
        for (IntRange range : allPos) {
            pos1 = pos1 + " " + (range.getMinimumInteger() + 1) + "-" + (range.getMaximumInteger() + 1) + "\\3";
        }
        allPos = codonPositions.getAllCodingPositionsAsIntRanges(2, startPos, endPos);
        RangeUtils.sortIntRangeList(allPos);
        for (IntRange range : allPos) {
            pos2 = pos2 + " " + (range.getMinimumInteger() + 1) + "-" + (range.getMaximumInteger() + 1) + "\\3";
        }
        allPos = codonPositions.getAllCodingPositionsAsIntRanges(3, startPos, endPos);
        RangeUtils.sortIntRangeList(allPos);
        for (IntRange range : allPos) {
            pos3 = pos3 + " " + (range.getMinimumInteger() + 1) + "-" + (range.getMaximumInteger() + 1) + "\\3";
        }
        nexusBlock = nexusBlock + posN + "," + LF;
        nexusBlock = nexusBlock + pos1 + "," + LF;
        nexusBlock = nexusBlock + pos2 + "," + LF;
        nexusBlock = nexusBlock + pos3 + ";" + LF;
        nexusBlock = nexusBlock + "CODESET  * UNTITLED = Universal: all ;" + LF;
        nexusBlock = nexusBlock + "END;";
        return nexusBlock;
    }

    public static final String getPartialCodonPosAsCharsetNexusBlock(String charsetPrefix, CodonPositions codonPositions, int startPos, int endPos) {
        String nexusBlock = "";
        String posN = "charset " + charsetPrefix + "_N= ";
        String pos1 = "charset " + charsetPrefix + "_1= ";
        String pos2 = "charset " + charsetPrefix + "_2= ";
        String pos3 = "charset " + charsetPrefix + "_3= ";
        ArrayList<IntRange> allPos = codonPositions.getAllNonCodingPositionsAsRanges(0, startPos, endPos);
        RangeUtils.sortIntRangeList(allPos);
        for (IntRange range : allPos) {
            posN = posN + " " + (range.getMinimumInteger() + 1) + "-" + (range.getMaximumInteger() + 1) + "";
        }
        allPos = codonPositions.getAllCodingPositionsAsIntRanges(1, startPos, endPos);
        RangeUtils.sortIntRangeList(allPos);
        for (IntRange range : allPos) {
            pos1 = pos1 + " " + (range.getMinimumInteger() + 1) + "-" + (range.getMaximumInteger() + 1) + "\\3";
        }
        allPos = codonPositions.getAllCodingPositionsAsIntRanges(2, startPos, endPos);
        RangeUtils.sortIntRangeList(allPos);
        for (IntRange range : allPos) {
            pos2 = pos2 + " " + (range.getMinimumInteger() + 1) + "-" + (range.getMaximumInteger() + 1) + "\\3";
        }
        allPos = codonPositions.getAllCodingPositionsAsIntRanges(3, startPos, endPos);
        RangeUtils.sortIntRangeList(allPos);
        for (IntRange range : allPos) {
            pos3 = pos3 + " " + (range.getMinimumInteger() + 1) + "-" + (range.getMaximumInteger() + 1) + "\\3";
        }
        nexusBlock = nexusBlock + posN + "," + LF;
        nexusBlock = nexusBlock + pos1 + "," + LF;
        nexusBlock = nexusBlock + pos2 + "," + LF;
        nexusBlock = nexusBlock + pos3 + ";" + LF;
        return nexusBlock;
    }

    public static final String getCodonPosAsNexusBlock(CodonPositions codonPositions, int startPos, int endPosInclusive) {
        return NexusUtilities.getPartialCodonPosAsNexusBlock(codonPositions, startPos, endPosInclusive);
    }

    public static String replaceProblematicChars(String text) {
        text = text.replaceAll("[^A-Za-z0-9]", "_");
        return text;
    }

    private static String getPersonalNexusBlock(int seqLen) {
        StringBuilder block = new StringBuilder();
        block.append("BEGIN MRBAYES;" + LF);
        block.append("charset aligned-WoodsiapgiC-mafft.fasta.nexus = 1-" + seqLen + ";" + LF);
        block.append("Partition ALLDNA = 1:aligned-WoodsiapgiC-mafft.fasta.nexus;" + LF);
        block.append("Set partition = ALLDNA;" + LF);
        block.append("[GTRG]" + LF);
        block.append("[" + LF);
        block.append("Lset applyto=(1) nst=6 rates=gamma;" + LF);
        block.append("Prset applyto=(1) revmatpr=Dirichlet(1.0,1.0,1.0,1.0,1.0,1.0) statefreqpr=Dirichlet(1.0,1.0,1.0,1.0) shapepr=Uniform(0.1,50.0);" + LF);
        block.append("]" + LF);
        block.append("[GTRIG]Lset applyto=(1) nst=6 rates=invgamma;" + LF);
        block.append("Prset applyto=(1) revmatpr=Dirichlet(1.0,1.0,1.0,1.0,1.0,1.0) statefreqpr=Dirichlet(1.0,1.0,1.0,1.0) shapepr=Uniform(0.1,50.0) pinvarpr=Uniform(0.0,1.0);" + LF);
        block.append("[SYMG]" + LF);
        block.append("[" + LF);
        block.append("Lset applyto=(1) nst=6 rates=gamma;" + LF);
        block.append("Prset applyto=(1) revmatpr=Dirichlet(1.0,1.0,1.0,1.0,1.0,1.0) statefreqpr=Fixed(Equal);" + LF);
        block.append("]" + LF);
        block.append("mcmcp nruns=1 ngen=1000000 printfreq=1000 samplefreq=1000 nchains=1 diagnfreq=10000 burninfrac=0.25 stoprule=no stopval=0.002 temp=0.2 checkpoint=yes checkfreq=500000;" + LF);
        block.append("mcmc;" + LF);
        block.append("sumt burnin=0.7 nruns=1;" + LF);
        block.append("END;" + LF);
        return block.toString();
    }

    public static boolean isNexusFile(File alignmentFile) {
        boolean isNexusFile = false;
        try {
            BufferedReader r;
            String firstLine;
            if (alignmentFile != null && alignmentFile.exists() && (firstLine = (r = new BufferedReader(new FileReader(alignmentFile))).readLine()) != null & firstLine.length() > 0 & firstLine.length() < 10 && firstLine.toLowerCase().indexOf("nexus") > 0) {
                isNexusFile = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isNexusFile;
    }

    public static String extractBlockFromFile(File alignmentFile, String start, String end) {
        StringBuilder block = new StringBuilder();
        try {
            String line;
            BufferedReader r = new BufferedReader(new FileReader(alignmentFile));
            Object name = null;
            boolean nLine = false;
            boolean startFound = false;
            boolean endFound = false;
            while ((line = r.readLine()) != null) {
                int startPos;
                if (StringUtils.containsIgnoreCase(line, start)) {
                    startFound = true;
                    startPos = line.toUpperCase().indexOf(start.toUpperCase());
                    line = line.substring(startPos + start.length());
                }
                if (startFound && StringUtils.containsIgnoreCase(line, end)) {
                    endFound = true;
                    startPos = line.toUpperCase().indexOf(end.toUpperCase());
                    line = line.substring(0, startPos);
                }
                if (startFound) {
                    block.append(line);
                    block.append(LF);
                }
                if (!endFound) continue;
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return block.toString();
    }
}

