/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;
import utils.nexus.CodonRange;
import utils.nexus.NexusRange;
import utils.nexus.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ranges
implements Iterable<Range> {
    private static final Logger logger = Logger.getLogger(Ranges.class);
    protected ArrayList<Range> backend = new ArrayList();

    public Ranges() {
    }

    public Ranges(Ranges template) {
        this();
        for (Range templateRange : template) {
            this.backend.add(templateRange.getCopy());
        }
    }

    public Ranges getCopy() {
        return new Ranges(this);
    }

    public void addRange(int start, int stop) {
        int min = Math.min(start, stop);
        int max = Math.max(start, stop);
        this.addRange(new Range(min, max, 0));
    }

    public void clearRange(int start, int stop) {
        int min = Math.min(start, stop);
        int max = Math.max(start, stop);
        this.clearRange(new Range(min, max, 0));
    }

    public void addRange(Range additionalRange) {
        logger.info("add=" + additionalRange);
        ArrayList<Range> toDelete = new ArrayList<Range>();
        for (Range range : this.backend) {
            if (!additionalRange.containsRange(range)) continue;
            toDelete.add(range);
        }
        this.backend.removeAll(toDelete);
        ArrayList<Range> additionalParts = new ArrayList<Range>();
        for (Range range : this.backend) {
            if (!additionalRange.within(range)) continue;
            if (additionalRange.startVal == range.getPosVal(additionalRange.start)) {
                return;
            }
            Range restPart = range.cutOut(additionalRange);
            additionalParts.add(restPart);
        }
        this.backend.addAll(additionalParts);
        ArrayList<Range> arrayList = new ArrayList<Range>();
        for (Range range : this.backend) {
            if (!additionalRange.intersects(range)) continue;
            if (additionalRange.startVal == range.getPosVal(additionalRange.start)) {
                logger.info("merge" + additionalRange);
                additionalRange.merge(range);
                arrayList.add(range);
                continue;
            }
            range.crop(additionalRange);
        }
        this.backend.removeAll(arrayList);
        this.backend.add(additionalRange);
        this.removeZeroLengthOnes();
        Collections.sort(this.backend);
        this.debug();
    }

    public void clearRange(Range rangeToRemove) {
        logger.info("remove=" + rangeToRemove);
        ArrayList<Range> toDelete = new ArrayList<Range>();
        for (Range range : this.backend) {
            if (!rangeToRemove.containsRange(range)) continue;
            toDelete.add(range);
        }
        this.backend.removeAll(toDelete);
        ArrayList<Range> additionalParts = new ArrayList<Range>();
        for (Range range : this.backend) {
            if (!rangeToRemove.within(range)) continue;
            Range restPart = range.cutOut(rangeToRemove);
            additionalParts.add(restPart);
        }
        this.backend.addAll(additionalParts);
        ArrayList arrayList = new ArrayList();
        for (Range range : this.backend) {
            if (!rangeToRemove.intersects(range)) continue;
            range.crop(rangeToRemove);
        }
        this.removeZeroLengthOnes();
        Collections.sort(this.backend);
        this.debug();
    }

    private void removeZeroLengthOnes() {
        ArrayList<Range> zeroLengthOnes = new ArrayList<Range>();
        for (Range range : this.backend) {
            if (range.getLength() >= 0) continue;
            zeroLengthOnes.add(range);
        }
        this.backend.removeAll(zeroLengthOnes);
    }

    public void debug() {
        int count = 0;
        for (Range range : this.backend) {
            logger.info("range.toString() count =" + count + " " + range.toString());
            ++count;
        }
    }

    public Range getRange(int pos) {
        for (int n = this.backend.size() - 1; n >= 0; --n) {
            Range range = this.backend.get(n);
            if (!range.contains(pos)) continue;
            return range;
        }
        return null;
    }

    public boolean contains(int pos) {
        for (Range range : this.backend) {
            if (!range.contains(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Ranges testRanges) {
        for (Range aRange : this.backend) {
            for (Range testRange : testRanges) {
                if (!testRange.intersects(aRange)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersects(int minX, int maxX) {
        Ranges templateRanges = new Ranges();
        templateRanges.addRange(minX, maxX);
        return this.intersects(templateRanges);
    }

    public int size() {
        return this.backend.size();
    }

    @Override
    public Iterator<Range> iterator() {
        return this.backend.iterator();
    }

    public void reverse(int length) {
        if (length <= 0) {
            return;
        }
        ArrayList<CodonRange> newBackend = new ArrayList<CodonRange>();
        for (Range range : this.backend) {
            int newStart = length - 1 - range.start;
            int newEnd = length - 1 - range.end;
            int newStartVal = range.getPosVal(range.end);
            CodonRange reverseRange = new CodonRange(newStart, newEnd, newStartVal);
            newBackend.add(reverseRange);
            Collections.sort(this.backend);
            this.backend = newBackend;
        }
    }

    public int countPositions() {
        int length = 0;
        for (Range range : this.backend) {
            length += range.getLength();
        }
        return length;
    }

    public int getMaximumEndPos() {
        int max = -1;
        for (Range range : this.backend) {
            max = Math.max(max, range.end);
        }
        return max;
    }

    public int getMinimumStartPos() {
        if (this.backend == null || this.backend.size() == 0) {
            return -1;
        }
        int min = Integer.MAX_VALUE;
        for (Range range : this.backend) {
            min = Math.min(min, range.start);
        }
        return min;
    }

    public void deletePosition(int pos) {
        for (int n = this.backend.size() - 1; n >= 0; --n) {
            Range range = this.backend.get(n);
            if (range.end >= pos) {
                --range.end;
            }
            if (range.start <= pos) continue;
            --range.start;
        }
        this.removeZeroLengthOnes();
    }

    public void insertPosition(int pos) {
        for (int n = this.backend.size() - 1; n >= 0; --n) {
            Range range = this.backend.get(n);
            if (range.end >= pos) {
                ++range.end;
            }
            if (range.start <= pos) continue;
            ++range.start;
        }
    }

    public void set(int pos, boolean boolVal) {
        if (boolVal) {
            this.addRange(new Range(pos, pos, 0));
        } else {
            this.clearRange(new Range(pos, pos, 0));
        }
    }

    public boolean containsAnyPosition() {
        return this.size() > 0;
    }

    public ArrayList<NexusRange> getAsContinousNexusRanges() {
        ArrayList<NexusRange> nexusRanges = new ArrayList<NexusRange>();
        for (Range range : this.backend) {
            logger.info("range=" + range);
            NexusRange continousRange = new NexusRange(range.start + 1, range.end + 1, range.step, range.startVal);
            nexusRanges.add(continousRange);
            logger.info(continousRange.debug());
        }
        return nexusRanges;
    }
}

