/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.Chart;
import com.approximatrix.charting.EncodingException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ChartEncoder {
    public static void createJPEG(OutputStream os, Chart chart) throws EncodingException {
        boolean success = true;
        try {
            Rectangle r = chart.getBounds();
            BufferedImage img = new BufferedImage((int)r.getWidth(), (int)r.getHeight(), 1);
            Graphics2D grafx = img.createGraphics();
            chart.render(grafx);
            success = ImageIO.write((RenderedImage)img, "jpeg", os);
            os.flush();
        }
        catch (Throwable t) {
            throw new EncodingException(t.getMessage(), t);
        }
        if (!success) {
            throw new EncodingException("No ImageWriter for writing JPEGs found.");
        }
    }

    public static void createGIF(OutputStream os, Chart chart) throws EncodingException {
    }

    public static void createPNG(OutputStream os, Chart chart) throws EncodingException {
        boolean success = true;
        try {
            Rectangle r = chart.getBounds();
            BufferedImage img = new BufferedImage((int)r.getWidth(), (int)r.getHeight(), 1);
            Graphics2D grafx = img.createGraphics();
            chart.render(grafx);
            success = ImageIO.write((RenderedImage)img, "png", os);
            os.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new EncodingException(t.getMessage(), t);
        }
        if (!success) {
            throw new EncodingException("No ImageWriter for writing PNGs found.");
        }
    }

    public static void createEncodedImage(OutputStream os, Chart chart, String format) throws EncodingException {
        boolean success = true;
        try {
            Rectangle r = chart.getBounds();
            BufferedImage img = new BufferedImage((int)r.getWidth(), (int)r.getHeight(), 1);
            Graphics2D grafx = img.createGraphics();
            chart.render(grafx);
            success = ImageIO.write((RenderedImage)img, format, os);
            os.flush();
        }
        catch (Throwable t) {
            throw new EncodingException(t.getMessage(), t);
        }
        if (!success) {
            throw new EncodingException("No ImageWriter for writing " + format + " images found.");
        }
    }

    public static String[] getSupportedFormats() {
        return ImageIO.getWriterFormatNames();
    }
}

