/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem;

import com.approximatrix.charting.Axis;
import com.approximatrix.charting.coordsystem.AbstractCoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystemUtilities;
import com.approximatrix.charting.coordsystem.ticklocator.NumericXTickLocator;
import com.approximatrix.charting.coordsystem.ticklocator.NumericYTickLocator;
import com.approximatrix.charting.coordsystem.ticklocator.ObjectXTickLocator;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class BoxCoordSystem
extends AbstractCoordSystem
implements ChartDataModelListener {
    private static final int DEFAULT_MAX_ACTUAL_TICKS = 40;
    protected static final int BOTTOM_BUFFER = 5;
    protected static final int LEFT_BUFFER = 5;
    private static final float[] DOT1 = new float[]{1.0f};
    protected static boolean DRAW_OBJECT_X_AXIS_GRID = false;
    private int estimated_x_ticks = 20;
    private int estimated_y_ticks = 20;
    private int maximum_x_ticks = 40;
    private int maximum_y_ticks = 40;
    private int ticSize = 5;
    protected ChartDataModelConstraints constraints;
    protected ChartDataModelConstraints constraints2;
    protected ChartDataModel model;
    protected Stroke gridStroke = new BasicStroke(1.0f, 0, 0, 10.0f, DOT1, 0.0f);
    protected Color gridColor = Color.lightGray;

    public BoxCoordSystem(ChartDataModel cdm) {
        this.constraints = cdm.getChartDataModelConstraints(0);
        this.constraints2 = cdm.getChartDataModelConstraints(1);
        this.model = cdm;
        this.xaxis = new Axis(1, this.constraints);
        this.yaxis = new Axis(2, this.constraints);
        this.dfY = new DecimalFormat();
        this.dfX = new DecimalFormat();
        cdm.addChartDataModelListener(this);
        this.centerObjectLabelsBetweenTicks = !cdm.isColumnNumeric();
    }

    @Override
    protected int computeBottomMargin() {
        TextLayout layoutU = new TextLayout(this.getXAxisUnit(), this.getUnitFont(), new FontRenderContext(null, true, false));
        Rectangle2D ticks = new Rectangle();
        if (this.model.isColumnNumeric()) {
            ticks = new TextLayout("1.0", this.getTickFont(), new FontRenderContext(null, true, false)).getBounds();
        } else {
            int i = 0;
            while (i < this.model.getDataSetNumber()) {
                int j = 0;
                while (j < this.model.getDataSetLength(i)) {
                    Rectangle2D r = this.getTickFont().getStringBounds(this.model.getColumnValueAt(i, j).toString(), new FontRenderContext(null, true, false));
                    if (r.getBounds().height > ticks.getBounds().height) {
                        ticks = r;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return (int)layoutU.getBounds().getHeight() + (int)ticks.getHeight() + 15;
    }

    @Override
    protected int computeLeftMargin() {
        FontRenderContext lefty = new FontRenderContext(null, true, false);
        TextLayout layoutU = new TextLayout(this.getYAxisUnit(), this.getUnitFont().deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966)), lefty);
        TextLayout layoutT = new TextLayout("1.0", this.getTickFont().deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966)), lefty);
        return (int)layoutU.getBounds().getWidth() + (int)layoutT.getBounds().getWidth() + 15;
    }

    @Override
    protected int computeRightMargin() {
        return 0;
    }

    @Override
    protected int computeTopMargin() {
        return 0;
    }

    @Override
    public void paintDefault(Graphics2D g) {
        if (!this.shouldPaintAxes) {
            return;
        }
        g.setColor(Color.black);
        Rectangle crect = this.getInnerBounds();
        g.drawRect(crect.x, crect.y, crect.width, crect.height);
        g.setColor(Color.black);
        TextLayout layoutX = new TextLayout(this.getXAxisUnit(), this.getUnitFont(), new FontRenderContext(null, true, false));
        layoutX.draw(g, (float)(crect.getCenterX() - layoutX.getBounds().getWidth() / 2.0), (float)(this.getBounds().getMinY() + this.getBounds().getHeight() - 5.0));
        g.setColor(Color.black);
        TextLayout layoutY = new TextLayout(this.getYAxisUnit(), this.getUnitFont().deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966)), new FontRenderContext(null, true, false));
        layoutY.draw(g, 5.0f + (float)layoutY.getBounds().getWidth() / 2.0f, (float)crect.y + (float)(crect.getCenterY() + layoutY.getBounds().getWidth() / 2.0));
        this.drawYAxisTicks(g);
        this.drawXAxisTicks(g);
    }

    @Override
    public void chartDataChanged(ChartDataModelEvent evt) {
        this.setTransforms();
    }

    @Override
    public ChartDataModelConstraints getChartDataModelConstraints(int axis) {
        if (axis == 0) {
            return this.constraints;
        }
        if (axis == 1) {
            return this.constraints2;
        }
        return null;
    }

    @Override
    public int getMaximumXTicks() {
        return this.maximum_x_ticks;
    }

    @Override
    public int getMaximumYTicks() {
        return this.maximum_y_ticks;
    }

    @Override
    public void resetMaximumXTicks() {
        this.maximum_x_ticks = 40;
    }

    @Override
    public void resetMaximumYTicks() {
        this.maximum_y_ticks = 40;
    }

    @Override
    public void setMaximumXTicks(int value) {
        this.maximum_x_ticks = value;
    }

    @Override
    public void setMaximumYTicks(int value) {
        this.maximum_y_ticks = value;
    }

    private void drawYAxisTicks(Graphics2D g) {
        double[] ym = null;
        try {
            ym = CoordSystemUtilities.SafeMaxMin(this.constraints.getMaximumY().doubleValue(), this.constraints.getMinimumY().doubleValue());
        }
        catch (NullPointerException npe) {
            ym[0] = 0.0;
            ym[1] = 1.0;
        }
        double[] tics = new NumericYTickLocator(ym[0], ym[1], this.estimated_y_ticks, 40).getTickMarkLocationsAsPairs(0.0);
        if (tics == null) {
            return;
        }
        double[] dp = new double[tics.length];
        this.getTransform(0).transform(tics, 0, dp, 0, tics.length / 2);
        g.setColor(Color.BLACK);
        int xright = this.getInnerBounds().x + this.getInnerBounds().width;
        int xleft = this.getInnerBounds().x;
        Font yfont = this.getTickFont().deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966));
        int i = 1;
        while (i < tics.length) {
            int y = (int)Math.round(dp[i]);
            if (y <= this.getInnerBounds().y + this.getInnerBounds().height && y >= this.getInnerBounds().y) {
                g.drawLine(xright, y, xright - this.ticSize, y);
                g.drawLine(xleft, y, xleft + this.ticSize, y);
                if (this.shouldPaintGrid) {
                    this.drawSingleGridline(g, xleft + this.ticSize, y, xright - this.ticSize, y);
                }
                TextLayout label = new TextLayout(super.getYDecimalFormat().format(tics[i]), yfont, new FontRenderContext(null, true, false));
                label.draw(g, xleft - 5, y + (int)(label.getBounds().getHeight() / 2.0));
            }
            i += 2;
        }
    }

    private void drawXAxisTicks(Graphics2D g) {
        if (this.model.isColumnNumeric()) {
            this.drawNumericalXAxisTicks(g);
        } else {
            this.drawObjectXAxisTicks(g);
        }
    }

    private void drawNumericalXAxisTicks(Graphics2D g) {
        double[] xm = null;
        try {
            xm = CoordSystemUtilities.SafeMaxMin(this.constraints.getMaximumX().doubleValue(), this.constraints.getMinimumX().doubleValue());
        }
        catch (NullPointerException npe) {
            xm[0] = 0.0;
            xm[1] = 1.0;
        }
        double[] tics = new NumericXTickLocator(xm[0], xm[1], this.estimated_x_ticks, 40).getTickMarkLocationsAsPairs(0.0);
        if (tics == null) {
            return;
        }
        double[] dp = new double[tics.length];
        this.getTransform(0).transform(tics, 0, dp, 0, tics.length / 2);
        g.setColor(Color.BLACK);
        int ybottom = this.getInnerBounds().y + this.getInnerBounds().height;
        int ytop = this.getInnerBounds().y;
        int i = 0;
        while (i < tics.length) {
            int x = (int)Math.round(dp[i]);
            if (x <= this.getInnerBounds().x + this.getInnerBounds().width && x >= this.getInnerBounds().x) {
                g.drawLine(x, ytop, x, ytop + this.ticSize);
                g.drawLine(x, ybottom, x, ybottom - this.ticSize);
                if (this.shouldPaintGrid) {
                    this.drawSingleGridline(g, x, ytop + this.ticSize, x, ybottom - this.ticSize);
                }
                TextLayout label = new TextLayout(super.getXDecimalFormat().format(tics[i]), this.getTickFont(), new FontRenderContext(null, true, false));
                if (this.isCenterLabelsBetweenTicks()) {
                    x += (int)((dp[i + 2] - (double)x) / 2.0);
                }
                label.draw(g, x - (int)(label.getBounds().getWidth() / 2.0), ybottom + 5 + (int)label.getBounds().getHeight());
            }
            i += 2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawObjectXAxisTicks(Graphics2D g) {
        block12: {
            tics = null;
            try {
                tics = new ObjectXTickLocator(this.constraints.getMinimumX().intValue(), this.constraints.getMaximumX().intValue(), this.estimated_x_ticks).getTickMarkLocationsAsPairs(0);
                break block12;
            }
            catch (NullPointerException npe) {
                i = 0;
                ** while (this.model.getColumnValueAt((int)i) != null)
            }
lbl-1000:
            // 1 sources

            {
                ++i;
                continue;
            }
lbl10:
            // 1 sources

            tics = new float[i * 2];
            j = 0;
            while (j < i) {
                tics[j] = j / 2;
                tics[j + 1] = 0.0f;
                j += 2;
            }
        }
        if (tics == null) {
            return;
        }
        dp = new float[tics.length];
        this.getTransform(0).transform(tics, 0, dp, 0, tics.length / 2);
        g.setColor(Color.BLACK);
        ybottom = this.getInnerBounds().y + this.getInnerBounds().height;
        ytop = this.getInnerBounds().y;
        i = 0;
        while (i < tics.length) {
            x = Math.round(dp[i]);
            if (x <= this.getInnerBounds().x + this.getInnerBounds().width && x >= this.getInnerBounds().x) {
                g.drawLine(x, ytop, x, ytop + this.ticSize);
                g.drawLine(x, ybottom, x, ybottom - this.ticSize);
                if (BoxCoordSystem.DRAW_OBJECT_X_AXIS_GRID && this.shouldPaintGrid) {
                    this.drawSingleGridline(g, x, ytop + this.ticSize, x, ybottom - this.ticSize);
                }
                try {
                    label = new TextLayout(this.model.getColumnValueAt((int)tics[i]).toString(), this.getTickFont(), new FontRenderContext(null, true, false));
                    if (this.isCenterLabelsBetweenTicks()) {
                        x += (int)((dp[i + 2] - (float)x) / 2.0f);
                    }
                    label.draw(g, x - (int)(label.getBounds().getWidth() / 2.0), ybottom + 5 + (int)label.getBounds().getHeight());
                }
                catch (NullPointerException npe) {
                }
                catch (ArrayIndexOutOfBoundsException var8_11) {
                    // empty catch block
                }
            }
            i += 2;
        }
    }

    private void drawSingleGridline(Graphics2D g, int x1, int y1, int x2, int y2) {
        Stroke original = g.getStroke();
        Color c = g.getColor();
        g.setStroke(this.gridStroke);
        g.setColor(this.gridColor);
        g.drawLine(x1, y1, x2, y2);
        g.setStroke(original);
        g.setColor(c);
    }
}

