/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem.ticklocator;

public class ObjectTickLocator {
    private int first = 0;
    private int last = 1;
    private int maxTics = 20;
    private boolean forceAll = false;

    public ObjectTickLocator(int first, int last, int maxTics) {
        this(first, last, maxTics, false);
    }

    public ObjectTickLocator(int first, int last, int maxTics, boolean forceAll) {
        this.first = first;
        this.last = last;
        this.maxTics = maxTics;
        this.forceAll = forceAll;
        if (this.first > this.last) {
            int temp = this.last;
            this.last = this.first;
            this.first = temp;
        }
    }

    public int[] getTickMarkLocations() {
        int step = 1;
        int[] ret = null;
        do {
            ret = new int[(this.last - this.first) / step + 1];
            int i = 0;
            while (i < ret.length) {
                ret[i] = this.first + i * step;
                ++i;
            }
            step *= 2;
        } while (ret.length > this.maxTics && !this.forceAll);
        return ret;
    }
}

