/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.BufferedChart;
import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.swing.AbstractChartPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;

public class BufferedChartPanel
extends AbstractChartPanel
implements RenderChangeListener {
    private Rectangle currentRect = null;
    private Rectangle grRect = null;

    private BufferedChartPanel() {
    }

    public BufferedChartPanel(ChartDataModel model, String title) {
        this();
        this.chart = new BufferedChart(model, title);
        this.chart.addRenderChangeListener(this);
    }

    public BufferedChartPanel(ChartDataModel model, String title, int coord) {
        this();
        this.chart = new BufferedChart(model, title, coord);
        this.chart.addRenderChangeListener(this);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.currentRect != null) {
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.grRect.x, this.grRect.y, this.grRect.width - 1, this.grRect.height - 1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSize(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.currentRect = new Rectangle(e.getX(), e.getY(), 0, 0);
        this.updateSize(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSize(e);
        this.currentRect = null;
        this.repaint();
    }

    private void updateSize(MouseEvent e) {
        int width = e.getX() - this.currentRect.x;
        int height = e.getY() - this.currentRect.y;
        this.currentRect.setSize(width, height);
        if (this.currentRect.width < 0 || this.currentRect.height < 0 || this.grRect == null) {
            this.grRect = new Rectangle(Math.min(this.currentRect.x, this.currentRect.x + width), Math.min(this.currentRect.y, this.currentRect.y + height), Math.abs(width), Math.abs(height));
        } else {
            this.grRect.setSize(width, height);
        }
        this.repaint();
    }

    @Override
    public void renderUpdateRequested(RenderChangeEvent evt) {
        this.repaint();
    }

    public boolean isBuffering() {
        return ((BufferedChart)this.chart).isBuffering();
    }

    public void setBuffering(boolean value) {
        ((BufferedChart)this.chart).setBuffering(value);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        boolean buf = this.isBuffering();
        this.setBuffering(false);
        int ret_val = super.print(g, pf, page);
        this.setBuffering(buf);
        return ret_val;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }
}

