/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.event.InfoAvailableEvent;
import com.approximatrix.charting.event.InfoAvailableListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.swing.ExtendedChartPanel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public abstract class InteractiveChartPanel
extends ExtendedChartPanel
implements ActionListener {
    protected EventListenerList listener = new EventListenerList();
    private final int WAIT_FOR_TIP = 500;
    protected Timer moveTimer = null;
    protected Point mp = null;

    public InteractiveChartPanel(ChartDataModel arg0, String arg1, int arg2) {
        super(arg0, arg1, arg2);
        this.initialize();
    }

    public InteractiveChartPanel(ChartDataModel arg0, String arg1) {
        super(arg0, arg1);
        this.initialize();
    }

    private void initialize() {
        this.moveTimer = new Timer(500, this);
        this.moveTimer.setRepeats(false);
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        this.moveTimer.stop();
        if (this.getCoordSystem().getInnerBounds().contains(arg0.getPoint())) {
            this.mp = arg0.getPoint();
            this.moveTimer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.mp == null) {
            return;
        }
        Point abspt = new Point(this.getLocationOnScreen());
        abspt.translate(this.mp.x, this.mp.y);
        Point transformed = new Point();
        try {
            this.getCoordSystem().getDefaultTransform(0).createInverse().transform(this.mp, transformed);
        }
        catch (NoninvertibleTransformException nite) {
            System.err.println("Inverse graphics- to data-space transform failed");
            return;
        }
        this.fireInfoAvailable(this, transformed);
    }

    public void fireInfoAvailable(Object src, Point datapoint) {
        InfoAvailableEvent event = new InfoAvailableEvent(src, datapoint);
        Object[] ls = this.listener.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == InfoAvailableListener.class) {
                ((InfoAvailableListener)ls[i + 1]).onInformationAvailable(event);
            }
            i -= 2;
        }
    }

    public void removeInfoAvailableListener(InfoAvailableListener l) {
        this.listener.remove(InfoAvailableListener.class, l);
    }

    public void addInfoAvailableListener(InfoAvailableListener l) {
        Object[] ls = this.listener.getListenerList();
        boolean found = false;
        int i = ls.length - 1;
        while (i >= 1) {
            if (ls[i] == l) {
                found = true;
                break;
            }
            i -= 2;
        }
        if (!found) {
            this.listener.add(InfoAvailableListener.class, l);
        }
    }

    public void clearInfoAvailableListener() {
        this.listener = new EventListenerList();
    }
}

