/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class phyloxml_converter {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String FIELD_OPTION = "f";
    private static final String FIELD_CLADE_NAME = "nn";
    private static final String FIELD_TAXONOMY_CODE = "tc";
    private static final String FIELD_TAXONOMY_SCI_NAME = "sn";
    private static final String FIELD_TAXONOMY_COMM_NAME = "cn";
    private static final String FIELD_SEQUENCE_GENE_NAME = "gn";
    private static final String FIELD_SEQUENCE_SYMBOL = "sy";
    private static final String FIELD_UNIPROT_TAXONOMY_ID_SPLIT_1 = "i1";
    private static final String FIELD_UNIPROT_TAXONOMY_ID_SPLIT_2 = "i2";
    private static final String FIELD_DUMMY = "dummy";
    private static final String INTERNAL_NAMES_ARE_BOOT_SUPPPORT = "i";
    private static final String MIDPOINT_REROOT = "m";
    private static final String EXTRACT_TAXONOMY = "xt";
    private static final String EXTRACT_TAXONOMY_PF = "xp";
    private static final String ORDER_SUBTREES = "o";
    private static final String NO_TREE_LEVEL_INDENDATION = "ni";
    private static final String REPLACE_UNDER_SCORES = "ru";
    private static final String IGNORE_QUOTES = "iqs";
    private static final String CONFIDENCE_TYPE = "c";
    private static final String PRG_NAME = "phyloxml_converter";
    private static final String PRG_VERSION = "1.303";
    private static final String PRG_DATE = "170510";
    private static final String E_MAIL = "phyloxml@gmail.com";
    private static final String WWW = "sites.google.com/site/cmzmasek/home/software/forester/phyloxml-converter";

    public static void main(String[] stringArray) throws PhyloXmlDataFormatException {
        Object object;
        String string;
        String string2;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length == 0) {
            phyloxml_converter.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 3) {
            System.out.println();
            System.out.println("[phyloxml_converter] incorrect number of arguments");
            System.out.println();
            phyloxml_converter.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(NO_TREE_LEVEL_INDENDATION);
        arrayList.add(FIELD_OPTION);
        arrayList.add(MIDPOINT_REROOT);
        arrayList.add(ORDER_SUBTREES);
        arrayList.add(INTERNAL_NAMES_ARE_BOOT_SUPPPORT);
        arrayList.add(REPLACE_UNDER_SCORES);
        arrayList.add(EXTRACT_TAXONOMY);
        arrayList.add(EXTRACT_TAXONOMY_PF);
        arrayList.add(IGNORE_QUOTES);
        arrayList.add(CONFIDENCE_TYPE);
        if (commandLineArguments.getNumberOfNames() != 2) {
            System.out.println();
            System.out.println("[phyloxml_converter] incorrect number of arguments");
            System.out.println();
            phyloxml_converter.printHelp();
            System.exit(-1);
        }
        if ((string2 = commandLineArguments.validateAllowedOptionsAsString(arrayList)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(FIELD_OPTION);
        String string3 = commandLineArguments.validateMandatoryOptionsAsString(arrayList2);
        if (string3.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "missing option(s): " + string3);
        }
        if (!commandLineArguments.isOptionValueSet(FIELD_OPTION)) {
            System.out.println();
            phyloxml_converter.printHelp();
            System.exit(-1);
        }
        String string4 = commandLineArguments.getOptionValue(FIELD_OPTION);
        PhylogenyMethods.PhylogenyNodeField phylogenyNodeField = null;
        if (string4.equals(FIELD_CLADE_NAME)) {
            phylogenyNodeField = PhylogenyMethods.PhylogenyNodeField.CLADE_NAME;
        } else if (string4.equals(FIELD_TAXONOMY_CODE)) {
            phylogenyNodeField = PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE;
        } else if (string4.equals(FIELD_TAXONOMY_SCI_NAME)) {
            phylogenyNodeField = PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME;
        } else if (string4.equals(FIELD_TAXONOMY_COMM_NAME)) {
            phylogenyNodeField = PhylogenyMethods.PhylogenyNodeField.TAXONOMY_COMMON_NAME;
        } else if (string4.equals(FIELD_SEQUENCE_GENE_NAME)) {
            phylogenyNodeField = PhylogenyMethods.PhylogenyNodeField.SEQUENCE_NAME;
        } else if (string4.equals(FIELD_SEQUENCE_SYMBOL)) {
            phylogenyNodeField = PhylogenyMethods.PhylogenyNodeField.SEQUENCE_SYMBOL;
        } else if (string4.equals(FIELD_UNIPROT_TAXONOMY_ID_SPLIT_1)) {
            phylogenyNodeField = PhylogenyMethods.PhylogenyNodeField.TAXONOMY_ID_UNIPROT_1;
        } else if (string4.equals(FIELD_UNIPROT_TAXONOMY_ID_SPLIT_2)) {
            phylogenyNodeField = PhylogenyMethods.PhylogenyNodeField.TAXONOMY_ID_UNIPROT_2;
        } else if (!string4.equals(FIELD_DUMMY)) {
            ForesterUtil.fatalError(PRG_NAME, "unknown value for -\"f\" option: \"" + string4 + "\"");
        }
        boolean bl = false;
        if (commandLineArguments.isOptionSet(IGNORE_QUOTES)) {
            bl = true;
        }
        boolean bl2 = false;
        if (commandLineArguments.isOptionSet(INTERNAL_NAMES_ARE_BOOT_SUPPPORT)) {
            bl2 = true;
        }
        String string5 = "unknown";
        if (commandLineArguments.isOptionSet(CONFIDENCE_TYPE) && !ForesterUtil.isEmpty(string = commandLineArguments.getOptionValueAsCleanString(CONFIDENCE_TYPE))) {
            string5 = string;
        }
        boolean bl3 = false;
        if (commandLineArguments.isOptionSet(MIDPOINT_REROOT)) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (commandLineArguments.isOptionSet(ORDER_SUBTREES)) {
            bl4 = true;
        }
        boolean bl5 = false;
        if (commandLineArguments.isOptionSet(REPLACE_UNDER_SCORES)) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (commandLineArguments.isOptionSet(NO_TREE_LEVEL_INDENDATION)) {
            bl6 = true;
        }
        boolean bl7 = false;
        if (commandLineArguments.isOptionSet(EXTRACT_TAXONOMY)) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (commandLineArguments.isOptionSet(EXTRACT_TAXONOMY_PF)) {
            bl8 = true;
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        if (file2.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "[" + file2 + "] already exists");
        }
        if (!file.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "[" + file + "] does not exist");
        }
        Phylogeny[] phylogenyArray = null;
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            if (phylogenyParser instanceof NHXParser) {
                if (phylogenyNodeField != PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE && phylogenyNodeField != PhylogenyMethods.PhylogenyNodeField.TAXONOMY_COMMON_NAME && phylogenyNodeField != PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME) {
                    if (bl8) {
                        ((NHXParser)phylogenyParser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
                        bl5 = false;
                    } else if (bl7) {
                        ((NHXParser)phylogenyParser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED);
                        bl5 = false;
                    }
                } else {
                    ((NHXParser)phylogenyParser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                }
                ((NHXParser)phylogenyParser).setReplaceUnderscores(bl5);
                ((NHXParser)phylogenyParser).setIgnoreQuotes(bl);
            } else if (phylogenyParser instanceof NexusPhylogeniesParser) {
                ((NexusPhylogeniesParser)phylogenyParser).setReplaceUnderscores(bl5);
                ((NexusPhylogeniesParser)phylogenyParser).setIgnoreQuotes(false);
            }
            phylogenyArray = object.create(file, phylogenyParser);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read phylogeny from [" + file + "]: " + iOException.getMessage());
        }
        if (bl2) {
            for (Phylogeny object2 : phylogenyArray) {
                PhylogenyMethods.transferInternalNamesToConfidenceValues(object2, string5);
            }
        }
        if (phylogenyNodeField != null) {
            for (Phylogeny phylogeny : phylogenyArray) {
                PhylogenyMethods.transferNodeNameToField(phylogeny, phylogenyNodeField, false);
            }
        }
        if (bl3) {
            try {
                for (Phylogeny phylogeny : phylogenyArray) {
                    PhylogenyMethods.midpointRoot(phylogeny);
                }
            }
            catch (Exception exception) {
                System.out.println("");
                ForesterUtil.printWarningMessage(PRG_NAME, "midpoint rerooting failed: " + exception.getLocalizedMessage());
            }
        }
        if (bl4) {
            for (Phylogeny phylogeny : phylogenyArray) {
                PhylogenyMethods.orderAppearance(phylogeny.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY);
                phylogeny.externalNodesHaveChanged();
                phylogeny.clearHashIdToNodeMap();
                phylogeny.recalculateNumberOfExternalDescendants(true);
            }
        }
        try {
            object = new PhylogenyWriter();
            if (bl6) {
                ((PhylogenyWriter)object).setIndentPhyloxml(false);
            }
            ((PhylogenyWriter)object).toPhyloXML(phylogenyArray, 0, file2, ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + file2 + "]: " + iOException.getMessage());
        }
        System.out.println("[phyloxml_converter] wrote: [" + file2 + "]");
        System.out.println("[phyloxml_converter] OK");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("phyloxml_converter -f=<field option> [options] <infile in New Hamphshire, NHX, Nexus, ToL XML, or phyloXML format> <outfile>");
        System.out.println();
        System.out.println(" field options: ");
        System.out.println();
        System.out.println("   nn:    transfer name to node/clade name");
        System.out.println("   tc:    transfer name to taxonomy code");
        System.out.println("   sn:    transfer name to taxonomy scientific name");
        System.out.println("   cn:    transfer name to taxonomy common name");
        System.out.println("   gn:    transfer name to sequence name");
        System.out.println("   sy:    transfer name to sequence symbol");
        System.out.println("   dummy: to convert NHX formatted trees to phyloXML");
        System.out.println("   i1:    transfer/split name to taxonomy uniprot identifier");
        System.out.println("          (split at underscore if \"id_name\" pattern, e.g. \"817_SusD\")");
        System.out.println("   i2:    transfer/split name to taxonomy uniprot identifier");
        System.out.println("          (split at underscore if \"name_id\" pattern, e.g. \"SusD_817\")");
        System.out.println();
        System.out.println(" options: ");
        System.out.println(" -i       : internal names in NH or NHX tree are confidence values");
        System.out.println(" -c=<conf>: confidence type (e.g. \"bootstrap\", default is \"unknown\")");
        System.out.println(" -ru      : replace all underscores with spaces");
        System.out.println(" -m       : midpoint reroot");
        System.out.println(" -o       : order subtrees");
        System.out.println(" -xt      : extract taxonomy to taxonomy code from \"seqname_TAXON\"-style names (cannot be used with the following field options: tc, cn, sn)");
        System.out.println(" -xp      : extract taxonomy to taxonomy code from Pfam (\"seqname_TAXON/x-y\") style names only (cannot be used with the following field options: tc, cn, sn)");
        System.out.println(" -ni      : no tree level indendation in phyloXML output");
        System.out.println(" -iqs     : ignore quotes and whitespace (e.g. \"a b\" becomes ab)");
        System.out.println();
    }
}

