/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.forester.rio.RIO;
import org.forester.rio.RIOUtil;
import org.forester.sdi.SDIutil;
import org.forester.util.CommandLineArguments;
import org.forester.util.EasyWriter;
import org.forester.util.ForesterUtil;

public class rio {
    public static final String PRG_NAME = "rio";
    public static final String PRG_VERSION = "5.900";
    public static final String PRG_DATE = "170420";
    private static final String E_MAIL = "phyloxml@gmail.com";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String GT_FIRST = "f";
    private static final String GT_LAST = "l";
    private static final String REROOTING_OPT = "r";
    private static final String OUTGROUP = "o";
    private static final String USE_SDIR = "s";
    private static final String GENE_TREES_SUFFIX_OPTION = "g";
    private static final String MAPPINGS_DIR_OPTION = "m";
    private static final String MAPPINGS_SUFFIX_OPTION = "ms";
    private static final String CONSENSUS_TREES_DIR_OPTION = "co";
    private static final String CONSENSUS_TREES_SUFFIX_OPTION = "cos";
    private static final String MAPPINGS_SUFFIX_DEFAULT = ".nim";
    private static final String CONSENSUS_TREE_SUFFIX_DEFAULT = ".xml";
    private static final String ORTHOLOG_GROUPS_CUTOFF_OPTION = "c";
    private static final String GENE_TREES_SUFFIX_DEFAULT = ".mlt";
    private static final double ORTHOLOG_GROUPS_CUTOFF_DEFAULT = 0.5;

    public static void main(String[] stringArray) {
        String string;
        String string2;
        boolean bl;
        File file;
        String string3;
        boolean bl2;
        File file2;
        String string4;
        File file3;
        boolean bl3;
        ForesterUtil.printProgramInformation(PRG_NAME, "resampled inference of orthologs", PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length == 0) {
            rio.printHelp();
        }
        if (stringArray.length < 3 || stringArray.length > 11 || commandLineArguments.getNumberOfNames() < 3) {
            System.out.println();
            System.out.println("error: incorrect number of arguments");
            System.out.println();
            rio.printHelp();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GT_FIRST);
        arrayList.add(GT_LAST);
        arrayList.add(REROOTING_OPT);
        arrayList.add(OUTGROUP);
        arrayList.add(USE_SDIR);
        arrayList.add(GENE_TREES_SUFFIX_OPTION);
        arrayList.add(ORTHOLOG_GROUPS_CUTOFF_OPTION);
        arrayList.add(MAPPINGS_DIR_OPTION);
        arrayList.add(MAPPINGS_SUFFIX_OPTION);
        arrayList.add(CONSENSUS_TREES_DIR_OPTION);
        arrayList.add(CONSENSUS_TREES_SUFFIX_OPTION);
        String string5 = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string5.length() > 0) {
            ForesterUtil.fatalError("unknown option(s): " + string5);
        }
        File file4 = commandLineArguments.getFile(0);
        File file5 = null;
        File file6 = null;
        if (file4.isDirectory()) {
            if (!file4.exists()) {
                ForesterUtil.fatalError("gene trees directory \"" + file4 + "\" does not exist");
            }
            if (file4.listFiles().length < 1) {
                ForesterUtil.fatalError("gene trees directory \"" + file4 + "\" is empty");
            }
            bl3 = true;
            file5 = file4;
        } else {
            bl3 = false;
        }
        File file7 = commandLineArguments.getFile(1);
        File file8 = null;
        if (bl3) {
            file6 = commandLineArguments.getFile(2);
        } else {
            file8 = commandLineArguments.getFile(2);
        }
        if (bl3) {
            if (commandLineArguments.getNumberOfNames() < 4) {
                System.out.println();
                System.out.println("error: incorrect number of arguments");
                System.out.println();
                rio.printHelp();
            }
            if ((file3 = commandLineArguments.getFile(3)).exists()) {
                ForesterUtil.fatalError("\"" + file3 + "\" already exists");
            }
        } else if (commandLineArguments.getNumberOfNames() > 3) {
            file3 = commandLineArguments.getFile(3);
            if (file3.exists()) {
                ForesterUtil.fatalError("\"" + file3 + "\" already exists");
            }
        } else {
            file3 = null;
        }
        boolean bl4 = false;
        if (commandLineArguments.isOptionSet(USE_SDIR)) {
            if (commandLineArguments.isOptionHasAValue(USE_SDIR)) {
                ForesterUtil.fatalError("no value allowed for -s");
            }
            bl4 = true;
            if (!bl3 && file3 != null) {
                ForesterUtil.fatalError("no logfile output for SDIR algorithm");
            }
        }
        String string6 = null;
        if (commandLineArguments.isOptionSet(OUTGROUP)) {
            if (bl4) {
                ForesterUtil.fatalError("no outgroup option for SDIR algorithm");
            }
            if (bl3) {
                ForesterUtil.fatalError("no outgroup option for operating on gene trees directory");
            }
            if (!commandLineArguments.isOptionHasAValue(OUTGROUP)) {
                ForesterUtil.fatalError("no value for -o");
            }
            string6 = commandLineArguments.getOptionValueAsCleanString(OUTGROUP);
        }
        RIO.REROOTING rEROOTING = RIO.REROOTING.BY_ALGORITHM;
        if (commandLineArguments.isOptionSet(REROOTING_OPT)) {
            String string7;
            if (!commandLineArguments.isOptionHasAValue(REROOTING_OPT)) {
                ForesterUtil.fatalError("no value for -r");
            }
            if (bl4) {
                ForesterUtil.fatalError("no re-rooting option for SDIR algorithm");
            }
            if ((string7 = commandLineArguments.getOptionValueAsCleanString(REROOTING_OPT).toLowerCase()).equals("none")) {
                rEROOTING = RIO.REROOTING.NONE;
            } else if (string7.equals("midpoint")) {
                rEROOTING = RIO.REROOTING.MIDPOINT;
            } else if (string7.equals("outgroup")) {
                if (bl3) {
                    ForesterUtil.fatalError("no outgroup option for operating on gene trees directory");
                }
                rEROOTING = RIO.REROOTING.OUTGROUP;
            } else {
                ForesterUtil.fatalError("values for re-rooting are: 'none', 'midpoint', or 'outgroup' (minizming duplications is default)");
            }
        }
        if (ForesterUtil.isEmpty(string6) && rEROOTING == RIO.REROOTING.OUTGROUP) {
            ForesterUtil.fatalError("selected re-rooting by outgroup, but outgroup not set");
        }
        if (!ForesterUtil.isEmpty(string6) && rEROOTING != RIO.REROOTING.OUTGROUP) {
            ForesterUtil.fatalError("outgroup set, but selected re-rooting by other approach");
        }
        int n = -1;
        int n2 = -1;
        if (commandLineArguments.isOptionSet(GT_FIRST)) {
            if (bl4) {
                ForesterUtil.fatalError("no gene tree range option for SDIR algorithm");
            }
            if (!commandLineArguments.isOptionHasAValue(GT_FIRST)) {
                ForesterUtil.fatalError("no value for -f");
            }
            try {
                n = commandLineArguments.getOptionValueAsInt(GT_FIRST);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError("could not parse integer for -f option");
            }
            if (n < 0) {
                ForesterUtil.fatalError("attempt to set index of first tree to analyze to: " + n);
            }
        }
        if (commandLineArguments.isOptionSet(GT_LAST)) {
            if (bl4) {
                ForesterUtil.fatalError("no gene tree range option for SDIR algorithm");
            }
            if (!commandLineArguments.isOptionHasAValue(GT_LAST)) {
                ForesterUtil.fatalError("no value for -l");
            }
            try {
                n2 = commandLineArguments.getOptionValueAsInt(GT_LAST);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError("could not parse integer for -l option");
            }
            if (n2 < 0) {
                ForesterUtil.fatalError("attempt to set index of last tree to analyze to: " + n2);
            }
        }
        if (n2 != -1 && n != -1 && n2 < n) {
            ForesterUtil.fatalError("attempt to set range (0-based) of gene to analyze to: from " + n + " to " + n2);
        }
        double d = 0.5;
        if (commandLineArguments.isOptionSet(ORTHOLOG_GROUPS_CUTOFF_OPTION)) {
            if (bl4) {
                ForesterUtil.fatalError("ortholog groups cutoff for SDIR algorithm");
            }
            if (!commandLineArguments.isOptionHasAValue(ORTHOLOG_GROUPS_CUTOFF_OPTION)) {
                ForesterUtil.fatalError("no value for -c");
            }
            try {
                d = commandLineArguments.getOptionValueAsDouble(ORTHOLOG_GROUPS_CUTOFF_OPTION);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError("could not parse double for -c option");
            }
            if (d < 0.0) {
                ForesterUtil.fatalError("attempt to set ortholog groups cutoff to: " + d);
            }
            if (d > 1.0) {
                ForesterUtil.fatalError("attempt to set ortholog groups cutoff to: " + d);
            }
        }
        if (!bl3) {
            ForesterUtil.fatalErrorIfFileNotReadable(file4);
        }
        if (commandLineArguments.isOptionSet(GENE_TREES_SUFFIX_OPTION)) {
            if (!bl3) {
                ForesterUtil.fatalError("no gene tree suffix option when operating on indivual gene trees");
            }
            if (!commandLineArguments.isOptionHasAValue(GENE_TREES_SUFFIX_OPTION)) {
                ForesterUtil.fatalError("no value for -g");
            }
            string4 = commandLineArguments.getOptionValueAsCleanString(GENE_TREES_SUFFIX_OPTION);
        } else {
            string4 = GENE_TREES_SUFFIX_DEFAULT;
        }
        if (commandLineArguments.isOptionSet(MAPPINGS_DIR_OPTION)) {
            file2 = new File(commandLineArguments.getOptionValue(MAPPINGS_DIR_OPTION));
            bl2 = true;
            if (!bl3) {
                ForesterUtil.fatalError("no id mapping when operating on indivual gene trees");
            }
            if (!file2.exists()) {
                ForesterUtil.fatalError("id mappings directory \"" + file2 + "\" does not exist");
            }
            if (!file2.isDirectory()) {
                ForesterUtil.fatalError("id mappings directory \"" + file2 + "\" is not a directory");
            }
            if (file2.listFiles().length < 1) {
                ForesterUtil.fatalError("id mappings directory \"" + file2 + "\" is empty");
            }
        } else {
            file2 = null;
            bl2 = false;
        }
        if (commandLineArguments.isOptionSet(MAPPINGS_SUFFIX_OPTION)) {
            if (!bl3) {
                ForesterUtil.fatalError("no id mapping file suffix option when operating on indivual gene trees");
            }
            if (!bl2) {
                ForesterUtil.fatalError("no id mapping directory given");
            }
            if (!commandLineArguments.isOptionHasAValue(MAPPINGS_SUFFIX_OPTION)) {
                ForesterUtil.fatalError("no value for -ms");
            }
            string3 = commandLineArguments.getOptionValueAsCleanString(MAPPINGS_SUFFIX_OPTION);
        } else {
            string3 = MAPPINGS_SUFFIX_DEFAULT;
        }
        if (commandLineArguments.isOptionSet(CONSENSUS_TREES_DIR_OPTION)) {
            file = new File(commandLineArguments.getOptionValue(CONSENSUS_TREES_DIR_OPTION));
            bl = true;
            if (!bl3) {
                ForesterUtil.fatalError("no consensus (\"best\") gene tree GSDIR analysis when operating on individual gene trees");
            }
            if (!file.exists()) {
                ForesterUtil.fatalError("consensus (\"best\") gene tree directory \"" + file + "\" does not exist");
            }
            if (!file.isDirectory()) {
                ForesterUtil.fatalError("consensus (\"best\") gene tree directory \"" + file + "\" is not a directory");
            }
            if (file.listFiles().length < 1) {
                ForesterUtil.fatalError("consensus (\"best\") gene tree directory \"" + file + "\" is empty");
            }
        } else {
            file = null;
            bl = false;
        }
        if (commandLineArguments.isOptionSet(CONSENSUS_TREES_SUFFIX_OPTION)) {
            if (!bl3) {
                ForesterUtil.fatalError("no consensus (\"best\") gene tree suffix option when operating on individual gene trees");
            }
            if (!bl) {
                ForesterUtil.fatalError("no consensus (\"best\") gene tree directory given");
            }
            if (!commandLineArguments.isOptionHasAValue(CONSENSUS_TREES_SUFFIX_OPTION)) {
                ForesterUtil.fatalError("no value for -cos");
            }
            string2 = commandLineArguments.getOptionValueAsCleanString(CONSENSUS_TREES_SUFFIX_OPTION);
        } else {
            string2 = CONSENSUS_TREE_SUFFIX_DEFAULT;
        }
        ForesterUtil.fatalErrorIfFileNotReadable(file7);
        if (!bl3 && file8.exists()) {
            ForesterUtil.fatalError("\"" + file8 + "\" already exists");
        }
        long l = 0L;
        try {
            if (bl3) {
                System.out.println("Gene trees in-dir                   :\t" + file5.getCanonicalPath());
                System.out.println("Gene trees suffix                   :\t" + string4);
            } else {
                System.out.println("Gene trees                          :\t" + file4.getCanonicalPath());
            }
            System.out.println("Species tree                        :\t" + file7.getCanonicalPath());
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(iOException.getLocalizedMessage());
        }
        if (bl2) {
            try {
                System.out.println("Id mappings in-dir                  :\t" + file2.getCanonicalPath());
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(iOException.getLocalizedMessage());
            }
            System.out.println("Id mappings suffix                  :\t" + string3);
        }
        if (bl) {
            try {
                System.out.println("Consensus (\"best\") gene trees in-dir:\t" + file.getCanonicalPath());
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(iOException.getLocalizedMessage());
            }
            System.out.println("Consensus (\"best\") gene trees suffix:\t" + string2);
        }
        if (bl3) {
            System.out.println("Out-dir                             :\t" + file6);
        } else {
            System.out.println("All vs all orthology results table  :\t" + file8);
        }
        if (file3 != null) {
            System.out.println("Logfile                             :\t" + file3);
        }
        System.out.println("Ortholog groups cutoff              :\t" + d);
        if (n != -1) {
            System.out.println("First gene tree to analyze          :\t" + n);
        }
        if (n2 != -1) {
            System.out.println("Last gene tree to analyze           :\t" + n2);
        }
        String string8 = "";
        switch (rEROOTING) {
            case BY_ALGORITHM: {
                string8 = "by minimizing duplications";
                break;
            }
            case MIDPOINT: {
                string8 = "by midpoint method";
                break;
            }
            case OUTGROUP: {
                string8 = "by outgroup: " + string6;
                break;
            }
            case NONE: {
                string8 = "none";
            }
        }
        System.out.println("Re-rooting                          : \t" + string8);
        if (!bl4) {
            System.out.println("Non binary species tree             :\tallowed");
        } else {
            System.out.println("Non binary species tree             :\tdisallowed");
        }
        l = System.currentTimeMillis();
        SDIutil.ALGORITHM aLGORITHM = bl4 ? SDIutil.ALGORITHM.SDIR : SDIutil.ALGORITHM.GSDIR;
        EasyWriter easyWriter = null;
        if (bl3) {
            Object[] objectArray;
            if (file6.exists()) {
                if (!file6.isDirectory()) {
                    ForesterUtil.fatalError(PRG_NAME, "out-directory [" + file6 + "] already exists but is not a directory");
                }
            } else {
                boolean bl5 = file6.mkdirs();
                if (!bl5) {
                    ForesterUtil.fatalError(PRG_NAME, "could not create out-directory [" + file6 + "]");
                }
            }
            if ((objectArray = file5.listFiles(new FilenameFilter(string = file7.getName()){
                final /* synthetic */ String val$species_tree_file_name;
                {
                    this.val$species_tree_file_name = string2;
                }

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(string4) && !string.equals(this.val$species_tree_file_name);
                }
            })).length < 1) {
                ForesterUtil.fatalError(PRG_NAME, "in-directory [" + file5 + "] does not contain any gene tree files with suffix " + string4);
            }
            try {
                easyWriter = ForesterUtil.createEasyWriter(file3);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "could not create [" + file3 + "]");
            }
            Arrays.sort(objectArray);
            try {
                easyWriter.print("# program");
                easyWriter.print("\t");
                easyWriter.print(PRG_NAME);
                easyWriter.println();
                easyWriter.print("# version");
                easyWriter.print("\t");
                easyWriter.print(PRG_VERSION);
                easyWriter.println();
                easyWriter.print("# date");
                easyWriter.print("\t");
                easyWriter.print(PRG_DATE);
                easyWriter.println();
                easyWriter.print("# Algorithm ");
                easyWriter.print("\t");
                easyWriter.print(aLGORITHM.toString());
                easyWriter.println();
                easyWriter.print("# Gene trees in-dir");
                easyWriter.print("\t");
                easyWriter.print(file5.getCanonicalPath());
                easyWriter.println();
                easyWriter.print("# Gene trees suffix");
                easyWriter.print("\t");
                easyWriter.print(string4);
                easyWriter.println();
                easyWriter.print("# Species tree");
                easyWriter.print("\t");
                easyWriter.print(file7.getCanonicalPath());
                easyWriter.println();
                if (bl2) {
                    easyWriter.print("# Id mappings in-dir");
                    easyWriter.print("\t");
                    easyWriter.print(file2.getCanonicalPath());
                    easyWriter.println();
                    easyWriter.print("# Id mappings suffix");
                    easyWriter.print("\t");
                    easyWriter.print(string3);
                    easyWriter.println();
                }
                if (bl) {
                    easyWriter.print("# Consensus (\"best\") gene tree dir");
                    easyWriter.print("\t");
                    easyWriter.print(file.getCanonicalPath());
                    easyWriter.println();
                    easyWriter.print("# Consensus (\"best\") gene tree suffix");
                    easyWriter.print("\t");
                    easyWriter.print(string2);
                    easyWriter.println();
                }
                easyWriter.print("# Out-dir");
                easyWriter.print("\t");
                easyWriter.print(file6.getCanonicalPath());
                easyWriter.println();
                easyWriter.print("# Logfile");
                easyWriter.print("\t");
                easyWriter.print(file3.getCanonicalPath());
                easyWriter.println();
                easyWriter.print("# Ortholog groups cutoff");
                easyWriter.print("\t");
                easyWriter.print(Double.toString(d));
                easyWriter.println();
                if (n != -1) {
                    easyWriter.print("# First gene tree to analyze");
                    easyWriter.print("\t");
                    easyWriter.print(Integer.toString(n));
                    easyWriter.println();
                }
                if (n2 != -1) {
                    easyWriter.print("# Last gene tree to analyze");
                    easyWriter.print("\t");
                    easyWriter.print(Integer.toString(n2));
                    easyWriter.println();
                }
                easyWriter.print("# Re-rooting");
                easyWriter.print("\t");
                easyWriter.print(string8);
                easyWriter.println();
                easyWriter.print("# Non binary species tree");
                easyWriter.print("\t");
                if (!bl4) {
                    easyWriter.print("allowed");
                } else {
                    easyWriter.print("disallowed");
                }
                easyWriter.println();
                easyWriter.println();
                easyWriter.print("NAME");
                easyWriter.print("\t");
                easyWriter.print("EXT NODES");
                easyWriter.print("\t");
                easyWriter.print(d + " O GROUPS");
                easyWriter.print("\t");
                easyWriter.print("0.05 O GROUPS");
                easyWriter.print("\t");
                easyWriter.print("0.25 O GROUPS");
                easyWriter.print("\t");
                easyWriter.print("0.5 O GROUPS");
                easyWriter.print("\t");
                easyWriter.print("0.75 O GROUPS");
                easyWriter.print("\t");
                easyWriter.print("0.95 O GROUPS");
                easyWriter.print("\t");
                if (bl) {
                    easyWriter.print("BEST TREE DUP");
                    easyWriter.print("\t");
                    easyWriter.print("MEDIAN DUP - BEST TREE DUP");
                    easyWriter.print("\t");
                }
                easyWriter.print("MEDIAN DUP");
                easyWriter.print("\t");
                easyWriter.print("MEAN DUP");
                easyWriter.print("\t");
                easyWriter.print("MEAN DUP SD");
                easyWriter.print("\t");
                easyWriter.print("MIN DUP");
                easyWriter.print("\t");
                easyWriter.print("MAX DUP");
                easyWriter.print("\t");
                easyWriter.print("REMOVED EXT NODES");
                easyWriter.print("\t");
                easyWriter.print("N");
                easyWriter.println();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
            int n3 = 1;
            for (Object object : objectArray) {
                String string9 = ((File)object).getName();
                System.out.print("\r                                                                                            ");
                System.out.print("\r" + n3 + "/" + objectArray.length + ": " + string9);
                ++n3;
                if (string9.indexOf(".") > 0) {
                    string9 = string9.substring(0, string9.lastIndexOf("."));
                }
                try {
                    RIOUtil.executeAnalysis((File)object, file7, new File(file6.getCanonicalFile() + "/" + string9 + "_RIO_orthologies.tsv"), new File(file6.getCanonicalFile() + "/" + string9 + "_RIO_orthologies_ext_map.tsv"), new File(file6.getCanonicalFile() + "/" + string9 + "_RIO_ortholog_groups.tsv"), new File(file6.getCanonicalFile() + "/" + string9 + "_RIO_log.tsv"), string6, rEROOTING, n, n2, new File(file6.getCanonicalFile() + "/" + string9 + "_RIO_stripped_species_tree.xml"), new File(file6.getCanonicalFile() + "/" + string9 + "_RIO_gene_tree_min_dup_"), new File(file6.getCanonicalFile() + "/" + string9 + "_RIO_gene_tree_med_dup_"), true, aLGORITHM, true, easyWriter, d, bl2, file2, string3, bl, file6, file, string2);
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
                }
            }
            System.out.print("\r                                                                                        ");
            System.out.println();
        } else {
            string = ForesterUtil.removeFileExtension(file8.toString());
            RIOUtil.executeAnalysis(file4, file7, file8, null, new File(string + "_RIO_ortholog_groups.tsv"), file3, string6, rEROOTING, n, n2, new File(string + "_RIO_stripped_species_tree.xml"), new File(string + "_RIO_gene_tree_min_dup_"), new File(string + "_RIO_gene_tree_med_dup_"), aLGORITHM == SDIutil.ALGORITHM.GSDIR, aLGORITHM, false, null, d, false, null, null, false, null, null, null);
        }
        if (!bl3) {
            l = System.currentTimeMillis() - l;
            System.out.println("Time                                :\t" + l + MAPPINGS_SUFFIX_OPTION);
        } else {
            try {
                easyWriter.close();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
            l = System.currentTimeMillis() - l;
            System.out.println("Time                                :\t" + l + MAPPINGS_SUFFIX_OPTION);
        }
        System.exit(0);
    }

    private static final void printHelp() {
        System.out.println("Usage");
        System.out.println();
        System.out.println("rio [options] <gene trees infile> <species tree infile> <all vs all orthology table outfile> [logfile]");
        System.out.println();
        System.out.println("rio [options] <gene trees indir> <species tree infile> <outdir> <logfile>");
        System.out.println();
        System.out.println();
        System.out.println(" Options");
        System.out.println("  -f=<first>     : first gene tree to analyze (0-based index)");
        System.out.println("  -l=<last>      : last gene tree to analyze (0-based index)");
        System.out.println("  -c=<cutoff>    : cutoff value for ortholog groups (default: 0.5)");
        System.out.println("  -r=<re-rooting>: re-rooting method for gene trees, possible values or 'none', 'midpoint',");
        System.out.println("                   or 'outgroup' (default: by minizming duplications)");
        System.out.println("  -o=<outgroup>  : for rooting by outgroup, name of outgroup (external gene tree node)");
        System.out.println("  -s             : to use SDIR instead of GSDIR (faster, but non-binary species trees are");
        System.out.println("                   disallowed, as are most options)");
        System.out.println("  -g=<suffix>    : suffix for gene trees when operating on gene tree directories (default: .mlt)");
        System.out.println("  -m=<dir>       : directory for id mapping files");
        System.out.println("  -ms=<suffix>   : suffix for id mapping files (default: .nim)");
        System.out.println("  -co=<dir>      : directory with consenus (\"best\") gene trees to be analyzed with GSDIR");
        System.out.println("  -cos=<suffix>  : suffix for consenus (\"best\") gene trees (default: .xml)");
        System.out.println();
        System.out.println(" Formats");
        System.out.println("  The gene trees, as well as the species tree, ideally are in phyloXML (www.phyloxml.org) format,");
        System.out.println("  but can also be in New Hamphshire (Newick) or Nexus format as long as species information can be");
        System.out.println("  extracted from the gene names (e.g. \"HUMAN\" from \"BCL2_HUMAN\") and matched to a single species");
        System.out.println("  in the species tree.");
        System.out.println();
        System.out.println(" Examples");
        System.out.println("  rio -s gene_trees.nh species.xml outtable.tsv");
        System.out.println("  rio gene_trees.nh species.xml outtable.tsv log.txt");
        System.out.println("  rio -c=0.9 -f=10 -l=100 -r=none gene_trees.xml species.xml outtable.tsv log.txt");
        System.out.println("  rio -g=.xml gene_trees_dir species.xml out_dir log.tsv");
        System.out.println("  rio -g=.mlt -m=id_maps_dir -ms=.nim -c=0.8 gene_trees_dir species.xml out_dir log.tsv");
        System.out.println("  rio -m=id_maps_dir -c=0.8 gene_trees_dir species.xml out_dir log.tsv");
        System.out.println("  rio -m=id_maps_dir -co=consensus_dir -cos=.xml -c=0.8 gene_trees_dir species.xml out_dir log.tsv");
        System.out.println();
        System.exit(-1);
    }
}

