/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.forester.archaeopteryx.TreePanel;
import org.forester.util.ForesterUtil;

final class Printer {
    private Printer() {
    }

    static String print(TreePanel treePanel, String string) throws PrinterException {
        if (treePanel == null || treePanel.getPhylogeny() == null) {
            throw new IllegalArgumentException("attempt to print null");
        }
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt use null or empty print job name");
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob != null) {
            printerJob.setJobName(string);
            printerJob.setPrintable(treePanel);
            boolean bl = printerJob.printDialog();
            if (bl) {
                printerJob.print();
                String string2 = printerJob.getPrintService().getName();
                if (!ForesterUtil.isEmpty(string2)) {
                    return string2;
                }
                return "";
            }
            return null;
        }
        throw new PrinterException("failed to access printer job");
    }
}

