/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.phylogeny.data;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.sequence.MolecularSequence;

public final class RenderableMsaSequence
implements RenderablePhylogenyData {
    static final int DEFAULT_HEIGHT = 12;
    public static final int DEFAULT_WIDTH = 400;
    private double _rendering_factor_width = 1.0;
    private char[] _seq = null;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private double _height = 12.0;
    private final float _width = 400.0f;
    private MolecularSequence.TYPE _type;
    private static RenderableMsaSequence _instance = null;

    private RenderableMsaSequence() {
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this._seq.toString());
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    public Object clone() {
        throw new NoSuchMethodError();
    }

    @Override
    public PhylogenyData copy() {
        throw new NoSuchMethodError();
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this.getTotalLength(), (int)this.getRenderingHeight());
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public double getRenderingFactorWidth() {
        return this._rendering_factor_width;
    }

    @Override
    public Dimension getRenderingSize() {
        return this.getOriginalSize();
    }

    public int getTotalLength() {
        return this._seq.length;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new NoSuchMethodError();
    }

    @Override
    public void render(float f, float f2, Graphics2D graphics2D, TreePanel treePanel, boolean bl) {
        float f3 = f2;
        float f4 = f + 20.0f;
        float f5 = 400.0f / (float)this._seq.length;
        for (int i = 0; i < this._seq.length; ++i) {
            char c = this._seq[i];
            if (f5 < 4.0f) {
                if (c == '-') continue;
                graphics2D.setColor(this.calculateColor(c));
                this._rectangle.setFrame(f4 + (float)i * f5, (double)f3 - 0.5, f5 + 1.0f, this.getRenderingHeight());
                graphics2D.fill(this._rectangle);
                continue;
            }
            graphics2D.setColor(this.calculateColor(c));
            graphics2D.drawString(String.valueOf(c), f4 + (float)i * f5, f3 - 0.5f);
        }
    }

    @Override
    public void setParameter(double d) {
        throw new NoSuchMethodError();
    }

    public void setRenderingFactorWidth(double d) {
        this._rendering_factor_width = d;
    }

    @Override
    public void setRenderingHeight(float f) {
        this._height = f;
    }

    @Override
    public StringBuffer toNHX() {
        throw new NoSuchMethodError();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        throw new NoSuchMethodError();
    }

    private Color calculateColor(char c) {
        if (this._type == MolecularSequence.TYPE.AA) {
            return this.calculateAAColor(c);
        }
        return this.calculateNucleotideColor(c);
    }

    private Color calculateNucleotideColor(char c) {
        if (c == 'A') {
            return Color.YELLOW;
        }
        if (c == 'T' || c == 'U') {
            return Color.ORANGE;
        }
        if (c == 'G') {
            return Color.BLUE;
        }
        if (c == 'C') {
            return Color.CYAN;
        }
        if (c == '-') {
            return Color.GRAY;
        }
        return Color.GRAY;
    }

    private Color calculateAAColor(char c) {
        if (c == 'G' || c == 'A' || c == 'S' || c == 'T') {
            return Color.YELLOW;
        }
        if (c == 'N' || c == 'Q' || c == 'H') {
            return Color.PINK;
        }
        if (c == 'D' || c == 'E') {
            return Color.RED;
        }
        if (c == 'K' || c == 'R') {
            return Color.BLUE;
        }
        if (c == '-') {
            return Color.GRAY;
        }
        if (c == 'X') {
            return Color.GRAY;
        }
        return Color.GREEN;
    }

    private double getRenderingHeight() {
        return this._height;
    }

    public static RenderableMsaSequence createInstance(String string, String string2, Configuration configuration) {
        if (_instance == null) {
            _instance = new RenderableMsaSequence();
        }
        RenderableMsaSequence._instance._type = string2.equals("protein") ? MolecularSequence.TYPE.AA : (string2.equals("dna") ? MolecularSequence.TYPE.DNA : MolecularSequence.TYPE.RNA);
        RenderableMsaSequence._instance._seq = string.toCharArray();
        if (configuration != null) {
            // empty if block
        }
        return _instance;
    }
}

