/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.Timer;

public final class TypomaticJButton
extends JButton
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 7435606927739361980L;
    private boolean pressed = false;
    private boolean repeat_enabled = true;
    private Timer timer = null;
    private int initial_delay = 600;
    private int delay = 200;
    private int modifiers = 0;

    public TypomaticJButton() {
        this.init();
    }

    public TypomaticJButton(Action action) {
        super(action);
        this.init();
    }

    public TypomaticJButton(Icon icon) {
        super(icon);
        this.init();
    }

    public TypomaticJButton(String string) {
        super(string);
        this.init();
    }

    public TypomaticJButton(String string, Icon icon) {
        super(string, icon);
        this.init();
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            ActionEvent actionEvent2 = new ActionEvent(this, 1001, super.getActionCommand(), this.modifiers);
            super.fireActionPerformed(actionEvent2);
        }
    }

    public final int getDelay() {
        return this.delay;
    }

    public final int getInitialDelay() {
        return this.initial_delay;
    }

    private final void init() {
        this.addMouseListener(this);
        this.timer = new Timer(this.delay, this);
        this.timer.setRepeats(true);
    }

    public final boolean isRepeatEnabled() {
        return this.repeat_enabled;
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.pressed = false;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && this.isEnabled() && this.isRepeatEnabled() && this.pressed && !this.timer.isRunning()) {
            this.modifiers = mouseEvent.getModifiersEx();
            this.timer.setInitialDelay(this.delay);
            this.timer.start();
        }
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && this.isEnabled() && this.isRepeatEnabled()) {
            this.pressed = true;
            if (!this.timer.isRunning()) {
                this.modifiers = mouseEvent.getModifiersEx();
                this.timer.setInitialDelay(this.initial_delay);
                this.timer.start();
            }
        }
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.pressed = false;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    public final void setDelay(int n) {
        this.delay = n;
    }

    @Override
    public final void setEnabled(boolean bl) {
        if (bl != super.isEnabled()) {
            this.pressed = false;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
        super.setEnabled(bl);
    }

    public final void setInitialDelay(int n) {
        this.initial_delay = n;
    }

    public final void setRepeatEnabled(boolean bl) {
        if (!bl) {
            this.pressed = false;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
        this.repeat_enabled = bl;
    }
}

