/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;

public final class Sset {
    public static final int FACTOR = 1000000;
    private static final boolean DEBUG = true;
    private final List<SortedMap<Integer, Set<Integer>>> _data = new ArrayList<SortedMap<Integer, Set<Integer>>>();

    public final void addPairing(double d, int n, int n2) {
        Sset.addPairing((int)(1000000.0 * d), n, this.getS(n2));
    }

    public final void addPairing(int n, int n2, int n3) {
        Sset.addPairing(n, n2, this.getS(n3));
    }

    public final SortedMap<Integer, Set<Integer>> getS(int n) {
        return this._data.get(n);
    }

    public final Set<Integer> getValues(int n, int n2) {
        return (Set)this.getS(n2).get(n);
    }

    public final void initialize(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        for (int i = 0; i < basicSymmetricalDistanceMatrix.getSize(); ++i) {
            TreeMap<Integer, Set<Integer>> treeMap = new TreeMap<Integer, Set<Integer>>();
            this._data.add(treeMap);
            for (int j = 0; j < i; ++j) {
                Sset.addPairing((int)(1000000.0 * basicSymmetricalDistanceMatrix.getValues()[j][i]), j, treeMap);
            }
        }
    }

    public final void initialize(int n) {
        for (int i = 0; i < n; ++i) {
            TreeMap treeMap = new TreeMap();
            this._data.add(treeMap);
        }
    }

    public final void removePairing(double d, int n, int n2) {
        this.removePairing((int)(d * 1000000.0), n, n2);
    }

    public final void removePairing(int n, int n2, int n3) {
        SortedMap<Integer, Set<Integer>> sortedMap = this._data.get(n3);
        Set set = (Set)sortedMap.get(n);
        if (set == null) {
            System.out.println();
            System.out.println("________________________________________________________________________________________");
            System.out.println(this.toString());
            throw new IllegalArgumentException("key " + n + " (->" + n2 + ") does not exist for row " + n3);
        }
        if (set.size() == 1) {
            if (!set.contains(n2)) {
                System.out.println();
                System.out.println("________________________________________________________________________________________");
                System.out.println(this.toString());
                throw new IllegalArgumentException("pairing " + n + "->" + n2 + " does not exist for row " + n3);
            }
            sortedMap.remove(n);
        } else if (set.size() > 1) {
            if (!set.remove(n2)) {
                throw new IllegalArgumentException("pairing " + n + "->" + n2 + " does not exist (could not be removed) for row " + n3);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public final int size() {
        return this._data.size();
    }

    public final Set<Integer>[] toArray(int n) {
        return this._data.get(n).values().toArray(new Set[this._data.get(n).size()]);
    }

    public final String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(i);
            stringBuilder.append(": ");
            for (Map.Entry<Integer, Set<Integer>> entry : this.getSentrySet(i)) {
                double d = entry.getKey().intValue();
                Set<Integer> set = entry.getValue();
                stringBuilder.append(decimalFormat.format(d / 1000000.0) + "->");
                boolean bl = true;
                for (int n : set) {
                    if (!bl) {
                        stringBuilder.append(",");
                    }
                    bl = false;
                    stringBuilder.append(n);
                }
                stringBuilder.append("  ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    final Set<Map.Entry<Integer, Set<Integer>>> getSentrySet(int n) {
        return this.getS(n).entrySet();
    }

    private static final void addPairing(int n, int n2, SortedMap<Integer, Set<Integer>> sortedMap) {
        if (!sortedMap.containsKey(n)) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(n2);
            sortedMap.put(n, hashSet);
        } else {
            if (((Set)sortedMap.get(n)).contains(n2)) {
                throw new IllegalArgumentException("pairing " + n + "->" + n2 + " already exists");
            }
            ((Set)sortedMap.get(n)).add(n2);
        }
    }
}

