/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.parsimony;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class DolloParsimony {
    private static final CharacterStateMatrix.BinaryStates PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
    private static final CharacterStateMatrix.BinaryStates ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
    private static final CharacterStateMatrix.BinaryStates UNKNOWN = CharacterStateMatrix.BinaryStates.UNKNOWN;
    private static final CharacterStateMatrix.GainLossStates LOSS = CharacterStateMatrix.GainLossStates.LOSS;
    private static final CharacterStateMatrix.GainLossStates GAIN = CharacterStateMatrix.GainLossStates.GAIN;
    private static final CharacterStateMatrix.GainLossStates UNCHANGED_PRESENT = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
    private static final CharacterStateMatrix.GainLossStates UNCHANGED_ABSENT = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
    private static final boolean RETURN_INTERNAL_STATES_DEFAULT = false;
    private static final boolean RETURN_GAIN_LOSS_MATRIX_DEFAULT = false;
    private boolean _return_internal_states = false;
    private boolean _return_gain_loss = false;
    private int _total_gains;
    private int _total_losses;
    private int _total_unchanged;
    private CharacterStateMatrix<CharacterStateMatrix.BinaryStates> _internal_states_matrix;
    private CharacterStateMatrix<CharacterStateMatrix.GainLossStates> _gain_loss_matrix;

    private DolloParsimony() {
        this.init();
    }

    public void execute(Phylogeny phylogeny, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix) {
        if (!phylogeny.isRooted()) {
            throw new IllegalArgumentException("attempt to execute Dollo parsimony on unroored phylogeny");
        }
        if (characterStateMatrix.isEmpty()) {
            throw new IllegalArgumentException("character matrix is empty");
        }
        if (characterStateMatrix.getNumberOfIdentifiers() != phylogeny.getNumberOfExternalNodes()) {
            throw new IllegalArgumentException("number of external nodes in phylogeny [" + phylogeny.getNumberOfExternalNodes() + "] and number of indentifiers [" + characterStateMatrix.getNumberOfIdentifiers() + "] in matrix are not equal");
        }
        this.reset();
        if (this.isReturnInternalStates()) {
            this.initializeInternalStates(phylogeny, characterStateMatrix);
        }
        if (this.isReturnGainLossMatrix()) {
            this.initializeGainLossMatrix(phylogeny, characterStateMatrix);
        }
        for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
            this.executeForOneCharacter(phylogeny, this.getStatesForCharacter(phylogeny, characterStateMatrix, i), i);
        }
        if (characterStateMatrix.getNumberOfCharacters() * phylogeny.getNumberOfBranches() != this.getTotalGains() + this.getTotalLosses() + this.getTotalUnchanged()) {
            throw new AssertionError((Object)"this should not have happened: something is deeply wrong with Dollo parsimony implementation");
        }
    }

    private void executeForOneCharacter(Phylogeny phylogeny, Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map, int n) {
        this.postOrderTraversal(phylogeny, map);
        this.preOrderTraversal(phylogeny, map, n);
    }

    public int getCost() {
        return this.getTotalGains() + this.getTotalLosses();
    }

    public CharacterStateMatrix<CharacterStateMatrix.GainLossStates> getGainLossMatrix() {
        if (!this.isReturnGainLossMatrix()) {
            throw new RuntimeException("creation of gain-loss matrix has not been enabled");
        }
        return this._gain_loss_matrix;
    }

    public CharacterStateMatrix<CharacterStateMatrix.BinaryStates> getInternalStatesMatrix() {
        if (!this.isReturnInternalStates()) {
            throw new RuntimeException("creation of internal state matrix has not been enabled");
        }
        return this._internal_states_matrix;
    }

    private Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> getStatesForCharacter(Phylogeny phylogeny, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix, int n) {
        HashMap<PhylogenyNode, CharacterStateMatrix.BinaryStates> hashMap = new HashMap<PhylogenyNode, CharacterStateMatrix.BinaryStates>(characterStateMatrix.getNumberOfIdentifiers());
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            CharacterStateMatrix.BinaryStates binaryStates = characterStateMatrix.getState(i, n);
            if (binaryStates == null) {
                throw new IllegalArgumentException("value at [" + i + ", " + n + "] is null");
            }
            hashMap.put(phylogeny.getNode(characterStateMatrix.getIdentifier(i)), binaryStates);
        }
        return hashMap;
    }

    public int getTotalGains() {
        return this._total_gains;
    }

    public int getTotalLosses() {
        return this._total_losses;
    }

    public int getTotalUnchanged() {
        return this._total_unchanged;
    }

    private void init() {
        this.setReturnInternalStates(false);
        this.setReturnGainLossMatrix(false);
        this.reset();
    }

    private void initializeGainLossMatrix(Phylogeny phylogeny, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            arrayList.add(phylogenyNodeIterator.next());
        }
        this.setGainLossMatrix(new BasicCharacterStateMatrix<CharacterStateMatrix.GainLossStates>(arrayList.size(), characterStateMatrix.getNumberOfCharacters()));
        int n = 0;
        for (PhylogenyNode phylogenyNode : arrayList) {
            this.getGainLossMatrix().setIdentifier(n++, ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName());
        }
        for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
            this.getGainLossMatrix().setCharacter(i, characterStateMatrix.getCharacter(i));
        }
    }

    private void initializeInternalStates(Phylogeny phylogeny, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal()) continue;
            arrayList.add(phylogenyNode);
        }
        this.setInternalStatesMatrix(new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(arrayList.size(), characterStateMatrix.getNumberOfCharacters()));
        int n = 0;
        for (PhylogenyNode phylogenyNode : arrayList) {
            this.getInternalStatesMatrix().setIdentifier(n++, ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName());
        }
        for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
            this.getInternalStatesMatrix().setCharacter(i, characterStateMatrix.getCharacter(i));
        }
    }

    private boolean isReturnGainLossMatrix() {
        return this._return_gain_loss;
    }

    private boolean isReturnInternalStates() {
        return this._return_internal_states;
    }

    private void postOrderTraversal(Phylogeny phylogeny, Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map) throws AssertionError {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            int n = DolloParsimony.getNumberOfChildNodesWithPresentOrUnknownState(map, phylogenyNode);
            if (n < 1) {
                map.put(phylogenyNode, ABSENT);
                continue;
            }
            if (n == 1) {
                map.put(phylogenyNode, UNKNOWN);
                continue;
            }
            map.put(phylogenyNode, PRESENT);
        }
    }

    private void preOrderTraversal(Phylogeny phylogeny, Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map, int n) throws AssertionError {
        boolean bl = false;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            CharacterStateMatrix.BinaryStates binaryStates = null;
            if (!phylogenyNode.isRoot()) {
                binaryStates = map.get(phylogenyNode.getParent());
            }
            if (!phylogenyNode.isExternal()) {
                if (map.get(phylogenyNode) == UNKNOWN) {
                    if (binaryStates == PRESENT) {
                        map.put(phylogenyNode, PRESENT);
                    } else if (DolloParsimony.isCharacterPresentOrUnknownInAtLeastTwoChildNodes(map, phylogenyNode)) {
                        map.put(phylogenyNode, PRESENT);
                    } else {
                        map.put(phylogenyNode, ABSENT);
                    }
                }
                if (this.isReturnInternalStates()) {
                    this.setInternalNodeState(map, n, phylogenyNode);
                }
            }
            CharacterStateMatrix.BinaryStates binaryStates2 = map.get(phylogenyNode);
            if (binaryStates == PRESENT && binaryStates2 == ABSENT) {
                ++this._total_losses;
                if (!this.isReturnGainLossMatrix()) continue;
                this.setGainLossState(n, phylogenyNode, LOSS);
                continue;
            }
            if (binaryStates == ABSENT && binaryStates2 == PRESENT) {
                if (bl) {
                    throw new RuntimeException("this should not have happened: dollo parsimony cannot have more than one gain");
                }
                bl = true;
                ++this._total_gains;
                if (!this.isReturnGainLossMatrix()) continue;
                this.setGainLossState(n, phylogenyNode, GAIN);
                continue;
            }
            ++this._total_unchanged;
            if (!this.isReturnGainLossMatrix()) continue;
            if (binaryStates2 == PRESENT) {
                this.setGainLossState(n, phylogenyNode, UNCHANGED_PRESENT);
                continue;
            }
            if (binaryStates2 != ABSENT) continue;
            this.setGainLossState(n, phylogenyNode, UNCHANGED_ABSENT);
        }
    }

    private void reset() {
        this.setTotalLosses(0);
        this.setTotalGains(0);
        this.setTotalUnchanged(0);
    }

    private void setGainLossMatrix(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix) {
        this._gain_loss_matrix = characterStateMatrix;
    }

    private void setGainLossState(int n, PhylogenyNode phylogenyNode, CharacterStateMatrix.GainLossStates gainLossStates) {
        this.getGainLossMatrix().setState(ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName(), n, gainLossStates);
    }

    private void setInternalNodeState(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map, int n, PhylogenyNode phylogenyNode) {
        this.getInternalStatesMatrix().setState(ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName(), n, map.get(phylogenyNode));
    }

    private void setInternalStatesMatrix(CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix) {
        this._internal_states_matrix = characterStateMatrix;
    }

    public void setReturnGainLossMatrix(boolean bl) {
        this._return_gain_loss = bl;
    }

    public void setReturnInternalStates(boolean bl) {
        this._return_internal_states = bl;
    }

    private void setTotalGains(int n) {
        this._total_gains = n;
    }

    private void setTotalLosses(int n) {
        this._total_losses = n;
    }

    private void setTotalUnchanged(int n) {
        this._total_unchanged = n;
    }

    public static DolloParsimony createInstance() {
        return new DolloParsimony();
    }

    private static int getNumberOfChildNodesWithPresentOrUnknownState(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map, PhylogenyNode phylogenyNode) {
        int n = 0;
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
            if (!map.containsKey(phylogenyNode2)) {
                throw new RuntimeException("this should not have happened: node [" + phylogenyNode2.getName() + "] not found in node state map");
            }
            if (map.get(phylogenyNode2) != CharacterStateMatrix.BinaryStates.PRESENT && map.get(phylogenyNode2) != CharacterStateMatrix.BinaryStates.UNKNOWN) continue;
            ++n;
        }
        return n;
    }

    private static boolean isCharacterPresentOrUnknownInAtLeastTwoChildNodes(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map, PhylogenyNode phylogenyNode) {
        int n = 0;
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
            if (map.get(phylogenyNode2) != PRESENT && map.get(phylogenyNode2) != UNKNOWN || ++n <= 1) continue;
            return true;
        }
        return false;
    }
}

