/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.ProteinDomain;

public class ProteinDomainParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private ProteinDomainParser() {
    }

    @Override
    public ProteinDomain parse(XmlElement xmlElement) throws PhyloXmlDataFormatException {
        String string = "";
        int n = -1;
        int n2 = -1;
        double d = -1.0;
        String string2 = "";
        try {
            n = Integer.parseInt(xmlElement.getAttribute("from"));
            n2 = Integer.parseInt(xmlElement.getAttribute("to"));
            d = Double.parseDouble(xmlElement.getAttribute("confidence"));
            if (xmlElement.isHasAttribute("id")) {
                string2 = xmlElement.getAttribute("id");
            }
        }
        catch (Exception exception) {
            throw new PhyloXmlDataFormatException("failed to parse element [" + xmlElement + "]: " + exception.getMessage());
        }
        string = xmlElement.getValueAsString();
        if (n == -1) {
            throw new PhyloXmlDataFormatException("\"from\" attribute not set in: " + xmlElement);
        }
        if (n2 == -1) {
            throw new PhyloXmlDataFormatException("\"to\" attribute not set in: " + xmlElement);
        }
        if (d < 0.0) {
            throw new PhyloXmlDataFormatException("\"confidence\" attribute either negative or not set in: " + xmlElement);
        }
        return new ProteinDomain(string, n, n2, string2, d);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new ProteinDomainParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

