/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public final class ModelingUtils {
    static double calculateBranchLengthSum(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        PhylogenyNode phylogenyNode3 = PhylogenyMethods.calculateLCA(phylogenyNode, phylogenyNode2);
        return ModelingUtils.calculateBranchLengthSumHelper(phylogenyNode, phylogenyNode3) + ModelingUtils.calculateBranchLengthSumHelper(phylogenyNode2, phylogenyNode3);
    }

    private static double calculateBranchLengthSumHelper(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        double d = 0.0;
        for (PhylogenyNode phylogenyNode3 = phylogenyNode; phylogenyNode3 != phylogenyNode2; phylogenyNode3 = phylogenyNode3.getParent()) {
            if (!(phylogenyNode3.getDistanceToParent() > 0.0)) continue;
            d += phylogenyNode3.getDistanceToParent();
        }
        return d;
    }

    static int calculateBranchSum(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        PhylogenyNode phylogenyNode3 = PhylogenyMethods.calculateLCA(phylogenyNode, phylogenyNode2);
        return ModelingUtils.calculateBranchSumHelper(phylogenyNode, phylogenyNode3) + ModelingUtils.calculateBranchSumHelper(phylogenyNode2, phylogenyNode3);
    }

    private static int calculateBranchSumHelper(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        int n = 0;
        for (PhylogenyNode phylogenyNode3 = phylogenyNode; phylogenyNode3 != phylogenyNode2; phylogenyNode3 = phylogenyNode3.getParent()) {
            ++n;
        }
        return n;
    }

    static SortedMap<PhylogenyNode, Double> setUpExternalCoverageHashMap(Phylogeny phylogeny) {
        TreeMap<PhylogenyNode, Double> treeMap = new TreeMap<PhylogenyNode, Double>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            treeMap.put(phylogenyNodeIterator.next(), 0.0);
        }
        return treeMap;
    }
}

