/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashMap;
import java.util.Map;
import org.forester.protein.BasicDomain;
import org.forester.surfacing.BasicBinaryDomainCombination;

public class AdjactantDirectedBinaryDomainCombination
extends BasicBinaryDomainCombination {
    private static final Map<Integer, AdjactantDirectedBinaryDomainCombination> ADDC_POOL = new HashMap<Integer, AdjactantDirectedBinaryDomainCombination>();

    private AdjactantDirectedBinaryDomainCombination(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("attempt to create binary domain combination using null");
        }
        this._id0 = BasicDomain.obtainIdAsShort(string);
        this._id1 = BasicDomain.obtainIdAsShort(string2);
    }

    public static final AdjactantDirectedBinaryDomainCombination obtainInstance(String string) {
        if (string.indexOf("=") < 1) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + string + "]");
        }
        String[] stringArray = string.split("=");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + string + "]");
        }
        return AdjactantDirectedBinaryDomainCombination.obtainInstance(stringArray[0], stringArray[1]);
    }

    public static final AdjactantDirectedBinaryDomainCombination obtainInstance(String string, String string2) {
        int n = AdjactantDirectedBinaryDomainCombination.calcCode(BasicDomain.obtainIdAsShort(string), BasicDomain.obtainIdAsShort(string2));
        if (ADDC_POOL.containsKey(n)) {
            return ADDC_POOL.get(n);
        }
        AdjactantDirectedBinaryDomainCombination adjactantDirectedBinaryDomainCombination = new AdjactantDirectedBinaryDomainCombination(string, string2);
        ADDC_POOL.put(n, adjactantDirectedBinaryDomainCombination);
        return adjactantDirectedBinaryDomainCombination;
    }
}

