/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CountsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;

public class DomainCountsBasedPairwiseSimilarityCalculator
implements PairwiseDomainSimilarityCalculator {
    @Override
    public PairwiseDomainSimilarity calculateSimilarity(CombinableDomains combinableDomains, CombinableDomains combinableDomains2) {
        if (!combinableDomains.getKeyDomain().equals(combinableDomains2.getKeyDomain())) {
            throw new IllegalArgumentException("attempt to calculate similarity between domain collection with different keys");
        }
        if (combinableDomains.getKeyDomainCount() > Short.MAX_VALUE || combinableDomains2.getKeyDomainCount() > Short.MAX_VALUE || combinableDomains.getKeyDomainCount() + combinableDomains2.getKeyDomainCount() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("too large for short!");
        }
        short s = (short)combinableDomains.getKeyDomainCount();
        short s2 = (short)combinableDomains2.getKeyDomainCount();
        return new CountsBasedPairwiseDomainSimilarity((short)(s - s2), (short)(s + s2));
    }
}

