/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.awt.Color;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.species.Species;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.PrintableSpeciesSpecificDcData;
import org.forester.surfacing.SurfacingConstants;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;

public class DomainSimilarity
implements Comparable<DomainSimilarity> {
    public static final String SPECIES_SEPARATOR = "  ";
    private static final int EQUAL = 0;
    private static final String NO_SPECIES = "     ";
    private static final boolean OUTPUT_TAXCODES_PER_DOMAIN = false;
    private final CombinableDomains _combinable_domains;
    private DomainSimilarityCalculator.Detailedness _detailedness;
    private final double _max;
    private final int _max_difference;
    private final int _max_difference_in_counts;
    private final double _mean;
    private final double _min;
    private final int _n;
    private final double _sd;
    private final SortedMap<Species, PrintableSpeciesSpecificDcData> _species_data;
    private List<Species> _species_order;
    private final boolean _treat_as_binary_comparison;

    public DomainSimilarity(CombinableDomains combinableDomains, double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, SortedMap<Species, PrintableSpeciesSpecificDcData> sortedMap, boolean bl, boolean bl2) {
        if (combinableDomains == null) {
            throw new IllegalArgumentException("attempt to use null combinable domains");
        }
        if (sortedMap == null) {
            throw new IllegalArgumentException("attempt to use null species data");
        }
        if (sortedMap.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty species data");
        }
        if (n < 0) {
            throw new IllegalArgumentException("attempt to use N less than 0");
        }
        if (sortedMap.size() > 1 && n < 1) {
            throw new IllegalArgumentException("attempt to use N less than 1");
        }
        if (d5 < 0.0) {
            throw new IllegalArgumentException("attempt to use negative SD");
        }
        if (d2 < d) {
            throw new IllegalArgumentException("attempt to use max smaller than min");
        }
        this.init();
        this._combinable_domains = combinableDomains;
        this._min = d;
        this._max = d2;
        this._mean = d3;
        this._sd = d5;
        this._n = n;
        this._max_difference_in_counts = n2;
        this._max_difference = n3;
        this._species_data = sortedMap;
        this._treat_as_binary_comparison = bl2;
        int n4 = sortedMap.size();
        if (n4 * n4 - n4 != this.getN() * 2) {
            throw new IllegalArgumentException("illegal species count and n: species count:" + n4 + ", n:" + this._n + " for domain " + combinableDomains.getKeyDomain());
        }
        if (n4 > 2) {
            if (this.getMaximalDifferenceInCounts() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference in counts with more than two species");
            }
            if (this.getMaximalDifference() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference with more than two species");
            }
        }
    }

    public DomainSimilarity(CombinableDomains combinableDomains, int n, int n2, SortedMap<Species, PrintableSpeciesSpecificDcData> sortedMap, boolean bl, boolean bl2) {
        if (combinableDomains == null) {
            throw new IllegalArgumentException("attempt to use null combinable domains");
        }
        if (sortedMap == null) {
            throw new IllegalArgumentException("attempt to use null species data");
        }
        if (sortedMap.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty species data");
        }
        this.init();
        this._combinable_domains = combinableDomains;
        this._min = -1.0;
        this._max = -1.0;
        this._mean = -1.0;
        this._sd = -1.0;
        this._n = -1;
        this._max_difference_in_counts = n;
        this._max_difference = n2;
        this._species_data = sortedMap;
        this._treat_as_binary_comparison = bl2;
        int n3 = sortedMap.size();
        if (n3 > 2) {
            if (this.getMaximalDifferenceInCounts() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference in counts with more than two species");
            }
            if (this.getMaximalDifference() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference with more than two species");
            }
        }
    }

    @Override
    public int compareTo(DomainSimilarity domainSimilarity) {
        if (this == domainSimilarity) {
            return 0;
        }
        if (domainSimilarity == null) {
            throw new IllegalArgumentException("attempt to compare " + this.getClass() + " to null");
        }
        if (domainSimilarity.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare " + this.getClass() + " to " + domainSimilarity.getClass());
        }
        return this.compareByDomainId(domainSimilarity);
    }

    public SortedSet<String> getCombinableDomainIds(Species species) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (this.getSpeciesData().containsKey(species)) {
            for (String string : ((PrintableSpeciesSpecificDcData)this.getSpeciesData().get(species)).getCombinableDomainIdToCountsMap().keySet()) {
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    public String getDomainId() {
        return this.getCombinableDomains().getKeyDomain();
    }

    public int getMaximalDifference() {
        return this._max_difference;
    }

    public int getMaximalDifferenceInCounts() {
        return this._max_difference_in_counts;
    }

    public double getMaximalSimilarityScore() {
        return this._max;
    }

    public double getMeanSimilarityScore() {
        return this._mean;
    }

    public double getMinimalSimilarityScore() {
        return this._min;
    }

    public int getN() {
        return this._n;
    }

    public SortedSet<Species> getSpecies() {
        TreeSet<Species> treeSet = new TreeSet<Species>();
        for (Species species : this.getSpeciesData().keySet()) {
            treeSet.add(species);
        }
        return treeSet;
    }

    public List<Species> getSpeciesCustomOrder() {
        return this._species_order;
    }

    public SortedMap<Species, PrintableSpeciesSpecificDcData> getSpeciesData() {
        return this._species_data;
    }

    public double getStandardDeviationOfSimilarityScore() {
        return this._sd;
    }

    public void setDetailedness(DomainSimilarityCalculator.Detailedness detailedness) {
        this._detailedness = detailedness;
    }

    public void setSpeciesOrder(List<Species> list) {
        if (!list.containsAll(this.getSpeciesData().keySet())) {
            throw new IllegalArgumentException("list to order species must contain all species of multiple combinable domains similarity");
        }
        this._species_order = list;
    }

    public StringBuffer toStringBuffer(PRINT_OPTION pRINT_OPTION, Map<String, Integer> map, Phylogeny phylogeny) {
        switch (pRINT_OPTION) {
            case SIMPLE_TAB_DELIMITED: {
                return this.toStringBufferSimpleTabDelimited();
            }
            case HTML: {
                return this.toStringBufferDetailedHTML(map, phylogeny, false);
            }
        }
        throw new AssertionError((Object)("Unknown print option: " + (Object)((Object)pRINT_OPTION)));
    }

    public StringBuffer getSpeciesAndSeqIdsAsStringBuffer(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Species species : this.getSpeciesData().keySet()) {
            stringBuffer.append(string);
            stringBuffer.append("\t");
            stringBuffer.append(species.getSpeciesId());
            stringBuffer.append("\t");
            stringBuffer.append(((PrintableSpeciesSpecificDcData)this.getSpeciesData().get(species)).getSeqIdsTabSeparated());
            stringBuffer.append(SurfacingConstants.NL);
        }
        return stringBuffer;
    }

    private void addSpeciesSpecificDomainData(StringBuffer stringBuffer, Species species, boolean bl, Map<String, Integer> map, Phylogeny phylogeny) {
        if (bl) {
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>");
            this.addTaxWithLink(stringBuffer, species.getSpeciesId(), map, phylogeny);
            stringBuffer.append("</td>");
        } else {
            stringBuffer.append(species.getSpeciesId());
        }
        if (this.getDetaildness() != DomainSimilarityCalculator.Detailedness.BASIC) {
            if (!bl) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(((PrintableSpeciesSpecificDcData)this.getSpeciesData().get(species)).toStringBuffer(this.getDetaildness(), bl));
        }
        if (bl) {
            stringBuffer.append("</tr>");
        } else {
            stringBuffer.append("\n\t");
        }
    }

    private void addTaxWithLink(StringBuffer stringBuffer, String string, Map<String, Integer> map, Phylogeny phylogeny) {
        String string2 = null;
        if (phylogeny != null && !phylogeny.isEmpty()) {
            string2 = SurfacingUtil.obtainHexColorStringDependingOnTaxonomyGroup(string, phylogeny);
        }
        stringBuffer.append("<b>");
        if (!ForesterUtil.isEmpty(string) && map != null && map.containsKey(string)) {
            if (!ForesterUtil.isEmpty(string2)) {
                stringBuffer.append("<a href=\"");
                stringBuffer.append("http://www.uniprot.org/taxonomy/");
                stringBuffer.append(map.get(string));
                stringBuffer.append("\" target=\"tw\"><span style=\"color:");
                stringBuffer.append(string2);
                stringBuffer.append("\">");
                stringBuffer.append(string);
                stringBuffer.append("</span></a>");
            } else {
                stringBuffer.append("<a href=\"");
                stringBuffer.append("http://www.uniprot.org/taxonomy/");
                stringBuffer.append(map.get(string));
                stringBuffer.append("\" target=\"tw\">");
                stringBuffer.append(string);
                stringBuffer.append("</a>");
            }
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append("</b>");
    }

    private int compareByDomainId(DomainSimilarity domainSimilarity) {
        return this.getDomainId().compareToIgnoreCase(domainSimilarity.getDomainId());
    }

    private CombinableDomains getCombinableDomains() {
        return this._combinable_domains;
    }

    private DomainSimilarityCalculator.Detailedness getDetaildness() {
        return this._detailedness;
    }

    private StringBuffer getDomainDataInAlphabeticalOrder() {
        TreeMap treeMap = new TreeMap();
        StringBuffer stringBuffer = new StringBuffer();
        for (Species object : this.getSpeciesData().keySet()) {
            for (String string : this.getCombinableDomainIds(object)) {
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, new TreeSet());
                }
                ((SortedSet)treeMap.get(string)).add(object.getSpeciesId());
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            stringBuffer.append("<a href=\"http://pfam.xfam.org/family/" + (String)entry.getKey() + "\">" + (String)entry.getKey() + "</a>");
            stringBuffer.append(" ");
            stringBuffer.append("<span style=\"font-size:7px\">");
            for (String string : (SortedSet)entry.getValue()) {
                String string2 = SurfacingUtil.obtainHexColorStringDependingOnTaxonomyGroup(string, null);
                if (!ForesterUtil.isEmpty(string2)) {
                    stringBuffer.append("<span style=\"color:");
                    stringBuffer.append(string2);
                    stringBuffer.append("\">");
                    stringBuffer.append(string);
                    stringBuffer.append("</span>");
                } else {
                    stringBuffer.append(string);
                }
                stringBuffer.append(" ");
            }
            stringBuffer.append("</span>");
            stringBuffer.append("<br>\n");
        }
        return stringBuffer;
    }

    private StringBuffer getSpeciesDataInAlphabeticalOrder(boolean bl, Map<String, Integer> map, Phylogeny phylogeny) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("<table>");
        }
        for (Species species : this.getSpeciesData().keySet()) {
            this.addSpeciesSpecificDomainData(stringBuffer, species, bl, map, phylogeny);
        }
        if (bl) {
            stringBuffer.append("</table>");
        }
        return stringBuffer;
    }

    private StringBuffer getSpeciesDataInCustomOrder(boolean bl, Map<String, Integer> map, Phylogeny phylogeny) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Species species : this.getSpeciesCustomOrder()) {
            if (this.getSpeciesData().keySet().contains(species)) {
                this.addSpeciesSpecificDomainData(stringBuffer, species, bl, map, phylogeny);
                continue;
            }
            stringBuffer.append(NO_SPECIES);
            stringBuffer.append(SPECIES_SEPARATOR);
        }
        return stringBuffer;
    }

    private StringBuffer getTaxonomyGroupDistribution(Phylogeny phylogeny) {
        TreeMap treeMap = new TreeMap();
        for (Species object : this.getSpeciesData().keySet()) {
            for (String string : this.getCombinableDomainIds(object)) {
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, new HashSet());
                }
                ((Set)treeMap.get(string)).add(object.getSpeciesId());
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table>");
        for (Map.Entry entry : treeMap.entrySet()) {
            Object object;
            Object object22;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (Object object22 : (Set)entry.getValue()) {
                object = SurfacingUtil.obtainTaxonomyGroup((String)object22, phylogeny);
                if (!ForesterUtil.isEmpty((String)object)) {
                    if (!hashMap.containsKey(object)) {
                        hashMap.put((String)object, 1);
                        continue;
                    }
                    hashMap.put((String)object, (Integer)hashMap.get(object) + 1);
                    continue;
                }
                return null;
            }
            TreeMap treeMap2 = new TreeMap(new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return n2.compareTo(n);
                }
            });
            object22 = hashMap.entrySet().iterator();
            while (object22.hasNext()) {
                object = (Map.Entry)object22.next();
                int n = (Integer)object.getValue();
                if (!treeMap2.containsKey(n)) {
                    treeMap2.put(n, new TreeSet());
                }
                ((SortedSet)treeMap2.get(n)).add((String)object.getKey());
            }
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>");
            stringBuffer.append("<a href=\"http://pfam.xfam.org/family/" + (String)entry.getKey() + "\">" + (String)entry.getKey() + "</a>");
            stringBuffer.append(" ");
            stringBuffer.append("</td>");
            boolean bl = true;
            for (Map.Entry entry2 : treeMap2.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append("<tr>");
                    stringBuffer.append("<td>");
                    stringBuffer.append("</td>");
                }
                stringBuffer.append("<td>");
                SortedSet sortedSet = (SortedSet)entry2.getValue();
                stringBuffer.append(entry2.getKey());
                stringBuffer.append(" ");
                for (String string : sortedSet) {
                    Color color = ForesterUtil.obtainColorDependingOnTaxonomyGroup(string);
                    if (color == null) {
                        throw new IllegalArgumentException("no color found for taxonomy group\"" + string + "\"");
                    }
                    String string2 = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                    stringBuffer.append("<span style=\"color:");
                    stringBuffer.append(string2);
                    stringBuffer.append("\">");
                    stringBuffer.append(" ");
                    stringBuffer.append(string);
                    stringBuffer.append("</span>");
                }
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
            }
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        stringBuffer.append("</table>");
        return stringBuffer;
    }

    private void init() {
        this._detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
    }

    private boolean isTreatAsBinaryComparison() {
        return this._treat_as_binary_comparison;
    }

    private StringBuffer toStringBufferDetailedHTML(Map<String, Integer> map, Phylogeny phylogeny, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>");
        stringBuffer.append("<td>");
        stringBuffer.append("<b>");
        stringBuffer.append("<a href=\"http://pfam.xfam.org/family/" + this.getDomainId() + "\" target=\"pfam_window\">" + this.getDomainId() + "</a>");
        stringBuffer.append("</b>");
        stringBuffer.append("<a name=\"" + this.getDomainId() + "\">");
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        stringBuffer.append("<a href=\"http://scholar.google.com/scholar?q=" + this.getDomainId() + "\" target=\"gs_window\">gs</a>");
        stringBuffer.append("</td>");
        if (this.getMaximalSimilarityScore() > 0.0) {
            stringBuffer.append("<td>");
            stringBuffer.append(ForesterUtil.round(this.getMeanSimilarityScore(), 3));
            stringBuffer.append("</td>");
        }
        stringBuffer.append("<td>");
        stringBuffer.append(this.getMaximalDifference());
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.isTreatAsBinaryComparison()) {
            stringBuffer.append(this.getMaximalDifferenceInCounts());
        } else {
            stringBuffer.append(Math.abs(this.getMaximalDifferenceInCounts()));
        }
        stringBuffer.append("</td>");
        if (!this.isTreatAsBinaryComparison()) {
            stringBuffer.append("<td>");
            stringBuffer.append("<b>");
            stringBuffer.append(this.getSpeciesData().size());
            stringBuffer.append("</b>");
            stringBuffer.append("</td>");
        }
        if (this.getSpeciesCustomOrder() == null || this.getSpeciesCustomOrder().isEmpty()) {
            stringBuffer.append("<td>");
            stringBuffer.append(this.getSpeciesDataInAlphabeticalOrder(true, map, phylogeny));
            if (bl) {
                stringBuffer.append(this.getDomainDataInAlphabeticalOrder());
            }
            stringBuffer.append(this.getTaxonomyGroupDistribution(phylogeny));
            stringBuffer.append("</td>");
        } else {
            stringBuffer.append("<td>");
            stringBuffer.append(this.getSpeciesDataInCustomOrder(true, map, phylogeny));
            if (bl) {
                stringBuffer.append(this.getDomainDataInAlphabeticalOrder());
            }
            stringBuffer.append(this.getTaxonomyGroupDistribution(phylogeny));
            stringBuffer.append("</td>");
        }
        stringBuffer.append("</tr>");
        return stringBuffer;
    }

    private StringBuffer toStringBufferSimpleTabDelimited() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDomainId());
        stringBuffer.append("\t");
        stringBuffer.append(this.getSpeciesDataInAlphabeticalOrder(false, null, null));
        stringBuffer.append("\n");
        return stringBuffer;
    }

    class ValueComparator
    implements Comparator<String> {
        private final Map<String, Integer> _base;

        public ValueComparator(Map<String, Integer> map) {
            this._base = map;
        }

        @Override
        public int compare(String string, String string2) {
            if (this._base.get(string) >= this._base.get(string2)) {
                return -1;
            }
            return 1;
        }
    }

    public static enum PRINT_OPTION {
        HTML,
        SIMPLE_TAB_DELIMITED;

    }

    public static enum DomainSimilaritySortField {
        ABS_MAX_COUNTS_DIFFERENCE,
        DOMAIN_ID,
        MAX,
        MAX_COUNTS_DIFFERENCE,
        MAX_DIFFERENCE,
        MEAN,
        MIN,
        SD,
        SPECIES_COUNT;

    }

    public static enum DomainSimilarityScoring {
        COMBINATIONS,
        DOMAINS,
        PROTEINS;

    }
}

