/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.species.BasicSpecies;
import org.forester.species.Species;
import org.forester.surfacing.DaioMethods;
import org.forester.surfacing.SurfacingConstants;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;

public final class MinimalDomainomeCalculator {
    /*
     * WARNING - void declaration
     */
    public static final void calc(boolean bl, Phylogeny phylogeny, int n, SortedMap<Species, List<Protein>> sortedMap, String string, double d, String string2, boolean bl2, boolean bl3, boolean bl4, File file) throws IOException {
        SortedMap<String, SortedSet<String>> sortedMap2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object62;
        Object object7;
        Object object10;
        TreeMap<String, SortedSet<String>> treeMap = new TreeMap<String, SortedSet<String>>();
        if (sortedMap == null || phylogeny == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (sortedMap.size() < 2) {
            throw new IllegalArgumentException("not enough genomes");
        }
        String string3 = bl ? "DA" : "domain";
        File file2 = new File(string2 + "_minimal_" + string3 + "ome.tsv");
        File file3 = new File(string2 + "_minimal_" + string3 + "ome_matrix.tsv");
        SurfacingUtil.checkForOutputFileWriteability(file2);
        SurfacingUtil.checkForOutputFileWriteability(file3);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file3));
        bufferedWriter.write("SPECIES\tCOMMON NAME\tCODE\tRANK\t#EXT NODES\tEXT NODE CODES\t#" + string3 + "\t" + string3 + "");
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        SortedMap<String, List<Protein>> sortedMap3 = null;
        if (n >= 1) {
            sortedMap3 = MinimalDomainomeCalculator.makeProteinListsPerQuasiSpecies(phylogeny, n, sortedMap);
        }
        Object object11 = phylogeny.iteratorPostorder();
        while (object11.hasNext()) {
            Object object8;
            Object object9;
            Object object12;
            Object object13;
            object10 = object11.next();
            int n2 = PhylogenyMethods.calculateLevel((PhylogenyNode)object10);
            String object92 = ((PhylogenyNode)object10).getNodeData().isHasTaxonomy() ? ((PhylogenyNode)object10).getNodeData().getTaxonomy().getScientificName() : ((PhylogenyNode)object10).getName();
            object7 = ((PhylogenyNode)object10).getNodeData().isHasTaxonomy() ? ((PhylogenyNode)object10).getNodeData().getTaxonomy().getCommonName() : "";
            object62 = ((PhylogenyNode)object10).getNodeData().isHasTaxonomy() ? ((PhylogenyNode)object10).getNodeData().getTaxonomy().getTaxonomyCode() : "";
            object5 = ((PhylogenyNode)object10).getNodeData().isHasTaxonomy() ? ((PhylogenyNode)object10).getNodeData().getTaxonomy().getRank() : "";
            List<PhylogenyNode> list = ((PhylogenyNode)object10).getAllExternalDescendants();
            if (n < 1 || n2 >= n) {
                bufferedWriter.write(object92);
                if (!ForesterUtil.isEmpty((String)object7)) {
                    bufferedWriter.write("\t" + (String)object7);
                } else {
                    bufferedWriter.write("\t");
                }
                if (!ForesterUtil.isEmpty((String)object62)) {
                    bufferedWriter.write("\t" + (String)object62);
                } else {
                    bufferedWriter.write("\t");
                }
                if (!ForesterUtil.isEmpty((String)object5)) {
                    bufferedWriter.write("\t" + (String)object5);
                } else {
                    bufferedWriter.write("\t");
                }
                if (((PhylogenyNode)object10).isInternal()) {
                    bufferedWriter.write("\t" + list.size() + "\t");
                } else {
                    bufferedWriter.write("\t\t");
                }
            }
            ArrayList<Set<String>> arrayList = new ArrayList<Set<String>>();
            boolean bl5 = true;
            if (n >= 1) {
                if (n2 >= n) {
                    object4 = PhylogenyMethods.getAllDescendantsOfGivenLevel((PhylogenyNode)object10, n);
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        object3 = (PhylogenyNode)iterator.next();
                        Object object14 = object2 = ((PhylogenyNode)object3).getNodeData().isHasTaxonomy() ? ((PhylogenyNode)object3).getNodeData().getTaxonomy().getScientificName() : ((PhylogenyNode)object3).getName();
                        if (((PhylogenyNode)object10).isInternal()) {
                            if (bl5) {
                                bl5 = false;
                            } else {
                                bufferedWriter.write(", ");
                            }
                            bufferedWriter.write("sp_n=" + (String)object2);
                        }
                        if ((object = (List)sortedMap3.get(object2)) != null) {
                            object13 = new TreeSet();
                            sortedMap2 = object.iterator();
                            while (sortedMap2.hasNext()) {
                                object12 = (Protein)sortedMap2.next();
                                if (bl) {
                                    object9 = object12.toDomainArchitectureString(string, d);
                                    object13.add(object9);
                                    continue;
                                }
                                object9 = object12.getProteinDomains();
                                object8 = object9.iterator();
                                while (object8.hasNext()) {
                                    Domain domain = (Domain)object8.next();
                                    if (!(d <= -1.0) && !(domain.getPerDomainEvalue() <= d)) continue;
                                    object13.add(domain.getDomainId());
                                }
                            }
                            System.out.println(">>>>>>>>>>>>>> features_per_genome.size()=" + object13.size());
                            if (object13.size() > 0) {
                                arrayList.add((Set<String>)object13);
                                continue;
                            }
                            System.out.println("error!");
                            System.exit(-1);
                            continue;
                        }
                        System.out.println("error!");
                        System.exit(-1);
                    }
                }
            } else {
                for (PhylogenyNode phylogenyNode : list) {
                    object3 = phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode();
                    if (((PhylogenyNode)object10).isInternal()) {
                        if (bl5) {
                            bl5 = false;
                        } else {
                            bufferedWriter.write(", ");
                        }
                        bufferedWriter.write((String)object3);
                    }
                    if ((object2 = (List)sortedMap.get(new BasicSpecies((String)object3))) == null) continue;
                    object = new TreeSet();
                    object13 = object2.iterator();
                    while (object13.hasNext()) {
                        sortedMap2 = (Protein)object13.next();
                        if (bl) {
                            object12 = sortedMap2.toDomainArchitectureString(string, d);
                            object.add((Object)object12);
                            continue;
                        }
                        object12 = sortedMap2.getProteinDomains();
                        object9 = object12.iterator();
                        while (object9.hasNext()) {
                            object8 = (Domain)object9.next();
                            if (!(d <= -1.0) && !(object8.getPerDomainEvalue() <= d)) continue;
                            object.add((String)object8.getDomainId());
                        }
                    }
                    if (object.size() <= 0) continue;
                    arrayList.add((Set<String>)object);
                }
            }
            if (arrayList.size() <= 0) continue;
            object4 = MinimalDomainomeCalculator.calcIntersection(arrayList);
            bufferedWriter.write("\t" + object4.size() + "\t");
            bl5 = true;
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                if (bl5) {
                    bl5 = false;
                } else {
                    bufferedWriter.write(", ");
                }
                bufferedWriter.write((String)object3);
            }
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
            treeMap.put(object92, (SortedSet<String>)object4);
        }
        object11 = new TreeSet();
        object10 = new TreeSet();
        for (Map.Entry entry : treeMap.entrySet()) {
            object11.add((String)entry.getKey());
            for (Object object62 : (SortedSet)entry.getValue()) {
                object10.add(object62);
            }
        }
        bufferedWriter2.write(9);
        boolean bl6 = true;
        Iterator iterator = object11.iterator();
        while (iterator.hasNext()) {
            object7 = (String)iterator.next();
            if (bl6) {
                bl6 = false;
            } else {
                bufferedWriter2.write(9);
            }
            bufferedWriter2.write((String)object7);
        }
        bufferedWriter2.write(ForesterUtil.LINE_SEPARATOR);
        Iterator iterator2 = object10.iterator();
        while (iterator2.hasNext()) {
            object7 = (String)iterator2.next();
            bufferedWriter2.write((String)object7);
            bufferedWriter2.write(9);
            bl6 = true;
            object62 = object11.iterator();
            while (object62.hasNext()) {
                object5 = (String)object62.next();
                if (bl6) {
                    bl6 = false;
                } else {
                    bufferedWriter2.write(9);
                }
                if (((SortedSet)treeMap.get(object5)).contains(object7)) {
                    bufferedWriter2.write(49);
                    continue;
                }
                bufferedWriter2.write(48);
            }
            bufferedWriter2.write(ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        bufferedWriter2.flush();
        bufferedWriter2.close();
        ForesterUtil.programMessage("surfacing", "Wrote minimal DAome data to           : " + file2);
        ForesterUtil.programMessage("surfacing", "Wrote minimal DAome data to (as table): " + file3);
        if (bl2) {
            void var22_30;
            if (bl) {
                object7 = "_DA";
                object62 = "domain architectures (DAs)";
                String string4 = "_DAS";
            } else {
                object7 = "_domain";
                object62 = "domains";
                String string5 = "_DOMAINS";
            }
            object5 = new File(string2 + (String)var22_30);
            boolean bl7 = ((File)object5).mkdir();
            if (!bl7) {
                throw new IOException("failed to create dir " + object5);
            }
            int n2 = 0;
            String string6 = string2 + (String)var22_30 + "/";
            object4 = new TreeMap();
            Iterator iterator3 = object10.iterator();
            while (iterator3.hasNext()) {
                object3 = (String)iterator3.next();
                object2 = new File(string6 + (String)object3 + (String)object7 + ".prot");
                SurfacingUtil.checkForOutputFileWriteability((File)object2);
                object = new BufferedWriter(new FileWriter((File)object2));
                int n3 = MinimalDomainomeCalculator.extractProteinFeatures(bl, sortedMap, (String)object3, (Writer)object, d, string);
                if (bl && bl4) {
                    sortedMap2 = MinimalDomainomeCalculator.collectSpeciesAndIdsPerDA(sortedMap, (String)object3, null, d, string);
                    if (!object4.containsKey(object3)) {
                        object4.put(object3, sortedMap2);
                    } else {
                        throw new IllegalArgumentException("DA " + (String)object3 + " is not unique");
                    }
                }
                if (n3 < 1) {
                    ForesterUtil.printWarningMessage("surfacing", (String)object3 + " not present (in " + (String)object62 + " extraction)");
                }
                n2 += n3;
                ((Writer)object).close();
            }
            if (bl && bl4) {
                File file4 = new File(string2 + "_DA_SPECIES_IDS_MAP.txt");
                object3 = new File(string2 + "_DA_NAME_MAP.txt");
                object2 = new BufferedWriter(new FileWriter(file4));
                object = new BufferedWriter(new FileWriter((File)object3));
                DaioMethods.outputSpeciesAndIdsPerDAs((SortedMap<String, SortedMap<String, SortedSet<String>>>)object4, phylogeny, (Writer)object2, "\t", ",", bl3, file, (Writer)object);
                ((BufferedWriter)object2).flush();
                ((BufferedWriter)object2).close();
                ForesterUtil.programMessage("surfacing", "Wrote DA-species-ids map to           : " + file4);
            }
            ForesterUtil.programMessage("surfacing", "Wrote " + n2 + " individual " + (String)object62 + " from a total of " + object10.size() + " into: " + string6);
        }
    }

    private static final SortedMap<String, List<Protein>> makeProteinListsPerQuasiSpecies(Phylogeny phylogeny, int n, SortedMap<Species, List<Protein>> sortedMap) {
        TreeMap<String, List<Protein>> treeMap = new TreeMap<String, List<Protein>>();
        System.out.println("---------------------------------");
        System.out.println("level=" + n);
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            int n2 = PhylogenyMethods.calculateLevel(phylogenyNode);
            if (n2 != n) continue;
            System.out.println("level=" + n);
            List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            for (PhylogenyNode phylogenyNode2 : list) {
                String string = phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode();
                List list2 = (List)sortedMap.get(new BasicSpecies(string));
                for (Protein protein : list2) {
                    arrayList.add(protein);
                }
            }
            String string = phylogenyNode.getNodeData().isHasTaxonomy() ? phylogenyNode.getNodeData().getTaxonomy().getScientificName() : phylogenyNode.getName();
            System.out.println("species_name=" + (String)string);
            treeMap.put(string, arrayList);
            System.out.println(">>>>" + arrayList.size());
        }
        return treeMap;
    }

    private static final SortedSet<String> calcIntersection(List<Set<String>> list) {
        Set<String> set = list.get(0);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : set) {
            treeSet.add(string);
        }
        for (int i = 1; i < list.size(); ++i) {
            treeSet.retainAll((Collection)list.get(i));
        }
        return treeSet;
    }

    private static final int extractProteinFeatures(boolean bl, SortedMap<Species, List<Protein>> sortedMap, String string, Writer writer, double d, String string2) throws IOException {
        int n = 0;
        for (Species species : sortedMap.keySet()) {
            List list = (List)sortedMap.get(species);
            for (Protein protein : list) {
                int n2;
                if (bl) {
                    if (!string.equals(protein.toDomainArchitectureString(string2, d))) continue;
                    int n3 = Integer.MAX_VALUE;
                    int n4 = -1;
                    for (Domain domain : protein.getProteinDomains()) {
                        if (!(d <= -1.0) && !(domain.getPerDomainEvalue() <= d)) continue;
                        if (domain.getFrom() < n3) {
                            n3 = domain.getFrom();
                        }
                        if (domain.getTo() <= n4) continue;
                        n4 = domain.getTo();
                    }
                    writer.write(protein.getSpecies().getSpeciesId());
                    writer.write("\t");
                    writer.write(protein.getProteinId().getId());
                    writer.write("\t");
                    writer.write(string);
                    writer.write("\t");
                    writer.write("/");
                    writer.write(n3 + "-" + n4);
                    writer.write("/");
                    writer.write(SurfacingConstants.NL);
                    ++n;
                    continue;
                }
                List<Domain> list2 = protein.getProteinDomains(string);
                if (list2.size() <= 0) continue;
                writer.write(protein.getSpecies().getSpeciesId());
                writer.write("\t");
                writer.write(protein.getProteinId().getId());
                writer.write("\t");
                writer.write(string);
                writer.write("\t");
                for (Domain domain : list2) {
                    if (!(d < 0.0) && !(domain.getPerDomainEvalue() <= d)) continue;
                    writer.write("/");
                    writer.write(domain.getFrom() + "-" + domain.getTo());
                }
                writer.write("/");
                writer.write("\t");
                ArrayList arrayList = new ArrayList();
                for (Domain domain : protein.getProteinDomains()) {
                    if (!(d < 0.0) && !(domain.getPerDomainEvalue() <= d)) continue;
                    arrayList.add(domain);
                }
                Domain[] domainArray = new Domain[arrayList.size()];
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    domainArray[n2] = (Domain)arrayList.get(n2);
                }
                Arrays.sort(domainArray, new SurfacingUtil.DomainComparator(true));
                writer.write("{");
                n2 = 1;
                for (Domain domain : domainArray) {
                    if (n2 != 0) {
                        n2 = 0;
                    } else {
                        writer.write(",");
                    }
                    writer.write(domain.getDomainId().toString());
                    writer.write(":" + domain.getFrom() + "-" + domain.getTo());
                    writer.write(":" + domain.getPerDomainEvalue());
                }
                writer.write("}");
                if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                    writer.write(protein.getDescription());
                }
                writer.write("\t");
                if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                    writer.write(protein.getAccession());
                }
                writer.write(SurfacingConstants.NL);
                ++n;
            }
        }
        writer.flush();
        return n;
    }

    private static final SortedMap<String, SortedSet<String>> collectSpeciesAndIdsPerDA(SortedMap<Species, List<Protein>> sortedMap, String string, Writer writer, double d, String string2) {
        TreeMap<String, SortedSet<String>> treeMap = new TreeMap<String, SortedSet<String>>();
        for (Species species : sortedMap.keySet()) {
            if (treeMap.containsKey(species.toString())) {
                throw new IllegalArgumentException("species " + species + " is not unique");
            }
            treeMap.put(species.toString(), new TreeSet());
            List list = (List)sortedMap.get(species);
            for (Protein protein : list) {
                if (!string.equals(protein.toDomainArchitectureString(string2, d))) continue;
                SortedSet sortedSet = (SortedSet)treeMap.get(species.toString());
                String string3 = "";
                Accession accession = SequenceAccessionTools.parseAccessorFromString(protein.getProteinId().getId());
                string3 = accession == null ? protein.getProteinId().getId() : accession.getValue();
                if (!sortedSet.contains(species.toString())) {
                    sortedSet.add(string3);
                    continue;
                }
                throw new IllegalArgumentException("sequence id " + string3 + " is not unique in " + species);
            }
        }
        return treeMap;
    }
}

